/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.Controlling;
import com.blamejared.controlling.client.gui.DisplayMode;
import com.blamejared.controlling.client.gui.GuiCheckBox;
import com.blamejared.controlling.client.gui.GuiNewKeyBindingList;
import com.blamejared.controlling.client.gui.SearchType;
import com.blamejared.controlling.client.gui.SortOrder;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.screen.MouseSettingsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.KeyBindingList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class GuiNewControls
extends ControlsScreen {
    private Button buttonReset;
    private final Screen parentScreen;
    private final GameSettings options;
    private String lastSearch;
    private TextFieldWidget search;
    private DisplayMode displayMode;
    private SearchType searchType;
    private SortOrder sortOrder;
    private Button buttonNone;
    private Button buttonConflicting;
    private GuiCheckBox buttonKey;
    private GuiCheckBox buttonCat;
    private Button patreonButton;
    private boolean confirmingReset = false;
    private String name;

    public GuiNewControls(Screen screen, GameSettings settings) {
        super(screen, settings);
        this.parentScreen = screen;
        this.options = settings;
    }

    protected void init() {
        this.addButton((Widget)new Button(this.width / 2 - 155, 18, 150, 20, I18n.func_135052_a((String)"options.mouse_settings", (Object[])new Object[0]), p_213126_1_ -> this.minecraft.func_147108_a((Screen)new MouseSettingsScreen((Screen)this, this.options))));
        this.addButton(AbstractOption.field_216719_z.func_216586_a(this.minecraft.field_71474_y, this.width / 2 - 155 + 160, 18, 150));
        this.field_146494_r = new GuiNewKeyBindingList(this, this.minecraft);
        this.children.add(this.field_146494_r);
        this.setFocused((IGuiEventListener)this.field_146494_r);
        this.addButton((Widget)new Button(this.width / 2 - 155 + 160, this.height - 29, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), p_213126_1_ -> this.minecraft.func_147108_a(this.parentScreen)));
        this.buttonReset = (Button)this.addButton((Widget)new Button(this.width / 2 - 155, this.height - 29, 150, 20, I18n.func_135052_a((String)"controls.resetAll", (Object[])new Object[0]), p_213126_1_ -> {
            if (!this.confirmingReset) {
                this.confirmingReset = true;
                p_213126_1_.setMessage(I18n.func_135052_a((String)"options.confirmReset", (Object[])new Object[0]));
                return;
            }
            this.confirmingReset = false;
            p_213126_1_.setMessage(I18n.func_135052_a((String)"controls.resetAll", (Object[])new Object[0]));
            for (KeyBinding keybinding : this.minecraft.field_71474_y.field_74324_K) {
                keybinding.setToDefault();
            }
            KeyBinding.func_74508_b();
        }));
        this.buttonNone = (Button)this.addButton((Widget)new Button(this.width / 2 - 155 + 160 + 76, this.height - 29 - 24, 75, 20, I18n.func_135052_a((String)"options.showNone", (Object[])new Object[0]), p_213126_1_ -> {
            if (this.displayMode == DisplayMode.NONE) {
                this.buttonNone.setMessage(I18n.func_135052_a((String)"options.showNone", (Object[])new Object[0]));
                this.displayMode = DisplayMode.ALL;
            } else {
                this.displayMode = DisplayMode.NONE;
                this.buttonNone.setMessage(I18n.func_135052_a((String)"options.showAll", (Object[])new Object[0]));
                this.buttonConflicting.setMessage(I18n.func_135052_a((String)"options.showConflicts", (Object[])new Object[0]));
            }
            this.filterKeys();
        }));
        this.buttonConflicting = (Button)this.addButton((Widget)new Button(this.width / 2 - 155 + 160, this.height - 29 - 24, 75, 20, I18n.func_135052_a((String)"options.showConflicts", (Object[])new Object[0]), p_213126_1_ -> {
            if (this.displayMode == DisplayMode.CONFLICTING) {
                this.buttonConflicting.setMessage(I18n.func_135052_a((String)"options.showConflicts", (Object[])new Object[0]));
                this.displayMode = DisplayMode.ALL;
            } else {
                this.displayMode = DisplayMode.CONFLICTING;
                this.buttonConflicting.setMessage(I18n.func_135052_a((String)"options.showAll", (Object[])new Object[0]));
                this.buttonNone.setMessage(I18n.func_135052_a((String)"options.showNone", (Object[])new Object[0]));
            }
            this.filterKeys();
        }));
        this.search = new TextFieldWidget(this.font, this.width / 2 - 154, this.height - 29 - 23, 148, 18, "");
        this.buttonKey = (GuiCheckBox)this.addButton((Widget)new GuiCheckBox(this.width / 2 - 77, this.height - 29 - 37, I18n.func_135052_a((String)"options.key", (Object[])new Object[0]), false){

            @Override
            public void onPress() {
                super.onPress();
                GuiNewControls.this.buttonCat.setIsChecked(false);
                GuiNewControls.this.searchType = this.isChecked() ? SearchType.KEY : SearchType.NAME;
                GuiNewControls.this.filterKeys();
            }
        });
        this.buttonCat = (GuiCheckBox)this.addButton((Widget)new GuiCheckBox(this.width / 2 - 77, this.height - 29 - 50, I18n.func_135052_a((String)"options.category", (Object[])new Object[0]), false){

            @Override
            public void onPress() {
                super.onPress();
                GuiNewControls.this.buttonKey.setIsChecked(false);
                GuiNewControls.this.searchType = this.isChecked() ? SearchType.CATEGORY : SearchType.NAME;
                GuiNewControls.this.filterKeys();
            }
        });
        this.name = Controlling.PATRON_LIST.stream().skip(Controlling.PATRON_LIST.isEmpty() ? 0L : (long)new Random().nextInt(Controlling.PATRON_LIST.size())).findFirst().orElse("");
        this.patreonButton = (Button)this.addButton((Widget)new Button(this.width / 2 - 155 + 160, this.height - 29 - 24 - 24, 75, 20, "Patreon", p_onPress_1_ -> Util.func_110647_a().func_195640_a("https://patreon.com/jaredlll08?s=controllingmod")){
            private boolean wasHovered;

            public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
                if (this.visible) {
                    boolean bl = this.isHovered = p_render_1_ >= this.x && p_render_2_ >= this.y && p_render_1_ < this.x + this.width && p_render_2_ < this.y + this.height;
                    if (this.wasHovered != this.isHovered()) {
                        this.nextNarration = this.isHovered() ? (this.isFocused() ? Util.func_211177_b() + 200L : Util.func_211177_b() + 750L) : Long.MAX_VALUE;
                    }
                    if (this.visible) {
                        this.renderButton(p_render_1_, p_render_2_, p_render_3_);
                    }
                    this.narrate();
                    this.wasHovered = this.isHovered();
                }
            }
        });
        this.sortOrder = SortOrder.NONE;
        Button buttonSort = (Button)this.addButton((Widget)new Button(this.width / 2 - 155 + 160 + 76, this.height - 29 - 24 - 24, 75, 20, I18n.func_135052_a((String)"options.sort", (Object[])new Object[0]) + ": " + this.sortOrder.getName(), p_213126_1_ -> {
            this.sortOrder = this.sortOrder.cycle();
            p_213126_1_.setMessage(I18n.func_135052_a((String)"options.sort", (Object[])new Object[0]) + ": " + this.sortOrder.getName());
            this.filterKeys();
        }));
        this.lastSearch = "";
        this.displayMode = DisplayMode.ALL;
        this.searchType = SearchType.NAME;
    }

    public boolean charTyped(char var1, int var2) {
        return this.search.charTyped(var1, var2);
    }

    public void tick() {
        this.search.func_146178_a();
        if (!this.lastSearch.equals(this.search.func_146179_b())) {
            this.filterKeys();
        }
    }

    public void filterKeys() {
        this.lastSearch = this.search.func_146179_b();
        this.field_146494_r.children().clear();
        if (this.lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
            this.field_146494_r.children().addAll(((GuiNewKeyBindingList)this.field_146494_r).getAllEntries());
            return;
        }
        this.field_146494_r.setScrollAmount(0.0);
        Predicate<GuiNewKeyBindingList.KeyEntry> filters = this.displayMode.getPredicate();
        switch (this.searchType) {
            case NAME: {
                filters = filters.and(keyEntry -> keyEntry.getKeyDesc().toLowerCase().contains(this.lastSearch.toLowerCase()));
                break;
            }
            case CATEGORY: {
                filters = filters.and(keyEntry -> I18n.func_135052_a((String)keyEntry.getKeybinding().func_151466_e(), (Object[])new Object[0]).toLowerCase().contains(this.lastSearch.toLowerCase()));
                break;
            }
            case KEY: {
                filters = filters.and(keyEntry -> keyEntry.getKeybinding().func_197978_k().toLowerCase().contains(this.lastSearch.toLowerCase()));
            }
        }
        for (KeyBindingList.Entry entry : ((GuiNewKeyBindingList)this.field_146494_r).getAllEntries()) {
            GuiNewKeyBindingList.KeyEntry keyEntry2;
            if (this.searchType == SearchType.CATEGORY && this.sortOrder == SortOrder.NONE && this.displayMode == DisplayMode.ALL) {
                if (entry instanceof GuiNewKeyBindingList.KeyEntry) {
                    keyEntry2 = (GuiNewKeyBindingList.KeyEntry)entry;
                    if (!filters.test(keyEntry2)) continue;
                    this.field_146494_r.children().add(entry);
                    continue;
                }
                this.field_146494_r.children().add(entry);
                continue;
            }
            if (!(entry instanceof GuiNewKeyBindingList.KeyEntry) || !filters.test(keyEntry2 = (GuiNewKeyBindingList.KeyEntry)entry)) continue;
            this.field_146494_r.children().add(entry);
        }
        if (this.searchType == SearchType.CATEGORY && this.sortOrder == SortOrder.NONE && this.displayMode == DisplayMode.ALL) {
            LinkedHashSet<GuiNewKeyBindingList.CategoryEntry> categories = new LinkedHashSet<GuiNewKeyBindingList.CategoryEntry>();
            for (KeyBindingList.Entry entry : this.field_146494_r.children()) {
                if (!(entry instanceof GuiNewKeyBindingList.CategoryEntry)) continue;
                GuiNewKeyBindingList.CategoryEntry centry = (GuiNewKeyBindingList.CategoryEntry)entry;
                categories.add(centry);
                for (KeyBindingList.Entry child : this.field_146494_r.children()) {
                    GuiNewKeyBindingList.KeyEntry childEntry;
                    if (!(child instanceof GuiNewKeyBindingList.KeyEntry) || !(childEntry = (GuiNewKeyBindingList.KeyEntry)child).getKeybinding().func_151466_e().equals(centry.getName())) continue;
                    categories.remove((Object)centry);
                }
            }
            this.field_146494_r.children().removeAll(categories);
        }
        this.sortOrder.sort(this.field_146494_r.children());
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.field_146494_r.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 8, 0xFFFFFF);
        boolean flag = false;
        for (KeyBinding keybinding : this.options.field_74324_K) {
            if (keybinding.func_197985_l()) continue;
            flag = true;
            break;
        }
        this.search.render(mouseX, mouseY, partialTicks);
        this.buttonReset.active = flag;
        if (!flag) {
            this.confirmingReset = false;
            this.buttonReset.setMessage(I18n.func_135052_a((String)"controls.resetAll", (Object[])new Object[0]));
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            ((Widget)this.buttons.get(i)).render(mouseX, mouseY, partialTicks);
        }
        String text = I18n.func_135052_a((String)"options.search", (Object[])new Object[0]);
        GlStateManager.func_227722_g_();
        this.font.func_211126_b(text, (float)(this.width / 2 - 77 - this.font.func_78256_a(text) - 5), (float)(this.height - 29 - 42), 0xFFFFFF);
        GlStateManager.func_227716_f_();
        if (this.patreonButton.isHovered()) {
            GlStateManager.func_227722_g_();
            String str = "Join " + this.name + " and other patrons!";
            this.renderTooltip(str, mouseX, mouseY);
            GlStateManager.func_227716_f_();
        }
    }

    public boolean mouseClicked(double mx, double my, int mb) {
        boolean valid;
        if (this.field_146491_f != null) {
            this.options.func_198014_a(this.field_146491_f, InputMappings.Type.MOUSE.func_197944_a(mb));
            this.field_146491_f = null;
            KeyBinding.func_74508_b();
            valid = true;
            this.search.func_146195_b(false);
        } else if (mb == 0 && this.field_146494_r.mouseClicked(mx, my, mb)) {
            this.setDragging(true);
            this.setFocused((IGuiEventListener)this.field_146494_r);
            valid = true;
            this.search.func_146195_b(false);
        } else {
            valid = this.search.mouseClicked(mx, my, mb);
            if (!valid && this.search.isFocused() && mb == 1) {
                this.search.func_146180_a("");
                valid = true;
            }
        }
        if (!valid) {
            for (IGuiEventListener iguieventlistener : this.children()) {
                if (!iguieventlistener.mouseClicked(mx, my, mb)) continue;
                this.setFocused(iguieventlistener);
                if (mb == 0) {
                    this.setDragging(true);
                }
                return true;
            }
            valid = true;
        }
        return valid;
    }

    public boolean mouseReleased(double mx, double my, int mb) {
        if (mb == 0 && this.field_146494_r.mouseReleased(mx, my, mb)) {
            this.setDragging(false);
            return true;
        }
        if (this.search.isFocused()) {
            return this.search.mouseReleased(mx, my, mb);
        }
        this.setDragging(false);
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.search.isFocused() && this.field_146491_f == null && GuiNewControls.hasControlDown() && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)70)) {
            this.search.func_146195_b(true);
            return true;
        }
        if (this.search.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (this.search.isFocused() && p_keyPressed_1_ == 256) {
            this.search.func_146195_b(false);
            return true;
        }
        if (this.field_146491_f != null) {
            if (p_keyPressed_1_ == 256) {
                this.field_146491_f.setKeyModifierAndCode(KeyModifier.getActiveModifier(), InputMappings.field_197958_a);
                this.options.func_198014_a(this.field_146491_f, InputMappings.field_197958_a);
            } else {
                this.field_146491_f.setKeyModifierAndCode(KeyModifier.getActiveModifier(), InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_));
                this.options.func_198014_a(this.field_146491_f, InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_));
            }
            if (!KeyModifier.isKeyCodeModifier((InputMappings.Input)this.field_146491_f.getKey())) {
                this.field_146491_f = null;
            }
            this.field_152177_g = Util.func_211177_b();
            KeyBinding.func_74508_b();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

