/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.KeyBindingList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiNewKeyBindingList
extends KeyBindingList {
    private final ControlsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;
    public List<KeyBindingList.Entry> allEntries;

    public GuiNewKeyBindingList(ControlsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.width = controls.width + 45;
        this.height = controls.height;
        this.y0 = 43;
        this.y1 = controls.height - 80;
        this.x1 = controls.width + 45;
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.children().clear();
        this.allEntries = new ArrayList<KeyBindingList.Entry>();
        Object[] akeybinding = (KeyBinding[])ArrayUtils.clone((Object[])mcIn.field_71474_y.field_74324_K);
        Arrays.sort(akeybinding);
        String s = null;
        for (Object keybinding : akeybinding) {
            int i;
            String s1 = keybinding.func_151466_e();
            if (!s1.equals(s)) {
                s = s1;
                if (!s1.endsWith(".hidden")) {
                    this.add(new CategoryEntry(s1));
                }
            }
            if ((i = mcIn.field_71466_p.func_78256_a(I18n.func_135052_a((String)keybinding.func_151464_g(), (Object[])new Object[0]))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = i;
            }
            if (s1.endsWith(".hidden")) continue;
            this.add(new KeyEntry((KeyBinding)keybinding));
        }
    }

    public List<KeyBindingList.Entry> getAllEntries() {
        return this.allEntries;
    }

    public void add(KeyBindingList.Entry ent) {
        this.children().add(ent);
        this.allEntries.add(ent);
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15 + 20;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends KeyBindingList.Entry {
        private final KeyBinding keybinding;
        private final String keyDesc;
        private final Button btnChangeKeyBinding;
        private final Button btnResetKeyBinding;

        private KeyEntry(final KeyBinding name) {
            this.keybinding = name;
            this.keyDesc = I18n.func_135052_a((String)name.func_151464_g(), (Object[])new Object[0]);
            this.btnChangeKeyBinding = new Button(0, 0, 95, 20, this.keyDesc, p_214386_2_ -> {
                ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).controlsScreen.field_146491_f = name;
            }){

                protected String getNarrationMessage() {
                    return name.func_197986_j() ? I18n.func_135052_a((String)"narrator.controls.unbound", (Object[])new Object[]{KeyEntry.this.keyDesc}) : I18n.func_135052_a((String)"narrator.controls.bound", (Object[])new Object[]{KeyEntry.this.keyDesc, super.getNarrationMessage()});
                }
            };
            this.btnResetKeyBinding = new Button(0, 0, 50, 20, I18n.func_135052_a((String)"controls.reset", (Object[])new Object[0]), p_214387_2_ -> {
                this.keybinding.setToDefault();
                ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).minecraft.field_71474_y.func_198014_a(name, name.func_197977_i());
                KeyBinding.func_74508_b();
            }){

                protected String getNarrationMessage() {
                    return I18n.func_135052_a((String)"narrator.controls.reset", (Object[])new Object[]{KeyEntry.this.keyDesc});
                }
            };
        }

        public void render(int slotIndex, int y, int x, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
            int i = y;
            int j = x;
            boolean flag = ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).controlsScreen.field_146491_f == this.keybinding;
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_211126_b(this.keyDesc, (float)(j + 90 - GuiNewKeyBindingList.this.maxListLabelWidth), (float)(y + p_render_5_ / 2 - 4), 0xFFFFFF);
            this.btnResetKeyBinding.x = x + 190 + 20;
            this.btnResetKeyBinding.y = y;
            this.btnResetKeyBinding.active = !this.keybinding.func_197985_l();
            this.btnResetKeyBinding.render(mouseX, mouseY, p_render_9_);
            this.btnChangeKeyBinding.x = j + 105;
            this.btnChangeKeyBinding.y = i;
            this.btnChangeKeyBinding.setMessage(this.keybinding.func_197978_k());
            boolean flag1 = false;
            boolean keyCodeModifierConflict = true;
            if (!this.keybinding.func_197986_j()) {
                for (KeyBinding keybinding : ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71474_y.field_74324_K) {
                    if (keybinding == this.keybinding || !this.keybinding.func_197983_b(keybinding)) continue;
                    flag1 = true;
                    keyCodeModifierConflict &= keybinding.hasKeyCodeModifierConflict(this.keybinding);
                }
            }
            if (flag) {
                this.btnChangeKeyBinding.setMessage(TextFormatting.WHITE + "> " + TextFormatting.YELLOW + this.btnChangeKeyBinding.getMessage() + TextFormatting.WHITE + " <");
            } else if (flag1) {
                this.btnChangeKeyBinding.setMessage((keyCodeModifierConflict ? TextFormatting.GOLD : TextFormatting.RED) + this.btnChangeKeyBinding.getMessage());
            }
            this.btnChangeKeyBinding.render(mouseX, mouseY, p_render_9_);
            if (mouseY >= y && mouseY <= y + p_render_5_) {
                ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_211126_b(I18n.func_135052_a((String)this.keybinding.func_151466_e(), (Object[])new Object[0]), (float)(mouseX + 10), (float)mouseY, 0xFFFFFF);
            }
        }

        public List<? extends IGuiEventListener> children() {
            return ImmutableList.of((Object)this.btnChangeKeyBinding, (Object)this.btnResetKeyBinding);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (this.btnChangeKeyBinding.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                return true;
            }
            return this.btnResetKeyBinding.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }

        public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
            return this.btnChangeKeyBinding.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }

        public KeyBinding getKeybinding() {
            return this.keybinding;
        }

        public String getKeyDesc() {
            return this.keyDesc;
        }

        public Button getBtnChangeKeyBinding() {
            return this.btnChangeKeyBinding;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends KeyBindingList.Entry {
        private final String labelText;
        private final int labelWidth;
        private final String name;

        public CategoryEntry(String name) {
            this.labelText = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.labelWidth = ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78256_a(this.labelText);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<? extends IGuiEventListener> children() {
            return ImmutableList.of();
        }

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).minecraft.field_71466_p.func_211126_b(this.labelText, (float)(((GuiNewKeyBindingList)GuiNewKeyBindingList.this).minecraft.field_71462_r.width / 2 - this.labelWidth / 2), (float)(p_render_2_ + p_render_5_ - 9 - 1), 0xFFFFFF);
        }
    }
}

