/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;
import top.theillusivec4.curios.api.type.util.ISlotHelper;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class CurioInventoryCapability {
    public static ICapabilityProvider createProvider(Player playerEntity) {
        return new Provider(playerEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ICuriosItemHandler> optional;
        final ICuriosItemHandler handler;

        Provider(Player playerEntity) {
            this.handler = new CurioInventoryWrapper(playerEntity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CuriosCapability.INVENTORY.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.writeTag();
        }

        public void deserializeNBT(Tag nbt) {
            this.handler.readTag(nbt);
        }
    }

    public static class CurioInventoryWrapper
    implements ICuriosItemHandler {
        Map<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
        NonNullList<ItemStack> invalidStacks = NonNullList.m_122779_();
        Player wearer;
        Set<ICurioStacksHandler> updates = new HashSet<ICurioStacksHandler>();

        public CurioInventoryWrapper(Player playerEntity) {
            this.wearer = playerEntity;
            this.reset();
        }

        @Override
        public void reset() {
            ISlotHelper slotHelper = CuriosApi.getSlotHelper();
            if (slotHelper != null && this.wearer != null && !this.wearer.m_20193_().m_5776_()) {
                this.curios.clear();
                this.invalidStacks.clear();
                TreeSet<ISlotType> sorted = new TreeSet<ISlotType>(slotHelper.getSlotTypes((LivingEntity)this.wearer));
                for (ISlotType slotType : sorted) {
                    this.curios.put(slotType.getIdentifier(), new CurioStacksHandler(this, slotType.getIdentifier(), slotType.getSize(), 0, slotType.isVisible(), slotType.hasCosmetic()));
                }
            }
        }

        @Override
        public int getSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        @Override
        public int getVisibleSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                if (!stacks.isVisible()) continue;
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        @Override
        public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
            return Optional.ofNullable(this.curios.get(identifier));
        }

        @Override
        public Map<String, ICurioStacksHandler> getCurios() {
            return Collections.unmodifiableMap(this.curios);
        }

        @Override
        public void setCurios(Map<String, ICurioStacksHandler> curios) {
            this.curios = curios;
        }

        @Override
        public void growSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.grow(amount));
            }
        }

        @Override
        public void shrinkSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.shrink(amount));
            }
        }

        @Override
        @Nullable
        public LivingEntity getWearer() {
            return this.wearer;
        }

        @Override
        public void loseInvalidStack(ItemStack stack) {
            this.invalidStacks.add((Object)stack);
        }

        @Override
        public void handleInvalidStacks() {
            if (this.wearer != null && !this.invalidStacks.isEmpty()) {
                this.invalidStacks.forEach(drop -> ItemHandlerHelper.giveItemToPlayer((Player)this.wearer, (ItemStack)drop));
                this.invalidStacks = NonNullList.m_122779_();
            }
        }

        @Override
        public int getFortuneLevel(@Nullable LootContext lootContext) {
            int fortuneLevel = 0;
            for (Map.Entry<String, ICurioStacksHandler> entry : this.getCurios().entrySet()) {
                IDynamicStackHandler stacks = entry.getValue().getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    int index = i;
                    fortuneLevel += CuriosApi.getCuriosHelper().getCurio(stacks.getStackInSlot(i)).map(curio -> curio.getFortuneLevel(new SlotContext((String)entry.getKey(), (LivingEntity)this.wearer, index, false, (Boolean)((ICurioStacksHandler)entry.getValue()).getRenders().get(index)), lootContext)).orElse(0).intValue();
                }
            }
            return fortuneLevel;
        }

        @Override
        public int getLootingLevel(DamageSource source, LivingEntity target, int baseLooting) {
            int lootingLevel = 0;
            for (Map.Entry<String, ICurioStacksHandler> entry : this.getCurios().entrySet()) {
                IDynamicStackHandler stacks = entry.getValue().getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    int index = i;
                    lootingLevel += CuriosApi.getCuriosHelper().getCurio(stacks.getStackInSlot(i)).map(curio -> curio.getLootingLevel(new SlotContext((String)entry.getKey(), (LivingEntity)this.wearer, index, false, (Boolean)((ICurioStacksHandler)entry.getValue()).getRenders().get(index)), source, target, baseLooting)).orElse(0).intValue();
                }
            }
            return lootingLevel;
        }

        @Override
        public ListTag saveInventory(boolean clear) {
            ListTag taglist = new ListTag();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                int i;
                CompoundTag tag = new CompoundTag();
                ICurioStacksHandler stacksHandler = entry.getValue();
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                tag.m_128365_("Stacks", (Tag)stacks.serializeNBT());
                tag.m_128365_("Cosmetics", (Tag)cosmetics.serializeNBT());
                tag.m_128359_("Identifier", entry.getKey());
                taglist.add((Object)tag);
                if (!clear) continue;
                for (i = 0; i < stacks.getSlots(); ++i) {
                    stacks.setStackInSlot(i, ItemStack.f_41583_);
                }
                for (i = 0; i < cosmetics.getSlots(); ++i) {
                    cosmetics.setStackInSlot(i, ItemStack.f_41583_);
                }
            }
            return taglist;
        }

        @Override
        public void loadInventory(ListTag data) {
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    CompoundTag tag = data.m_128728_(i);
                    String identifier = tag.m_128461_("Identifier");
                    ICurioStacksHandler stacksHandler = this.curios.get(identifier);
                    if (stacksHandler == null) continue;
                    CompoundTag stacksData = tag.m_128469_("Stacks");
                    ItemStackHandler loaded = new ItemStackHandler();
                    IDynamicStackHandler stacks = stacksHandler.getStacks();
                    if (!stacksData.m_128456_()) {
                        loaded.deserializeNBT(stacksData);
                        this.loadStacks(stacksHandler, loaded, stacks);
                    }
                    if ((stacksData = tag.m_128469_("Cosmetics")).m_128456_()) continue;
                    loaded.deserializeNBT(stacksData);
                    stacks = stacksHandler.getCosmeticStacks();
                    this.loadStacks(stacksHandler, loaded, stacks);
                }
            }
        }

        @Override
        public Set<ICurioStacksHandler> getUpdatingInventories() {
            return this.updates;
        }

        @Override
        public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addTransientModifier(attributeModifier);
                }
            }
        }

        @Override
        public void addPermanentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addPermanentModifier(attributeModifier);
                }
            }
        }

        @Override
        public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.removeModifier(attributeModifier.m_22209_());
                }
            }
        }

        @Override
        public void clearSlotModifiers() {
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                entry.getValue().clearModifiers();
            }
        }

        @Override
        public void clearCachedSlotModifiers() {
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                entry.getValue().clearCachedModifiers();
            }
        }

        @Override
        public Multimap<String, AttributeModifier> getModifiers() {
            HashMultimap result = HashMultimap.create();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                result.putAll((Object)entry.getKey(), entry.getValue().getModifiers().values());
            }
            return result;
        }

        private void loadStacks(ICurioStacksHandler stacksHandler, ItemStackHandler loaded, IDynamicStackHandler stacks) {
            for (int j = 0; j < stacksHandler.getSlots() && j < loaded.getSlots(); ++j) {
                ItemStack stack = stacks.getStackInSlot(j);
                ItemStack loadedStack = loaded.getStackInSlot(j);
                if (stack.m_41619_()) {
                    stacks.setStackInSlot(j, loadedStack);
                    continue;
                }
                this.loseInvalidStack(stack);
            }
        }

        @Override
        public Tag writeTag() {
            CompoundTag compound = new CompoundTag();
            ListTag taglist = new ListTag();
            this.getCurios().forEach((key, stacksHandler) -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("StacksHandler", (Tag)stacksHandler.serializeNBT());
                tag.m_128359_("Identifier", key);
                taglist.add((Object)tag);
            });
            compound.m_128365_("Curios", (Tag)taglist);
            return compound;
        }

        @Override
        public void readTag(Tag nbt) {
            ListTag tagList = ((CompoundTag)nbt).m_128437_("Curios", 10);
            ISlotHelper slotHelper = CuriosApi.getSlotHelper();
            ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
            LivingEntity livingEntity = this.getWearer();
            if (!tagList.isEmpty() && slotHelper != null) {
                LinkedHashMap<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
                TreeMap<ISlotType, ICurioStacksHandler> sortedCurios = new TreeMap<ISlotType, ICurioStacksHandler>();
                TreeSet<ISlotType> sorted = new TreeSet<ISlotType>(CuriosApi.getSlotHelper().getSlotTypes((LivingEntity)this.wearer));
                for (ISlotType slotType2 : sorted) {
                    sortedCurios.put(slotType2, new CurioStacksHandler(this, slotType2.getIdentifier(), slotType2.getSize(), 0, slotType2.isVisible(), slotType2.hasCosmetic()));
                }
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag tag = tagList.m_128728_(i);
                    String identifier = tag.m_128461_("Identifier");
                    CurioStacksHandler prevStacksHandler = new CurioStacksHandler(this, identifier);
                    prevStacksHandler.deserializeNBT(tag.m_128469_("StacksHandler"));
                    Optional<ISlotType> optionalType = CuriosApi.getSlotHelper().getSlotType(identifier);
                    optionalType.ifPresent(type -> {
                        int index;
                        CurioStacksHandler newStacksHandler = new CurioStacksHandler(this, type.getIdentifier(), type.getSize(), prevStacksHandler.getSizeShift(), type.isVisible(), type.hasCosmetic());
                        newStacksHandler.copyModifiers(prevStacksHandler);
                        for (index = 0; index < newStacksHandler.getSlots() && index < prevStacksHandler.getSlots(); ++index) {
                            ItemStack prevStack = prevStacksHandler.getStacks().getStackInSlot(index);
                            SlotContext slotContext = new SlotContext(identifier, livingEntity, index, false, (Boolean)newStacksHandler.getRenders().get(index));
                            if (!prevStack.m_41619_()) {
                                if (curiosHelper.isStackValid(slotContext, prevStack)) {
                                    newStacksHandler.getStacks().setStackInSlot(index, prevStack);
                                } else {
                                    this.loseInvalidStack(prevStack);
                                }
                            }
                            ItemStack prevCosmetic = prevStacksHandler.getCosmeticStacks().getStackInSlot(index);
                            slotContext = new SlotContext(identifier, livingEntity, index, true, true);
                            if (prevCosmetic.m_41619_()) continue;
                            if (curiosHelper.isStackValid(slotContext, prevCosmetic)) {
                                newStacksHandler.getCosmeticStacks().setStackInSlot(index, prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                                continue;
                            }
                            this.loseInvalidStack(prevCosmetic);
                        }
                        while (index < prevStacksHandler.getSlots()) {
                            this.loseInvalidStack(prevStacksHandler.getStacks().getStackInSlot(index));
                            this.loseInvalidStack(prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                            ++index;
                        }
                        sortedCurios.put((ISlotType)type, newStacksHandler);
                        for (int j = 0; j < newStacksHandler.getRenders().size() && j < prevStacksHandler.getRenders().size(); ++j) {
                            newStacksHandler.getRenders().set(j, (Object)((Boolean)prevStacksHandler.getRenders().get(j)));
                        }
                    });
                    if (!optionalType.isEmpty()) continue;
                    IDynamicStackHandler stackHandler = prevStacksHandler.getStacks();
                    IDynamicStackHandler cosmeticStackHandler = prevStacksHandler.getCosmeticStacks();
                    for (int j = 0; j < stackHandler.getSlots(); ++j) {
                        ItemStack cosmeticStack;
                        ItemStack stack = stackHandler.getStackInSlot(j);
                        if (!stack.m_41619_()) {
                            this.loseInvalidStack(stack);
                        }
                        if ((cosmeticStack = cosmeticStackHandler.getStackInSlot(j)).m_41619_()) continue;
                        this.loseInvalidStack(cosmeticStack);
                    }
                }
                sortedCurios.forEach((slotType, stacksHandler) -> curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
                this.setCurios(curios);
            }
        }
    }
}

