/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.util.TriConsumer;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class CuriosHelper
implements ICuriosHelper {
    private static final Map<String, SlotAttributeWrapper> SLOT_ATTRIBUTES = new HashMap<String, SlotAttributeWrapper>();
    private static TriConsumer<String, Integer, LivingEntity> brokenCurioConsumerLegacy;
    private static Consumer<SlotContext> brokenCurioConsumer;

    @Override
    public LazyOptional<ICurio> getCurio(ItemStack stack) {
        return stack.getCapability(CuriosCapability.ITEM);
    }

    @Override
    public LazyOptional<ICuriosItemHandler> getCuriosHandler(@Nonnull LivingEntity livingEntity) {
        return livingEntity.getCapability(CuriosCapability.INVENTORY);
    }

    @Override
    public Set<String> getCurioTags(Item item) {
        return item.getTags().stream().filter(tag -> tag.m_135827_().equals("curios")).map(ResourceLocation::m_135815_).collect(Collectors.toSet());
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getEquippedCurios(LivingEntity livingEntity) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).lazyMap(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            IItemHandlerModifiable[] itemHandlers = new IItemHandlerModifiable[curios.size()];
            int index = 0;
            for (ICurioStacksHandler stacksHandler : curios.values()) {
                if (index >= itemHandlers.length) continue;
                itemHandlers[index] = stacksHandler.getStacks();
                ++index;
            }
            return new CombinedInvWrapper(itemHandlers);
        });
    }

    @Override
    public Optional<ImmutableTriple<String, Integer, ItemStack>> findEquippedCurio(Item item, @Nonnull LivingEntity livingEntity) {
        return this.findEquippedCurio((ItemStack stack) -> stack.m_41720_() == item, livingEntity);
    }

    @Override
    @Nonnull
    public Optional<ImmutableTriple<String, Integer, ItemStack>> findEquippedCurio(Predicate<ItemStack> filter, @Nonnull LivingEntity livingEntity) {
        ImmutableTriple result = this.getCuriosHandler(livingEntity).map(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.m_41619_() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.f_41583_);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.f_41583_));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier, ItemStack stack) {
        return this.getAttributeModifiers(new SlotContext(identifier, null, 0, false, true), UUID.randomUUID(), stack);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("CurioAttributeModifiers", 9)) {
            HashMultimap multimap = HashMultimap.create();
            ListTag listnbt = stack.m_41783_().m_128437_("CurioAttributeModifiers", 10);
            String identifier = slotContext.identifier();
            for (int i = 0; i < listnbt.size(); ++i) {
                AttributeModifier attributemodifier;
                Attribute attribute;
                CompoundTag compoundnbt = listnbt.m_128728_(i);
                if (compoundnbt.m_128425_("Slot", 8) && !compoundnbt.m_128461_("Slot").equals(identifier) || (attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)compoundnbt.m_128461_("AttributeName")))) == null || (attributemodifier = AttributeModifier.m_22212_((CompoundTag)compoundnbt)) == null || attributemodifier.m_22209_().getLeastSignificantBits() == 0L || attributemodifier.m_22209_().getMostSignificantBits() == 0L) continue;
                multimap.put((Object)attribute, (Object)attributemodifier);
            }
            return multimap;
        }
        return (Multimap)this.getCurio(stack).map(curio -> curio.getAttributeModifiers(slotContext, uuid)).orElse(HashMultimap.create());
    }

    @Override
    public void addSlotModifier(Multimap<Attribute, AttributeModifier> map, String identifier, UUID uuid, double amount, AttributeModifier.Operation operation) {
        SlotAttributeWrapper att = SLOT_ATTRIBUTES.computeIfAbsent(identifier, SlotAttributeWrapper::new);
        map.put((Object)att, (Object)new AttributeModifier(uuid, identifier, amount, operation));
    }

    @Override
    public boolean isStackValid(SlotContext slotContext, ItemStack stack) {
        String id = slotContext.identifier();
        Set<String> tags = this.getCurioTags(stack.m_41720_());
        return !tags.isEmpty() && id.equals(SlotTypePreset.CURIO.getIdentifier()) || tags.contains(id) || tags.contains(SlotTypePreset.CURIO.getIdentifier());
    }

    @Override
    public void onBrokenCurio(SlotContext slotContext) {
        brokenCurioConsumer.accept(slotContext);
    }

    @Override
    public void setBrokenCurioConsumer(Consumer<SlotContext> consumer) {
        if (brokenCurioConsumer == null) {
            brokenCurioConsumer = consumer;
        }
    }

    @Override
    public void onBrokenCurio(String id, int index, LivingEntity damager) {
        brokenCurioConsumerLegacy.accept((Object)id, (Object)index, (Object)damager);
    }

    @Override
    public void setBrokenCurioConsumer(TriConsumer<String, Integer, LivingEntity> consumer) {
        if (brokenCurioConsumerLegacy == null) {
            brokenCurioConsumerLegacy = consumer;
        }
    }

    public static class SlotAttributeWrapper
    extends Attribute {
        public final String identifier;

        private SlotAttributeWrapper(String identifier) {
            super("curios.slot." + identifier, 0.0);
            this.identifier = identifier;
        }
    }
}

