/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.util;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import top.theillusivec4.curios.api.CuriosApi;

public class FortuneBonusModifier
extends LootModifier {
    protected FortuneBonusModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (tool == null || tool.m_41782_() && tool.m_41783_() != null && tool.m_41783_().m_128471_("HasCuriosFortuneBonus")) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (blockState == null || !(entity instanceof LivingEntity)) {
            return generatedLoot;
        }
        LivingEntity player = (LivingEntity)entity;
        int totalFortuneBonus = CuriosApi.getCuriosHelper().getCuriosHandler(player).map(handler -> handler.getFortuneLevel(context)).orElse(0);
        if (totalFortuneBonus <= 0) {
            return generatedLoot;
        }
        ItemStack fakeTool = tool.m_41619_() ? new ItemStack((ItemLike)Items.f_42127_) : tool.m_41777_();
        fakeTool.m_41784_().m_128379_("HasCuriosFortuneBonus", true);
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)fakeTool);
        enchantments.put(Enchantments.f_44987_, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)fakeTool) + totalFortuneBonus);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)fakeTool);
        LootContext.Builder builder = new LootContext.Builder(context);
        builder.m_78972_(LootContextParams.f_81463_, (Object)fakeTool);
        LootContext newContext = builder.m_78975_(LootContextParamSets.f_81421_);
        LootTable lootTable = context.m_78952_().m_142572_().m_129898_().m_79217_(blockState.m_60734_().m_60589_());
        return lootTable.m_79129_(newContext);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<FortuneBonusModifier> {
        public FortuneBonusModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new FortuneBonusModifier(conditions);
        }

        public JsonObject write(FortuneBonusModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

