/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import top.theillusivec4.curios.Curios;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.slottype.LegacySlotManager;

public class CuriosEntityManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final CuriosEntityManager INSTANCE = new CuriosEntityManager();
    private Map<EntityType<?>, Map<String, ISlotType>> server = ImmutableMap.of();
    private Map<EntityType<?>, Set<String>> client = ImmutableMap.of();

    public CuriosEntityManager() {
        super(GSON, "curios/entities");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @Nonnull ResourceManager pResourceManager, @Nonnull ProfilerFiller pProfiler) {
        HashMap<EntityType, ImmutableMap.Builder> map = new HashMap<EntityType, ImmutableMap.Builder>();
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : pObject.entrySet()) {
            ResourceLocation resourcelocation = entry2.getKey();
            if (resourcelocation.m_135815_().startsWith("_")) continue;
            try {
                for (Map.Entry<EntityType<?>, Map<String, ISlotType>> entry1 : CuriosEntityManager.getSlotsForEntities(GsonHelper.m_13918_((JsonElement)entry2.getValue(), (String)"top element")).entrySet()) {
                    map.computeIfAbsent(entry1.getKey(), k -> ImmutableMap.builder()).putAll(entry1.getValue());
                }
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Curios.LOGGER.error("Parsing error loading curio entity {}", (Object)resourcelocation, (Object)e);
            }
        }
        for (String s : LegacySlotManager.getImcBuilders().keySet()) {
            ImmutableMap.Builder builder = map.computeIfAbsent(EntityType.f_20532_, k -> ImmutableMap.builder());
            CuriosSlotManager.INSTANCE.getSlot(s).ifPresentOrElse(slot -> builder.put((Object)s, slot), () -> Curios.LOGGER.error("{} is not a registered slot type!", (Object)s));
        }
        this.server = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableMap.Builder)entry.getValue()).build()));
        Curios.LOGGER.info("Loaded {} curio entities", (Object)map.size());
    }

    public static ListTag getSyncPacket() {
        ListTag tag = new ListTag();
        for (Map.Entry<EntityType<?>, Map<String, ISlotType>> entry : CuriosEntityManager.INSTANCE.server.entrySet()) {
            ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey(entry.getKey());
            if (rl == null) continue;
            CompoundTag entity = new CompoundTag();
            entity.m_128359_("Entity", rl.toString());
            ListTag list = new ListTag();
            for (String s : entry.getValue().keySet()) {
                list.add((Object)StringTag.m_129297_((String)s));
            }
            entity.m_128365_("Slots", (Tag)list);
            tag.add((Object)entity);
        }
        return tag;
    }

    public static void applySyncPacket(ListTag tag) {
        HashMap<EntityType, ImmutableSet.Builder> map = new HashMap<EntityType, ImmutableSet.Builder>();
        for (Tag tag1 : tag) {
            CompoundTag entity;
            EntityType type;
            if (!(tag1 instanceof CompoundTag) || (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation((entity = (CompoundTag)tag1).m_128461_("Entity")))) == null) continue;
            ListTag list = entity.m_128437_("Slots", 8);
            for (Tag tag2 : list) {
                if (!(tag2 instanceof StringTag)) continue;
                StringTag slot = (StringTag)tag2;
                map.computeIfAbsent(type, k -> ImmutableSet.builder()).add((Object)slot.m_7916_());
            }
        }
        CuriosEntityManager.INSTANCE.client = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
    }

    private static Map<EntityType<?>, Map<String, ISlotType>> getSlotsForEntities(JsonObject jsonObject) {
        HashMap map = new HashMap();
        JsonArray jsonEntities = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"entities", (JsonArray)new JsonArray());
        ITagManager tagManager = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags());
        HashSet<EntityType> toAdd = new HashSet<EntityType>();
        for (JsonElement jsonEntity : jsonEntities) {
            String entity = jsonEntity.getAsString();
            if (entity.startsWith("#")) {
                for (EntityType entityType : tagManager.getTag(tagManager.createTagKey(new ResourceLocation(entity)))) {
                    toAdd.add(entityType);
                }
                continue;
            }
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entity));
            if (type != null) {
                toAdd.add(type);
                continue;
            }
            Curios.LOGGER.error("{} is not a registered entity type!", (Object)entity);
        }
        JsonArray jsonSlots = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"slots", (JsonArray)new JsonArray());
        HashMap slots = new HashMap();
        for (JsonElement jsonSlot : jsonSlots) {
            String id = jsonSlot.getAsString();
            CuriosSlotManager.INSTANCE.getSlot(id).ifPresentOrElse(slot -> slots.put(id, slot), () -> Curios.LOGGER.error("{} is not a registered slot type!", (Object)id));
        }
        for (EntityType entityType : toAdd) {
            map.computeIfAbsent(entityType, k -> new HashMap()).putAll(slots);
        }
        return map;
    }

    public boolean hasSlots(EntityType<?> type) {
        return this.client.containsKey(type);
    }

    public Map<String, ISlotType> getEntitySlots(EntityType<?> type) {
        if (this.server.containsKey(type)) {
            return this.server.get(type);
        }
        return ImmutableMap.of();
    }
}

