/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.EnumUtils;
import top.theillusivec4.curios.Curios;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.util.ISlotHelper;
import top.theillusivec4.curios.common.slottype.LegacySlotManager;
import top.theillusivec4.curios.common.slottype.SlotType;

public class CuriosSlotManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final CuriosSlotManager INSTANCE = new CuriosSlotManager();
    private Map<String, ISlotType> slots = ImmutableMap.of();
    private Map<String, Set<String>> idToMods = ImmutableMap.of();

    public CuriosSlotManager() {
        super(GSON, "curios/slots");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> pObject, @Nonnull ResourceManager pResourceManager, @Nonnull ProfilerFiller pProfiler) {
        String id;
        ResourceLocation resourcelocation;
        HashMap<String, SlotType.Builder> map = new HashMap<String, SlotType.Builder>();
        HashMap<String, ImmutableSet.Builder> modMap = new HashMap<String, ImmutableSet.Builder>();
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : pObject.entrySet()) {
            resourcelocation = entry2.getKey();
            if (!resourcelocation.m_135827_().equals("curios")) continue;
            try {
                id = resourcelocation.m_135815_();
                CuriosSlotManager.fromJson(map.computeIfAbsent(id, k -> new SlotType.Builder(id)), GsonHelper.m_13918_((JsonElement)entry2.getValue(), (String)"top element"));
                modMap.computeIfAbsent(id, k -> ImmutableSet.builder()).add((Object)resourcelocation.m_135827_());
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Curios.LOGGER.error("Parsing error loading curio slot {}", (Object)resourcelocation, (Object)e);
            }
        }
        for (Map.Entry<Object, Object> entry3 : LegacySlotManager.getImcBuilders().entrySet()) {
            SlotType.Builder builder = map.computeIfAbsent((String)entry3.getKey(), k -> new SlotType.Builder((String)entry2.getKey()));
            builder.apply((SlotType.Builder)entry3.getValue());
        }
        for (Map.Entry<Object, Object> entry4 : LegacySlotManager.getIdsToMods().entrySet()) {
            modMap.computeIfAbsent((String)entry4.getKey(), k -> ImmutableSet.builder()).addAll((Iterable)entry4.getValue());
        }
        for (Map.Entry<Object, Object> entry5 : pObject.entrySet()) {
            resourcelocation = (ResourceLocation)entry5.getKey();
            if (resourcelocation.m_135815_().startsWith("_") || resourcelocation.m_135827_().equals("curios")) continue;
            try {
                id = resourcelocation.m_135815_();
                CuriosSlotManager.fromJson(map.computeIfAbsent(id, k -> new SlotType.Builder(id)), GsonHelper.m_13918_((JsonElement)((JsonElement)entry5.getValue()), (String)"top element"));
                modMap.computeIfAbsent(id, k -> ImmutableSet.builder()).add((Object)resourcelocation.m_135827_());
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Curios.LOGGER.error("Parsing error loading curio slot {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.slots = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((SlotType.Builder)entry.getValue()).build()));
        this.idToMods = (Map)modMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
        Curios.LOGGER.info("Loaded {} curio slots", (Object)map.size());
        ISlotHelper slotHelper = CuriosApi.getSlotHelper();
        if (slotHelper != null) {
            slotHelper.clear();
            for (ISlotType value : this.slots.values()) {
                slotHelper.addSlotType(value);
            }
        }
    }

    public Map<String, ISlotType> getSlots() {
        return this.slots;
    }

    public Optional<ISlotType> getSlot(String id) {
        return Optional.ofNullable(this.slots.get(id));
    }

    public Map<String, Set<String>> getModsFromSlots() {
        return this.idToMods;
    }

    public static void fromJson(SlotType.Builder builder, JsonObject jsonObject) throws IllegalArgumentException, JsonParseException {
        Integer jsonSize;
        Integer n = jsonSize = jsonObject.has("size") ? Integer.valueOf(GsonHelper.m_13927_((JsonObject)jsonObject, (String)"size")) : null;
        if (jsonSize != null && jsonSize < 0) {
            throw new IllegalArgumentException("Size cannot be less than 0!");
        }
        String operation = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"operation", (String)"SET");
        if (!(operation.equals("SET") || operation.equals("ADD") || operation.equals("REMOVE"))) {
            throw new IllegalArgumentException(operation + " is not a valid operation!");
        }
        String jsonDropRule = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"drop_rule", (String)"");
        if (!jsonDropRule.isEmpty() && !EnumUtils.isValidEnum(ICurio.DropRule.class, (String)jsonDropRule)) {
            throw new IllegalArgumentException(jsonDropRule + " is not a valid drop rule!");
        }
        boolean replace = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"replace", (boolean)false);
        Integer jsonOrder = jsonObject.has("order") ? Integer.valueOf(GsonHelper.m_13927_((JsonObject)jsonObject, (String)"order")) : null;
        String jsonIcon = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"icon", (String)"");
        boolean jsonToggle = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"render_toggle", (boolean)true);
        boolean jsonCosmetic = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"add_cosmetic", (boolean)false);
        boolean jsonNative = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"use_native_gui", (boolean)true);
        if (jsonOrder != null) {
            builder.order(jsonOrder, replace);
        }
        if (!jsonIcon.isEmpty()) {
            builder.icon(new ResourceLocation(jsonIcon));
        }
        if (!jsonDropRule.isEmpty()) {
            builder.dropRule(jsonDropRule);
        }
        if (jsonSize != null) {
            builder.size(jsonSize, operation, replace);
        }
        builder.hasCosmetic(jsonCosmetic, replace);
        builder.useNativeGui(jsonNative, replace);
        builder.renderToggle(jsonToggle, replace);
    }
}

