/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.util.ExtraCodecs;
import top.theillusivec4.curios.api.SlotContext;

public record SlotPredicate(Optional<List<String>> slots, MinMaxBounds.Ints index) {
    public static final Codec<SlotPredicate> CODEC = RecordCodecBuilder.create(slotPredicateInstance -> slotPredicateInstance.group((App)ExtraCodecs.m_294263_((Codec)Codec.STRING.listOf(), (String)"slots").forGetter(SlotPredicate::slots), (App)ExtraCodecs.m_295827_((Codec)MinMaxBounds.Ints.f_290636_, (String)"index", (Object)MinMaxBounds.Ints.f_55364_).forGetter(SlotPredicate::index)).apply((Applicative)slotPredicateInstance, SlotPredicate::new));

    public boolean matches(SlotContext slotContext) {
        if (this.slots.map(sl -> !sl.contains(slotContext.identifier())).orElse(false).booleanValue()) {
            return false;
        }
        return this.index.m_55390_(slotContext.index());
    }

    public static class Builder {
        private Set<String> identifiers = new HashSet<String>();
        private MinMaxBounds.Ints indices = MinMaxBounds.Ints.f_55364_;

        private Builder() {
        }

        public static Builder slot() {
            return new Builder();
        }

        public Builder of(String ... identifiers) {
            this.identifiers = (Set)Stream.of(identifiers).collect(ImmutableSet.toImmutableSet());
            return this;
        }

        public Builder withIndex(MinMaxBounds.Ints index) {
            this.indices = index;
            return this;
        }

        public SlotPredicate build() {
            return new SlotPredicate(Optional.of(this.identifiers.stream().toList()), this.indices);
        }
    }
}

