/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.client.ICuriosScreen;
import top.theillusivec4.curios.client.CuriosClientConfig;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.client.gui.CosmeticButton;
import top.theillusivec4.curios.client.gui.CuriosButton;
import top.theillusivec4.curios.client.gui.PageButton;
import top.theillusivec4.curios.client.gui.RenderButton;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketPage;
import top.theillusivec4.curios.common.network.client.CPacketToggleRender;

public class CuriosScreen
extends EffectRenderingInventoryScreen<CuriosContainer>
implements RecipeUpdateListener,
ICuriosScreen {
    static final ResourceLocation CURIO_INVENTORY = new ResourceLocation("curios", "textures/gui/curios/inventory.png");
    private final RecipeBookComponent recipeBookGui = new RecipeBookComponent();
    public boolean widthTooNarrow;
    private ImageButton recipeBookButton;
    private CuriosButton buttonCurios;
    private CosmeticButton cosmeticButton;
    private PageButton nextPage;
    private PageButton prevPage;
    private boolean buttonClicked;
    private boolean isRenderButtonHovered;
    public int panelWidth = 0;
    private static int scrollCooldown = 0;

    public CuriosScreen(CuriosContainer curiosContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)curiosContainer, playerInventory, title);
    }

    public static Tuple<Integer, Integer> getButtonOffset(boolean isCreative) {
        CuriosClientConfig.Client client = CuriosClientConfig.CLIENT;
        CuriosClientConfig.Client.ButtonCorner corner = (CuriosClientConfig.Client.ButtonCorner)((Object)client.buttonCorner.get());
        int x = 0;
        int y = 0;
        if (isCreative) {
            x += corner.getCreativeXoffset() + (Integer)client.creativeButtonXOffset.get();
            y += corner.getCreativeYoffset() + (Integer)client.creativeButtonYOffset.get();
        } else {
            x += corner.getXoffset() + (Integer)client.buttonXOffset.get();
            y += corner.getYoffset() + (Integer)client.buttonYOffset.get();
        }
        return new Tuple((Object)x, (Object)y);
    }

    public void init() {
        if (this.minecraft != null) {
            this.panelWidth = ((CuriosContainer)this.menu).panelWidth;
            this.leftPos = (this.width - this.imageWidth) / 2;
            this.topPos = (this.height - this.imageHeight) / 2;
            this.widthTooNarrow = true;
            this.recipeBookGui.init(this.width, this.height, this.minecraft, true, (RecipeBookMenu)this.menu);
            this.addWidget((GuiEventListener)this.recipeBookGui);
            this.setInitialFocus((GuiEventListener)this.recipeBookGui);
            if (this.getMinecraft().player != null && this.getMinecraft().player.isCreative() && this.recipeBookGui.isVisible()) {
                this.recipeBookGui.toggleVisibility();
            }
            Tuple<Integer, Integer> offsets = CuriosScreen.getButtonOffset(false);
            this.buttonCurios = new CuriosButton((AbstractContainerScreen<?>)this, this.getGuiLeft() + (Integer)offsets.getA() - 2, this.height / 2 + (Integer)offsets.getB() - 2, 10, 10, CuriosButton.BIG);
            if (((Boolean)CuriosClientConfig.CLIENT.enableButton.get()).booleanValue()) {
                this.addRenderableWidget((GuiEventListener)this.buttonCurios);
            }
            if (!((CuriosContainer)this.menu).player.isCreative()) {
                this.recipeBookButton = new ImageButton(this.leftPos + 104, this.height / 2 - 22, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, button -> {
                    this.recipeBookGui.toggleVisibility();
                    button.setPosition(this.leftPos + 104, this.height / 2 - 22);
                    this.buttonCurios.setPosition(this.leftPos + (Integer)offsets.getA() + 2, this.height / 2 + (Integer)offsets.getB());
                });
                this.addRenderableWidget((GuiEventListener)this.recipeBookButton);
            }
            this.updateRenderButtons();
        }
    }

    public void updateRenderButtons() {
        this.narratables.removeIf(widget -> widget instanceof RenderButton || widget instanceof CosmeticButton || widget instanceof PageButton);
        this.children.removeIf(widget -> widget instanceof RenderButton || widget instanceof CosmeticButton || widget instanceof PageButton);
        this.renderables.removeIf(widget -> widget instanceof RenderButton || widget instanceof CosmeticButton || widget instanceof PageButton);
        this.panelWidth = ((CuriosContainer)this.menu).panelWidth;
        if (((CuriosContainer)this.menu).hasCosmetics) {
            this.cosmeticButton = new CosmeticButton(this, this.getGuiLeft() + 17, this.getGuiTop() - 18, 20, 17);
            this.addRenderableWidget((GuiEventListener)this.cosmeticButton);
        }
        if (((CuriosContainer)this.menu).totalPages > 1) {
            this.nextPage = new PageButton(this, this.getGuiLeft() + 17, this.getGuiTop() + 2, 11, 12, PageButton.Type.NEXT);
            this.addRenderableWidget((GuiEventListener)this.nextPage);
            this.prevPage = new PageButton(this, this.getGuiLeft() + 17, this.getGuiTop() + 2, 11, 12, PageButton.Type.PREVIOUS);
            this.addRenderableWidget((GuiEventListener)this.prevPage);
        }
        for (Slot inventorySlot : ((CuriosContainer)this.menu).slots) {
            if (!(inventorySlot instanceof CurioSlot)) continue;
            CurioSlot curioSlot = (CurioSlot)inventorySlot;
            if (inventorySlot instanceof CosmeticCurioSlot || !curioSlot.canToggleRender()) continue;
            this.addRenderableWidget((GuiEventListener)new RenderButton(curioSlot, this.leftPos + inventorySlot.x + 12, this.topPos + inventorySlot.y - 1, 8, 8, 75, 0, CURIO_INVENTORY, button -> NetworkHandler.INSTANCE.send((Object)new CPacketToggleRender(curioSlot.getIdentifier(), inventorySlot.getSlotIndex()), PacketDistributor.SERVER.noArg())));
        }
    }

    public void containerTick() {
        super.containerTick();
        this.recipeBookGui.tick();
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.recipeBookGui.isVisible() && this.widthTooNarrow) {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
            this.recipeBookGui.render(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            Slot slot;
            this.recipeBookGui.render(guiGraphics, mouseX, mouseY, partialTicks);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.recipeBookGui.renderGhostRecipe(guiGraphics, this.leftPos, this.topPos, true, partialTicks);
            boolean isButtonHovered = false;
            for (Renderable button : this.renderables) {
                if (!(button instanceof RenderButton)) continue;
                ((RenderButton)button).renderButtonOverlay(guiGraphics, mouseX, mouseY, partialTicks);
                if (!((RenderButton)button).isHovered()) continue;
                isButtonHovered = true;
            }
            this.isRenderButtonHovered = isButtonHovered;
            LocalPlayer clientPlayer = Minecraft.getInstance().player;
            if (!this.isRenderButtonHovered && clientPlayer != null && clientPlayer.inventoryMenu.getCarried().isEmpty() && this.getSlotUnderMouse() != null && (slot = this.getSlotUnderMouse()) instanceof CurioSlot) {
                CurioSlot slotCurio = (CurioSlot)slot;
                if (!slot.hasItem()) {
                    guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)slotCurio.getSlotName()), mouseX, mouseY);
                }
            }
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        LocalPlayer clientPlayer;
        Minecraft mc = this.minecraft;
        if (mc != null && (clientPlayer = mc.player) != null && clientPlayer.inventoryMenu.getCarried().isEmpty()) {
            if (this.isRenderButtonHovered) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.curios.toggle"), mouseX, mouseY);
            } else if (this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
                guiGraphics.renderTooltip(this.font, this.hoveredSlot.getItem(), mouseX, mouseY);
            }
        }
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.recipeBookGui.isVisible() && this.widthTooNarrow) {
            this.recipeBookGui.toggleVisibility();
            return true;
        }
        if (KeyRegistry.openCurios.isActiveAndMatches(InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            LocalPlayer playerEntity = this.getMinecraft().player;
            if (playerEntity != null) {
                playerEntity.closeContainer();
            }
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.minecraft != null && this.minecraft.player != null) {
            guiGraphics.drawString(this.font, this.title, 97, 6, 0x404040, false);
        }
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft != null && this.minecraft.player != null) {
            if (scrollCooldown > 0 && this.minecraft.player.tickCount % 5 == 0) {
                --scrollCooldown;
            }
            this.panelWidth = ((CuriosContainer)this.menu).panelWidth;
            int i = this.leftPos;
            int j = this.topPos;
            guiGraphics.blit(INVENTORY_LOCATION, i, j, 0, 0, 176, this.imageHeight);
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(i + 26), (int)(j + 8), (int)(i + 75), (int)(j + 78), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
            CuriosApi.getCuriosInventory((LivingEntity)this.minecraft.player).ifPresent(handler -> {
                int upperHeight;
                int rows;
                boolean pageOffset;
                int xOffset = -33;
                int yOffset = j;
                boolean bl = pageOffset = ((CuriosContainer)this.menu).totalPages > 1;
                if (((CuriosContainer)this.menu).hasCosmetics) {
                    guiGraphics.blit(CURIO_INVENTORY, i + xOffset + 2, yOffset - 23, 32, 0, 28, 24);
                }
                List<Integer> grid = ((CuriosContainer)this.menu).grid;
                xOffset -= (grid.size() - 1) * 18;
                for (int r = 0; r < grid.size(); ++r) {
                    rows = grid.getFirst();
                    upperHeight = 7 + rows * 18;
                    int xTexOffset = 91;
                    if (pageOffset) {
                        upperHeight += 8;
                    }
                    if (r != 0) {
                        xTexOffset += 7;
                    }
                    guiGraphics.blit(CURIO_INVENTORY, i + xOffset, yOffset, xTexOffset, 0, 25, upperHeight);
                    guiGraphics.blit(CURIO_INVENTORY, i + xOffset, yOffset + upperHeight, xTexOffset, 159, 25, 7);
                    if (grid.size() == 1) {
                        guiGraphics.blit(CURIO_INVENTORY, i + xOffset + 7, yOffset, xTexOffset += 7, 0, 25, upperHeight);
                        guiGraphics.blit(CURIO_INVENTORY, i + xOffset + 7, yOffset + upperHeight, xTexOffset, 159, 25, 7);
                    }
                    if (r == 0) {
                        xOffset += 25;
                        continue;
                    }
                    xOffset += 18;
                }
                xOffset -= grid.size() * 18;
                if (pageOffset) {
                    yOffset += 8;
                }
                Iterator iterator = grid.iterator();
                while (iterator.hasNext()) {
                    rows = iterator.next();
                    upperHeight = rows * 18;
                    guiGraphics.blit(CURIO_INVENTORY, i + xOffset, yOffset + 7, 7, 7, 18, upperHeight);
                    xOffset += 18;
                }
                RenderSystem.enableBlend();
                for (Slot slot : ((CuriosContainer)this.menu).slots) {
                    CurioSlot curioSlot;
                    if (!(slot instanceof CurioSlot) || !(curioSlot = (CurioSlot)slot).isCosmetic()) continue;
                    guiGraphics.blit(CURIO_INVENTORY, slot.x + this.getGuiLeft() - 1, slot.y + this.getGuiTop() - 1, 32, 50, 18, 18);
                }
                RenderSystem.disableBlend();
            });
        }
    }

    protected boolean isHovering(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        if (this.isRenderButtonHovered) {
            return false;
        }
        return (!this.widthTooNarrow || !this.recipeBookGui.isVisible()) && super.isHovering(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.recipeBookGui.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return this.widthTooNarrow && this.recipeBookGui.isVisible() || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseReleased1, double mouseReleased3, int mouseReleased5) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(mouseReleased1, mouseReleased3, mouseReleased5);
    }

    public boolean mouseScrolled(double p_94686_, double p_94687_, double p_94688_, double p_294830_) {
        if (((CuriosContainer)this.menu).totalPages > 1 && p_94686_ < (double)this.getGuiLeft() && p_94686_ > (double)(this.getGuiLeft() - this.panelWidth) && p_94687_ > (double)this.getGuiTop() && p_94687_ < (double)(this.getGuiTop() + this.imageHeight) && scrollCooldown <= 0) {
            NetworkHandler.INSTANCE.send((Object)new CPacketPage(((CuriosContainer)this.getMenu()).containerId, p_294830_ == -1.0), PacketDistributor.SERVER.noArg());
            scrollCooldown = 2;
        }
        return super.mouseScrolled(p_94686_, p_94687_, p_94688_, p_294830_);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean flag = mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.imageWidth) || mouseY >= (double)(guiTopIn + this.imageHeight);
        return this.recipeBookGui.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, mouseButton) && flag;
    }

    protected void slotClicked(@Nonnull Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.slotClicked(slotIn, slotId, mouseButton, type);
        this.recipeBookGui.slotClicked(slotIn);
    }

    public void recipesUpdated() {
        this.recipeBookGui.recipesUpdated();
    }

    @Nonnull
    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookGui;
    }
}

