/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class CurioInventoryCapability {
    public static ICapabilityProvider createProvider(LivingEntity livingEntity) {
        return new Provider(livingEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ICuriosItemHandler> optional;
        final ICuriosItemHandler handler;
        final LivingEntity wearer;

        Provider(LivingEntity livingEntity) {
            this.wearer = livingEntity;
            this.handler = new CurioInventoryWrapper(this.wearer);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            if (CuriosApi.getEntitySlots(this.wearer).isEmpty()) {
                return LazyOptional.empty();
            }
            return CuriosCapability.INVENTORY.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.writeTag();
        }

        public void deserializeNBT(Tag nbt) {
            this.handler.readTag(nbt);
        }
    }

    public static class CurioInventoryWrapper
    implements ICuriosItemHandler {
        Map<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
        NonNullList<ItemStack> invalidStacks = NonNullList.create();
        LivingEntity wearer;
        Set<ICurioStacksHandler> updates = new HashSet<ICurioStacksHandler>();

        public CurioInventoryWrapper(LivingEntity livingEntity) {
            this.wearer = livingEntity;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.wearer != null) {
                this.curios.clear();
                this.invalidStacks.clear();
                TreeSet<ISlotType> sorted = new TreeSet<ISlotType>(CuriosApi.getEntitySlots(this.wearer).values());
                for (ISlotType slotType : sorted) {
                    this.curios.put(slotType.getIdentifier(), new CurioStacksHandler(this, slotType.getIdentifier(), slotType.getSize(), slotType.useNativeGui(), slotType.hasCosmetic(), slotType.canToggleRendering(), slotType.getDropRule()));
                }
            }
        }

        @Override
        public int getSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        @Override
        public int getVisibleSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                if (!stacks.isVisible()) continue;
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        @Override
        public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
            return Optional.ofNullable(this.curios.get(identifier));
        }

        @Override
        public IItemHandlerModifiable getEquippedCurios() {
            Map<String, ICurioStacksHandler> curios = this.getCurios();
            IItemHandlerModifiable[] itemHandlers = new IItemHandlerModifiable[curios.size()];
            int index = 0;
            for (ICurioStacksHandler stacksHandler : curios.values()) {
                if (index >= itemHandlers.length) continue;
                itemHandlers[index] = stacksHandler.getStacks();
                ++index;
            }
            return new CombinedInvWrapper(itemHandlers);
        }

        @Override
        public void setEquippedCurio(String identifier, int index, ItemStack stack) {
            IDynamicStackHandler stackHandler;
            Map<String, ICurioStacksHandler> curios = this.getCurios();
            ICurioStacksHandler stacksHandler = curios.get(identifier);
            if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots()) {
                stackHandler.setStackInSlot(index, stack);
            }
        }

        @Override
        public Optional<SlotResult> findFirstCurio(Item item) {
            return this.findFirstCurio((ItemStack stack) -> stack.getItem() == item);
        }

        @Override
        public Optional<SlotResult> findFirstCurio(Predicate<ItemStack> filter) {
            Map<String, ICurioStacksHandler> curios = this.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.isEmpty() || !filter.test(stack)) continue;
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    return Optional.of(new SlotResult(new SlotContext(id, this.wearer, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
                }
            }
            return Optional.empty();
        }

        @Override
        public List<SlotResult> findCurios(Item item) {
            return this.findCurios((ItemStack stack) -> stack.getItem() == item);
        }

        @Override
        public List<SlotResult> findCurios(Predicate<ItemStack> filter) {
            ArrayList<SlotResult> result = new ArrayList<SlotResult>();
            Map<String, ICurioStacksHandler> curios = this.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.isEmpty() || !filter.test(stack)) continue;
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    result.add(new SlotResult(new SlotContext(id, this.wearer, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
                }
            }
            return result;
        }

        @Override
        public List<SlotResult> findCurios(String ... identifiers) {
            ArrayList<SlotResult> result = new ArrayList<SlotResult>();
            HashSet<String> ids = new HashSet<String>(List.of(identifiers));
            Map<String, ICurioStacksHandler> curios = this.getCurios();
            for (String id : curios.keySet()) {
                if (!ids.contains(id)) continue;
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    result.add(new SlotResult(new SlotContext(id, this.wearer, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
                }
            }
            return result;
        }

        @Override
        public Optional<SlotResult> findCurio(String identifier, int index) {
            ItemStack stack;
            IDynamicStackHandler stackHandler;
            Map<String, ICurioStacksHandler> curios = this.getCurios();
            ICurioStacksHandler stacksHandler = curios.get(identifier);
            if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots() && !(stack = stackHandler.getStackInSlot(index)).isEmpty()) {
                NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                return Optional.of(new SlotResult(new SlotContext(identifier, this.wearer, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false), stack));
            }
            return Optional.empty();
        }

        @Override
        public Map<String, ICurioStacksHandler> getCurios() {
            return Collections.unmodifiableMap(this.curios);
        }

        @Override
        public void setCurios(Map<String, ICurioStacksHandler> curios) {
            this.curios = curios;
        }

        @Override
        public void growSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.grow(amount));
            }
        }

        @Override
        public void shrinkSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.shrink(amount));
            }
        }

        @Override
        @Nullable
        public LivingEntity getWearer() {
            return this.wearer;
        }

        @Override
        public void loseInvalidStack(ItemStack stack) {
            this.invalidStacks.add((Object)stack);
        }

        @Override
        public void handleInvalidStacks() {
            if (this.wearer != null && !this.invalidStacks.isEmpty()) {
                LivingEntity livingEntity = this.wearer;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    this.invalidStacks.forEach(drop -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop));
                } else {
                    this.invalidStacks.forEach(drop -> {
                        ItemEntity ent = this.wearer.spawnAtLocation(drop, 1.0f);
                        RandomSource rand = this.wearer.getRandom();
                        if (ent != null) {
                            ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                        }
                    });
                }
                this.invalidStacks = NonNullList.create();
            }
        }

        @Override
        public int getFortuneLevel(@Nullable LootContext lootContext) {
            int fortuneLevel = 0;
            for (Map.Entry<String, ICurioStacksHandler> entry : this.getCurios().entrySet()) {
                IDynamicStackHandler stacks = entry.getValue().getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    int index = i;
                    fortuneLevel += CuriosApi.getCurio(stacks.getStackInSlot(i)).map(curio -> {
                        NonNullList<Boolean> renderStates = ((ICurioStacksHandler)entry.getValue()).getRenders();
                        return curio.getFortuneLevel(new SlotContext((String)entry.getKey(), this.wearer, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false), lootContext);
                    }).orElse(0).intValue();
                }
            }
            return fortuneLevel;
        }

        @Override
        public int getLootingLevel(DamageSource source, LivingEntity target, int baseLooting) {
            int lootingLevel = 0;
            for (Map.Entry<String, ICurioStacksHandler> entry : this.getCurios().entrySet()) {
                IDynamicStackHandler stacks = entry.getValue().getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    int index = i;
                    lootingLevel += CuriosApi.getCurio(stacks.getStackInSlot(i)).map(curio -> {
                        NonNullList<Boolean> renderStates = ((ICurioStacksHandler)entry.getValue()).getRenders();
                        return curio.getLootingLevel(new SlotContext((String)entry.getKey(), this.wearer, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false), source, target, baseLooting);
                    }).orElse(0).intValue();
                }
            }
            return lootingLevel;
        }

        @Override
        public ListTag saveInventory(boolean clear) {
            ListTag taglist = new ListTag();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                int i;
                CompoundTag tag = new CompoundTag();
                ICurioStacksHandler stacksHandler = entry.getValue();
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                tag.put("Stacks", (Tag)stacks.serializeNBT((HolderLookup.Provider)this.wearer.registryAccess()));
                tag.put("Cosmetics", (Tag)cosmetics.serializeNBT((HolderLookup.Provider)this.wearer.registryAccess()));
                tag.putString("Identifier", entry.getKey());
                taglist.add((Object)tag);
                if (!clear) continue;
                for (i = 0; i < stacks.getSlots(); ++i) {
                    stacks.setStackInSlot(i, ItemStack.EMPTY);
                }
                for (i = 0; i < cosmetics.getSlots(); ++i) {
                    cosmetics.setStackInSlot(i, ItemStack.EMPTY);
                }
            }
            return taglist;
        }

        @Override
        public void loadInventory(ListTag data) {
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    CompoundTag tag = data.getCompound(i);
                    String identifier = tag.getString("Identifier");
                    ICurioStacksHandler stacksHandler = this.curios.get(identifier);
                    if (stacksHandler == null) continue;
                    CompoundTag stacksData = tag.getCompound("Stacks");
                    ItemStackHandler loaded = new ItemStackHandler();
                    IDynamicStackHandler stacks = stacksHandler.getStacks();
                    if (!stacksData.isEmpty()) {
                        loaded.deserializeNBT((Tag)stacksData);
                        this.loadStacks(stacksHandler, loaded, stacks);
                    }
                    if ((stacksData = tag.getCompound("Cosmetics")).isEmpty()) continue;
                    loaded.deserializeNBT((Tag)stacksData);
                    stacks = stacksHandler.getCosmeticStacks();
                    this.loadStacks(stacksHandler, loaded, stacks);
                }
            }
        }

        @Override
        public Set<ICurioStacksHandler> getUpdatingInventories() {
            return this.updates;
        }

        @Override
        public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addTransientModifier(attributeModifier);
                }
            }
        }

        @Override
        public void addPermanentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addPermanentModifier(attributeModifier);
                }
            }
        }

        @Override
        public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.removeModifier(attributeModifier.id());
                }
            }
        }

        @Override
        public void addTransientSlotModifier(String slot, UUID uuid, String name, double amount, AttributeModifier.Operation operation) {
            LinkedHashMultimap map = LinkedHashMultimap.create();
            map.put((Object)slot, (Object)new AttributeModifier(uuid, name, amount, operation));
            this.addTransientSlotModifiers((Multimap<String, AttributeModifier>)map);
        }

        @Override
        public void addPermanentSlotModifier(String slot, UUID uuid, String name, double amount, AttributeModifier.Operation operation) {
            LinkedHashMultimap map = LinkedHashMultimap.create();
            map.put((Object)slot, (Object)new AttributeModifier(uuid, name, amount, operation));
            this.addPermanentSlotModifiers((Multimap<String, AttributeModifier>)map);
        }

        @Override
        public void removeSlotModifier(String slot, UUID uuid) {
            LinkedHashMultimap map = LinkedHashMultimap.create();
            map.put((Object)slot, (Object)new AttributeModifier(uuid, "", 0.0, AttributeModifier.Operation.ADD_VALUE));
            this.removeSlotModifiers((Multimap<String, AttributeModifier>)map);
        }

        @Override
        public void clearSlotModifiers() {
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                entry.getValue().clearModifiers();
            }
        }

        @Override
        public void clearCachedSlotModifiers() {
            HashMultimap slots = HashMultimap.create();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                ICurioStacksHandler stacksHandler = entry.getValue();
                Set<AttributeModifier> modifiers = stacksHandler.getCachedModifiers();
                if (modifiers.isEmpty()) continue;
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                String id = entry.getKey();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    SlotContext slotContext = new SlotContext(id, this.getWearer(), i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                    UUID uuid = CuriosApi.getSlotUuid(slotContext);
                    Multimap<Holder<Attribute>, AttributeModifier> map = CuriosApi.getAttributeModifiers(slotContext, uuid, stack);
                    for (Holder attribute : map.keySet()) {
                        Object object = attribute.value();
                        if (!(object instanceof SlotAttribute)) continue;
                        SlotAttribute wrapper = (SlotAttribute)((Object)object);
                        slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                    }
                }
            }
            for (Map.Entry<String, ICurioStacksHandler> entry : slots.asMap().entrySet()) {
                String id = entry.getKey();
                ICurioStacksHandler stacksHandler = this.curios.get(id);
                if (stacksHandler == null) continue;
                for (AttributeModifier attributeModifier : (Collection)((Object)entry.getValue())) {
                    stacksHandler.getCachedModifiers().remove(attributeModifier);
                }
                stacksHandler.clearCachedModifiers();
            }
        }

        @Override
        public Multimap<String, AttributeModifier> getModifiers() {
            HashMultimap result = HashMultimap.create();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                result.putAll((Object)entry.getKey(), entry.getValue().getModifiers().values());
            }
            return result;
        }

        private void loadStacks(ICurioStacksHandler stacksHandler, ItemStackHandler loaded, IDynamicStackHandler stacks) {
            for (int j = 0; j < stacksHandler.getSlots() && j < loaded.getSlots(); ++j) {
                ItemStack stack = stacks.getStackInSlot(j);
                ItemStack loadedStack = loaded.getStackInSlot(j);
                if (stack.isEmpty()) {
                    stacks.setStackInSlot(j, loadedStack);
                    continue;
                }
                this.loseInvalidStack(stack);
            }
        }

        @Override
        public Tag writeTag() {
            CompoundTag compound = new CompoundTag();
            ListTag taglist = new ListTag();
            this.getCurios().forEach((key, stacksHandler) -> {
                CompoundTag tag = new CompoundTag();
                tag.put("StacksHandler", (Tag)stacksHandler.serializeNBT());
                tag.putString("Identifier", key);
                taglist.add((Object)tag);
            });
            compound.put("Curios", (Tag)taglist);
            return compound;
        }

        @Override
        public void readTag(Tag nbt) {
            ListTag tagList = ((CompoundTag)nbt).getList("Curios", 10);
            LivingEntity livingEntity = this.getWearer();
            if (!tagList.isEmpty()) {
                LinkedHashMap<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
                TreeMap<ISlotType, ICurioStacksHandler> sortedCurios = new TreeMap<ISlotType, ICurioStacksHandler>();
                TreeSet<ISlotType> sorted = new TreeSet<ISlotType>(CuriosApi.getEntitySlots(this.wearer).values());
                for (ISlotType slotType2 : sorted) {
                    sortedCurios.put(slotType2, new CurioStacksHandler(this, slotType2.getIdentifier(), slotType2.getSize(), slotType2.useNativeGui(), slotType2.hasCosmetic(), slotType2.canToggleRendering(), slotType2.getDropRule()));
                }
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag tag = tagList.getCompound(i);
                    String identifier = tag.getString("Identifier");
                    CurioStacksHandler prevStacksHandler = new CurioStacksHandler(this, identifier);
                    prevStacksHandler.deserializeNBT(tag.getCompound("StacksHandler"));
                    Optional<ISlotType> optionalType = Optional.ofNullable(CuriosApi.getEntitySlots(this.wearer).get(identifier));
                    optionalType.ifPresent(type -> {
                        int index;
                        CurioStacksHandler newStacksHandler = new CurioStacksHandler(this, type.getIdentifier(), type.getSize(), type.useNativeGui(), type.hasCosmetic(), type.canToggleRendering(), type.getDropRule());
                        newStacksHandler.copyModifiers(prevStacksHandler);
                        for (index = 0; index < newStacksHandler.getSlots() && index < prevStacksHandler.getSlots(); ++index) {
                            ItemStack prevCosmetic;
                            ItemStack prevStack = prevStacksHandler.getStacks().getStackInSlot(index);
                            if (!prevStack.isEmpty()) {
                                if (newStacksHandler.getStacks().isItemValid(index, prevStack)) {
                                    newStacksHandler.getStacks().setStackInSlot(index, prevStack);
                                } else {
                                    this.loseInvalidStack(prevStack);
                                }
                            }
                            if ((prevCosmetic = prevStacksHandler.getCosmeticStacks().getStackInSlot(index)).isEmpty()) continue;
                            if (newStacksHandler.getStacks().isItemValid(index, prevCosmetic)) {
                                newStacksHandler.getCosmeticStacks().setStackInSlot(index, prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                                continue;
                            }
                            this.loseInvalidStack(prevCosmetic);
                        }
                        while (index < prevStacksHandler.getSlots()) {
                            this.loseInvalidStack(prevStacksHandler.getStacks().getStackInSlot(index));
                            this.loseInvalidStack(prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                            ++index;
                        }
                        sortedCurios.put((ISlotType)type, newStacksHandler);
                        for (int j = 0; j < newStacksHandler.getRenders().size() && j < prevStacksHandler.getRenders().size(); ++j) {
                            newStacksHandler.getRenders().set(j, (Object)((Boolean)prevStacksHandler.getRenders().get(j)));
                        }
                    });
                    if (!optionalType.isEmpty()) continue;
                    IDynamicStackHandler stackHandler = prevStacksHandler.getStacks();
                    IDynamicStackHandler cosmeticStackHandler = prevStacksHandler.getCosmeticStacks();
                    for (int j = 0; j < stackHandler.getSlots(); ++j) {
                        ItemStack cosmeticStack;
                        ItemStack stack = stackHandler.getStackInSlot(j);
                        if (!stack.isEmpty()) {
                            this.loseInvalidStack(stack);
                        }
                        if ((cosmeticStack = cosmeticStackHandler.getStackInSlot(j)).isEmpty()) continue;
                        this.loseInvalidStack(cosmeticStack);
                    }
                }
                sortedCurios.forEach((slotType, stacksHandler) -> curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
                this.setCurios(curios);
            }
        }
    }
}

