/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.client;

import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.SPacketGrabbedItem;

public class CPacketOpenVanilla {
    private final ItemStack carried;

    public CPacketOpenVanilla(ItemStack stack) {
        this.carried = stack;
    }

    public static void encode(CPacketOpenVanilla msg, FriendlyByteBuf buf) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)RegistryFriendlyByteBuf.decorator((RegistryAccess)NetworkHandler.REGISTRY_ACCESS).apply(buf)), (Object)msg.carried);
    }

    public static CPacketOpenVanilla decode(FriendlyByteBuf buf) {
        return new CPacketOpenVanilla((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)RegistryFriendlyByteBuf.decorator((RegistryAccess)NetworkHandler.REGISTRY_ACCESS).apply(buf))));
    }

    public static void handle(CPacketOpenVanilla msg, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender != null) {
                ItemStack stack = sender.isCreative() ? msg.carried : sender.containerMenu.getCarried();
                sender.containerMenu.setCarried(ItemStack.EMPTY);
                sender.doCloseContainer();
                if (!stack.isEmpty()) {
                    if (!sender.isCreative()) {
                        sender.containerMenu.setCarried(stack);
                    }
                    NetworkHandler.INSTANCE.send((Object)new SPacketGrabbedItem(stack), PacketDistributor.PLAYER.with((Object)sender));
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

