/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class SPacketBreak {
    private final int entityId;
    private final int slotId;
    private final String curioId;

    public SPacketBreak(int entityId, String curioId, int slotId) {
        this.entityId = entityId;
        this.slotId = slotId;
        this.curioId = curioId;
    }

    public static void encode(SPacketBreak msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeUtf(msg.curioId);
        buf.writeInt(msg.slotId);
    }

    public static SPacketBreak decode(FriendlyByteBuf buf) {
        return new SPacketBreak(buf.readInt(), buf.readUtf(), buf.readInt());
    }

    public static void handle(SPacketBreak msg, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Entity entity;
            ClientLevel world = Minecraft.getInstance().level;
            if (world != null && (entity = Minecraft.getInstance().level.getEntity(msg.entityId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CuriosApi.getCuriosInventory(livingEntity).flatMap(handler -> handler.getStacksHandler(msg.curioId)).ifPresent(stacks -> {
                    ItemStack stack = stacks.getStacks().getStackInSlot(msg.slotId);
                    Optional<ICurio> possibleCurio = CuriosApi.getCurio(stack);
                    NonNullList<Boolean> renderStates = stacks.getRenders();
                    possibleCurio.ifPresent(curio -> curio.curioBreak(new SlotContext(msg.curioId, livingEntity, msg.slotId, false, renderStates.size() > msg.slotId && (Boolean)renderStates.get(msg.slotId) != false)));
                    if (possibleCurio.isEmpty()) {
                        ICurio.playBreakAnimation(stack, livingEntity);
                    }
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

