/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;

public class SPacketSyncData {
    private final ListTag slotData;
    private final ListTag entityData;

    public SPacketSyncData(ListTag slotData, ListTag entityData) {
        this.slotData = slotData;
        this.entityData = entityData;
    }

    public static void encode(SPacketSyncData msg, FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        tag.put("SlotData", (Tag)msg.slotData);
        tag.put("EntityData", (Tag)msg.entityData);
        buf.writeNbt((Tag)tag);
    }

    public static SPacketSyncData decode(FriendlyByteBuf buf) {
        CompoundTag tag = buf.readNbt();
        if (tag != null) {
            return new SPacketSyncData(tag.getList("SlotData", 10), tag.getList("EntityData", 10));
        }
        return new SPacketSyncData(new ListTag(), new ListTag());
    }

    public static void handle(SPacketSyncData msg, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            CuriosSlotManager.applySyncPacket(msg.slotData);
            CuriosEntityManager.applySyncPacket(msg.entityData);
        });
        ctx.setPacketHandled(true);
    }
}

