/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.client.CuriosClientConfig;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.client.gui.CuriosButton;
import top.theillusivec4.curios.client.gui.RenderButton;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketToggleRender;

public class CuriosScreen
extends EffectRenderingInventoryScreen<CuriosContainer>
implements RecipeUpdateListener {
    static final ResourceLocation CURIO_INVENTORY = new ResourceLocation("curios", "textures/gui/curios/inventory.png");
    private static final ResourceLocation SCROLLER = new ResourceLocation("container/creative_inventory/scroller");
    private static float currentScroll;
    private final RecipeBookComponent recipeBookGui = new RecipeBookComponent();
    public boolean hasScrollBar;
    public boolean widthTooNarrow;
    private CuriosButton buttonCurios;
    private boolean isScrolling;
    private boolean buttonClicked;
    private boolean isRenderButtonHovered;

    public CuriosScreen(CuriosContainer curiosContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)curiosContainer, playerInventory, title);
    }

    public static Tuple<Integer, Integer> getButtonOffset(boolean isCreative) {
        CuriosClientConfig.Client client = CuriosClientConfig.CLIENT;
        CuriosClientConfig.Client.ButtonCorner corner = (CuriosClientConfig.Client.ButtonCorner)((Object)client.buttonCorner.get());
        int x = 0;
        int y = 0;
        if (isCreative) {
            x += corner.getCreativeXoffset() + (Integer)client.creativeButtonXOffset.get();
            y += corner.getCreativeYoffset() + (Integer)client.creativeButtonYOffset.get();
        } else {
            x += corner.getXoffset() + (Integer)client.buttonXOffset.get();
            y += corner.getYoffset() + (Integer)client.buttonYOffset.get();
        }
        return new Tuple((Object)x, (Object)y);
    }

    public void init() {
        super.init();
        if (this.minecraft != null) {
            if (this.minecraft.player != null) {
                this.hasScrollBar = CuriosApi.getCuriosInventory((LivingEntity)this.minecraft.player).map(handler -> handler.getVisibleSlots() > 8).orElse(false);
                if (this.hasScrollBar) {
                    ((CuriosContainer)this.menu).scrollTo(currentScroll);
                }
            }
            int neededWidth = 431;
            if (this.hasScrollBar) {
                neededWidth += 30;
            }
            if (((CuriosContainer)this.menu).hasCosmeticColumn()) {
                neededWidth += 40;
            }
            this.widthTooNarrow = this.width < neededWidth;
            this.recipeBookGui.init(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
            this.updateScreenPosition();
            this.addWidget((GuiEventListener)this.recipeBookGui);
            this.setInitialFocus((GuiEventListener)this.recipeBookGui);
            if (this.getMinecraft().player != null && this.getMinecraft().player.isCreative() && this.recipeBookGui.isVisible()) {
                this.recipeBookGui.toggleVisibility();
                this.updateScreenPosition();
            }
            Tuple<Integer, Integer> offsets = CuriosScreen.getButtonOffset(false);
            this.buttonCurios = new CuriosButton((AbstractContainerScreen<?>)this, this.getGuiLeft() + (Integer)offsets.getA() - 2, this.height / 2 + (Integer)offsets.getB() - 2, 10, 10, CuriosButton.BIG);
            this.addRenderableWidget((GuiEventListener)this.buttonCurios);
            if (!((CuriosContainer)this.menu).player.isCreative()) {
                this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 104, this.height / 2 - 22, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, button -> {
                    this.recipeBookGui.toggleVisibility();
                    this.updateScreenPosition();
                    button.setPosition(this.leftPos + 104, this.height / 2 - 22);
                    this.buttonCurios.setPosition(this.leftPos + (Integer)offsets.getA(), this.height / 2 + (Integer)offsets.getB());
                }));
            }
            this.updateRenderButtons();
        }
    }

    public void updateRenderButtons() {
        this.narratables.removeIf(widget -> widget instanceof RenderButton);
        this.children.removeIf(widget -> widget instanceof RenderButton);
        this.renderables.removeIf(widget -> widget instanceof RenderButton);
        for (Slot inventorySlot : ((CuriosContainer)this.menu).slots) {
            if (!(inventorySlot instanceof CurioSlot)) continue;
            CurioSlot curioSlot = (CurioSlot)inventorySlot;
            if (inventorySlot instanceof CosmeticCurioSlot || !curioSlot.canToggleRender()) continue;
            this.addRenderableWidget((GuiEventListener)new RenderButton(curioSlot, this.leftPos + inventorySlot.x + 11, this.topPos + inventorySlot.y - 3, 8, 8, 75, 0, CURIO_INVENTORY, button -> NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketToggleRender(curioSlot.getIdentifier(), inventorySlot.getSlotIndex()))));
        }
    }

    private void updateScreenPosition() {
        int i;
        if (this.recipeBookGui.isVisible() && !this.widthTooNarrow) {
            int offset = 148;
            if (this.hasScrollBar) {
                offset -= 30;
            }
            if (((CuriosContainer)this.menu).hasCosmeticColumn()) {
                offset -= 40;
            }
            i = 177 + (this.width - this.imageWidth - offset) / 2;
        } else {
            i = (this.width - this.imageWidth) / 2;
        }
        this.leftPos = i;
        this.updateRenderButtons();
    }

    public void containerTick() {
        super.containerTick();
        this.recipeBookGui.tick();
    }

    private boolean inScrollBar(double mouseX, double mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        int k = i - 34;
        int l = j + 12;
        int i1 = k + 14;
        int j1 = l + 139;
        if (((CuriosContainer)this.menu).hasCosmeticColumn()) {
            i1 -= 19;
            k -= 19;
        }
        return mouseX >= (double)k && mouseY >= (double)l && mouseX < (double)i1 && mouseY < (double)j1;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.recipeBookGui.isVisible() && this.widthTooNarrow) {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
            this.recipeBookGui.render(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            Slot slot;
            this.recipeBookGui.render(guiGraphics, mouseX, mouseY, partialTicks);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.recipeBookGui.renderGhostRecipe(guiGraphics, this.leftPos, this.topPos, true, partialTicks);
            boolean isButtonHovered = false;
            for (Renderable button : this.renderables) {
                if (!(button instanceof RenderButton)) continue;
                ((RenderButton)button).renderButtonOverlay(guiGraphics, mouseX, mouseY, partialTicks);
                if (!((RenderButton)button).isHovered()) continue;
                isButtonHovered = true;
            }
            this.isRenderButtonHovered = isButtonHovered;
            LocalPlayer clientPlayer = Minecraft.getInstance().player;
            if (!this.isRenderButtonHovered && clientPlayer != null && clientPlayer.inventoryMenu.getCarried().isEmpty() && this.getSlotUnderMouse() != null && (slot = this.getSlotUnderMouse()) instanceof CurioSlot) {
                CurioSlot slotCurio = (CurioSlot)slot;
                if (!slot.hasItem()) {
                    guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)slotCurio.getSlotName()), mouseX, mouseY);
                }
            }
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        LocalPlayer clientPlayer;
        Minecraft mc = this.minecraft;
        if (mc != null && (clientPlayer = mc.player) != null && clientPlayer.inventoryMenu.getCarried().isEmpty()) {
            if (this.isRenderButtonHovered) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.curios.toggle"), mouseX, mouseY);
            } else if (this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
                guiGraphics.renderTooltip(this.font, this.hoveredSlot.getItem(), mouseX, mouseY);
            }
        }
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.recipeBookGui.isVisible() && this.widthTooNarrow) {
            this.recipeBookGui.toggleVisibility();
            this.updateScreenPosition();
            return true;
        }
        if (KeyRegistry.openCurios.isActiveAndMatches(InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            LocalPlayer playerEntity = this.getMinecraft().player;
            if (playerEntity != null) {
                playerEntity.closeContainer();
            }
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.minecraft != null && this.minecraft.player != null) {
            guiGraphics.drawString(this.font, this.title, 97, 6, 0x404040, false);
        }
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft != null && this.minecraft.player != null) {
            int i = this.leftPos;
            int j = this.topPos;
            guiGraphics.blit(INVENTORY_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(i + 26), (int)(j + 8), (int)(i + 75), (int)(j + 78), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
            CuriosApi.getCuriosInventory((LivingEntity)this.minecraft.player).ifPresent(handler -> {
                int slotCount = handler.getVisibleSlots();
                if (slotCount > 0) {
                    int upperHeight = 7 + Math.min(slotCount, 9) * 18;
                    int xTexOffset = 0;
                    int width = 27;
                    int xOffset = -26;
                    if (((CuriosContainer)this.menu).hasCosmeticColumn()) {
                        xTexOffset = 92;
                        width = 46;
                        xOffset -= 19;
                    }
                    guiGraphics.blit(CURIO_INVENTORY, i + xOffset, j + 4, xTexOffset, 0, width, upperHeight);
                    if (slotCount <= 8) {
                        guiGraphics.blit(CURIO_INVENTORY, i + xOffset, j + 4 + upperHeight, xTexOffset, 151, width, 7);
                    } else {
                        guiGraphics.blit(CURIO_INVENTORY, i + xOffset - 16, j + 4, 27, 0, 23, 158);
                        guiGraphics.blitSprite(SCROLLER, i + xOffset - 8, j + 12 + (int)(127.0f * currentScroll), 12, 15);
                    }
                    for (Slot slot : ((CuriosContainer)this.menu).slots) {
                        if (!(slot instanceof CosmeticCurioSlot)) continue;
                        int x = this.leftPos + slot.x - 1;
                        int y = this.topPos + slot.y - 1;
                        guiGraphics.blit(CURIO_INVENTORY, x, y, 138, 0, 18, 18);
                    }
                }
            });
        }
    }

    protected boolean isHovering(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        if (this.isRenderButtonHovered) {
            return false;
        }
        return (!this.widthTooNarrow || !this.recipeBookGui.isVisible()) && super.isHovering(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.recipeBookGui.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.inScrollBar(mouseX, mouseY)) {
            this.isScrolling = this.needsScrollBars();
            return true;
        }
        return this.widthTooNarrow && this.recipeBookGui.isVisible() || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseReleased1, double mouseReleased3, int mouseReleased5) {
        if (mouseReleased5 == 0) {
            this.isScrolling = false;
        }
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(mouseReleased1, mouseReleased3, mouseReleased5);
    }

    public boolean mouseDragged(double pMouseDragged1, double pMouseDragged3, int pMouseDragged5, double pMouseDragged6, double pMouseDragged8) {
        if (this.isScrolling) {
            int i = this.topPos + 8;
            int j = i + 148;
            currentScroll = ((float)pMouseDragged3 - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            currentScroll = Mth.clamp((float)currentScroll, (float)0.0f, (float)1.0f);
            ((CuriosContainer)this.menu).scrollTo(currentScroll);
            return true;
        }
        return super.mouseDragged(pMouseDragged1, pMouseDragged3, pMouseDragged5, pMouseDragged6, pMouseDragged8);
    }

    public boolean mouseScrolled(double pMouseScrolled1, double pMouseScrolled3, double pMouseScrolled5, double dragY) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = 1;
        if (((CuriosContainer)this.menu).curiosHandler != null) {
            i = ((CuriosContainer)this.menu).curiosHandler.getVisibleSlots();
        }
        currentScroll = (float)((double)currentScroll - dragY / (double)i);
        currentScroll = Mth.clamp((float)currentScroll, (float)0.0f, (float)1.0f);
        ((CuriosContainer)this.menu).scrollTo(currentScroll);
        return true;
    }

    private boolean needsScrollBars() {
        return ((CuriosContainer)this.menu).canScroll();
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean flag = mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.imageWidth) || mouseY >= (double)(guiTopIn + this.imageHeight);
        return this.recipeBookGui.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, mouseButton) && flag;
    }

    protected void slotClicked(@Nonnull Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.slotClicked(slotIn, slotId, mouseButton, type);
        this.recipeBookGui.slotClicked(slotIn);
    }

    public void recipesUpdated() {
        this.recipeBookGui.recipesUpdated();
    }

    @Nonnull
    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookGui;
    }
}

