/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.conditions.ICondition;
import top.theillusivec4.curios.Curios;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.slottype.LegacySlotManager;

public class CuriosEntityManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static CuriosEntityManager INSTANCE = new CuriosEntityManager();
    private Map<EntityType<?>, Map<String, ISlotType>> server = ImmutableMap.of();
    private Map<String, Set<String>> idToMods = ImmutableMap.of();
    private Map<EntityType<?>, Map<String, Integer>> client = ImmutableMap.of();
    private ICondition.IContext ctx = ICondition.IContext.EMPTY;

    public CuriosEntityManager() {
        super(GSON, "curios/entities");
    }

    public CuriosEntityManager(ICondition.IContext ctx) {
        super(GSON, "curios/entities");
        this.ctx = ctx;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @Nonnull ResourceManager pResourceManager, @Nonnull ProfilerFiller pProfiler) {
        HashMap<Object, ImmutableMap.Builder> map = new HashMap<Object, ImmutableMap.Builder>();
        HashMap<String, ImmutableSet.Builder> modMap = new HashMap<String, ImmutableSet.Builder>();
        LinkedHashMap sorted = new LinkedHashMap();
        pResourceManager.listPacks().forEach(packResources -> {
            Set namespaces = packResources.getNamespaces(PackType.SERVER_DATA);
            namespaces.forEach(namespace -> packResources.listResources(PackType.SERVER_DATA, namespace, "curios/entities", (resourceLocation, inputStreamIoSupplier) -> {
                String path = resourceLocation.getPath();
                ResourceLocation rl = new ResourceLocation(namespace, path.substring("curios/entities/".length(), path.length() - ".json".length()));
                JsonElement el = (JsonElement)pObject.get(rl);
                if (el != null) {
                    sorted.put(rl, el);
                }
            }));
        });
        for (String string : LegacySlotManager.getImcBuilders().keySet()) {
            ImmutableMap.Builder builder = map.computeIfAbsent(EntityType.PLAYER, k -> ImmutableMap.builder());
            CuriosSlotManager.INSTANCE.getSlot(string).ifPresentOrElse(slot -> builder.put((Object)s, slot), () -> Curios.LOGGER.error("{} is not a registered slot type!", (Object)s));
        }
        for (Map.Entry entry2 : sorted.entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry2.getKey();
            if (resourcelocation.getPath().startsWith("_")) continue;
            try {
                JsonObject jsonObject = GsonHelper.convertToJsonObject((JsonElement)((JsonElement)entry2.getValue()), (String)"top element");
                for (Map.Entry<EntityType<?>, Map<String, ISlotType>> entry1 : CuriosEntityManager.getSlotsForEntities(jsonObject, resourcelocation, this.ctx).entrySet()) {
                    if (GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"replace", (boolean)false)) {
                        ImmutableMap.Builder builder = ImmutableMap.builder();
                        builder.putAll(entry1.getValue());
                        map.put(entry1.getKey(), builder);
                    } else {
                        map.computeIfAbsent(entry1.getKey(), k -> ImmutableMap.builder()).putAll(entry1.getValue());
                    }
                    modMap.computeIfAbsent(resourcelocation.getPath(), k -> ImmutableSet.builder()).add((Object)resourcelocation.getNamespace());
                }
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Curios.LOGGER.error("Parsing error loading curio entity {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.server = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableMap.Builder)entry.getValue()).buildKeepingLast()));
        this.idToMods = (Map)modMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
        Curios.LOGGER.info("Loaded {} curio entities", (Object)map.size());
    }

    public static ListTag getSyncPacket() {
        ListTag tag = new ListTag();
        for (Map.Entry<EntityType<?>, Map<String, ISlotType>> entry : CuriosEntityManager.INSTANCE.server.entrySet()) {
            ResourceLocation rl = BuiltInRegistries.ENTITY_TYPE.getKey(entry.getKey());
            CompoundTag entity = new CompoundTag();
            entity.putString("Entity", rl.toString());
            CompoundTag tag1 = new CompoundTag();
            for (Map.Entry<String, ISlotType> val : entry.getValue().entrySet()) {
                tag1.put(val.getKey(), (Tag)IntTag.valueOf((int)val.getValue().getSize()));
            }
            entity.put("Slots", (Tag)tag1);
            tag.add((Object)entity);
        }
        return tag;
    }

    public static void applySyncPacket(ListTag tag) {
        HashMap<EntityType, ImmutableMap.Builder> map = new HashMap<EntityType, ImmutableMap.Builder>();
        for (Tag tag1 : tag) {
            CompoundTag entity;
            EntityType type;
            if (!(tag1 instanceof CompoundTag) || (type = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(new ResourceLocation((entity = (CompoundTag)tag1).getString("Entity"))).orElse(null)) == null) continue;
            CompoundTag slots = entity.getCompound("Slots");
            for (String key : slots.getAllKeys()) {
                int size = slots.getInt(key);
                map.computeIfAbsent(type, k -> ImmutableMap.builder()).put((Object)key, (Object)size);
            }
        }
        CuriosEntityManager.INSTANCE.client = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableMap.Builder)entry.getValue()).build()));
    }

    private static Map<EntityType<?>, Map<String, ISlotType>> getSlotsForEntities(JsonObject jsonObject, ResourceLocation resourceLocation, ICondition.IContext ctx) {
        HashMap map = new HashMap();
        if (!ICondition.conditionsMatched((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject)) {
            Curios.LOGGER.debug("Skipping loading entity file {} as its conditions were not met", (Object)resourceLocation);
            return map;
        }
        JsonArray jsonEntities = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"entities", (JsonArray)new JsonArray());
        HashSet<EntityType> toAdd = new HashSet<EntityType>();
        for (JsonElement jsonEntity : jsonEntities) {
            String entity = jsonEntity.getAsString();
            if (entity.startsWith("#")) {
                BuiltInRegistries.ENTITY_TYPE.getTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)new ResourceLocation(entity))).ifPresent(named -> {
                    for (Holder entityTypeHolder : named) {
                        toAdd.add((EntityType)entityTypeHolder.value());
                    }
                });
                continue;
            }
            EntityType type = BuiltInRegistries.ENTITY_TYPE.getOptional(new ResourceLocation(entity)).orElse(null);
            if (type != null) {
                toAdd.add(type);
                continue;
            }
            Curios.LOGGER.error("{} is not a registered entity type!", (Object)entity);
        }
        JsonArray jsonSlots = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"slots", (JsonArray)new JsonArray());
        HashMap slots = new HashMap();
        for (JsonElement jsonSlot : jsonSlots) {
            String id = jsonSlot.getAsString();
            CuriosSlotManager.INSTANCE.getSlot(id).ifPresentOrElse(slot -> slots.put(id, slot), () -> Curios.LOGGER.error("{} is not a registered slot type!", (Object)id));
        }
        for (EntityType entityType : toAdd) {
            map.computeIfAbsent(entityType, k -> new HashMap()).putAll(slots);
        }
        return map;
    }

    public boolean hasSlots(EntityType<?> type) {
        return this.client.containsKey(type);
    }

    public Map<String, Integer> getClientSlots(EntityType<?> type) {
        if (this.client.containsKey(type)) {
            return this.client.get(type);
        }
        return ImmutableMap.of();
    }

    public Map<String, ISlotType> getEntitySlots(EntityType<?> type) {
        if (this.server.containsKey(type)) {
            return this.server.get(type);
        }
        return ImmutableMap.of();
    }

    public Map<String, Set<String>> getModsFromSlots() {
        return ImmutableMap.copyOf(this.idToMods);
    }
}

