/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.apache.commons.lang3.EnumUtils;
import top.theillusivec4.curios.Curios;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.slottype.LegacySlotManager;
import top.theillusivec4.curios.common.slottype.SlotType;

public class CuriosSlotManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static CuriosSlotManager INSTANCE = new CuriosSlotManager();
    private Map<String, ISlotType> slots = ImmutableMap.of();
    private Map<String, ResourceLocation> icons = ImmutableMap.of();
    private Map<String, Set<String>> idToMods = ImmutableMap.of();
    private ICondition.IContext ctx = ICondition.IContext.EMPTY;

    public CuriosSlotManager() {
        super(GSON, "curios/slots");
    }

    public CuriosSlotManager(ICondition.IContext ctx) {
        super(GSON, "curios/slots");
        this.ctx = ctx;
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> pObject, @Nonnull ResourceManager pResourceManager, @Nonnull ProfilerFiller pProfiler) {
        String id;
        ResourceLocation resourcelocation;
        HashMap<String, SlotType.Builder> map = new HashMap<String, SlotType.Builder>();
        HashMap<String, ImmutableSet.Builder> modMap = new HashMap<String, ImmutableSet.Builder>();
        LinkedHashMap sorted = new LinkedHashMap();
        pResourceManager.listPacks().forEach(packResources -> {
            Set namespaces = packResources.getNamespaces(PackType.SERVER_DATA);
            namespaces.forEach(namespace -> packResources.listResources(PackType.SERVER_DATA, namespace, "curios/slots", (resourceLocation, inputStreamIoSupplier) -> {
                String path = resourceLocation.getPath();
                ResourceLocation rl = new ResourceLocation(namespace, path.substring("curios/slots/".length(), path.length() - ".json".length()));
                JsonElement el = (JsonElement)pObject.get(rl);
                if (el != null) {
                    sorted.put(rl, el);
                }
            }));
        });
        for (Map.Entry entry2 : sorted.entrySet()) {
            resourcelocation = (ResourceLocation)entry2.getKey();
            if (!resourcelocation.getNamespace().equals("curios")) continue;
            try {
                id = resourcelocation.getPath();
                if (!ICondition.conditionsMatched((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry2.getValue()).getAsJsonObject())) {
                    Curios.LOGGER.debug("Skipping loading slot {} as its conditions were not met", (Object)resourcelocation);
                    continue;
                }
                CuriosSlotManager.fromJson(map.computeIfAbsent(id, k -> new SlotType.Builder(id)), GsonHelper.convertToJsonObject((JsonElement)((JsonElement)entry2.getValue()), (String)"top element"));
                modMap.computeIfAbsent(id, k -> ImmutableSet.builder()).add((Object)resourcelocation.getNamespace());
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Curios.LOGGER.error("Parsing error loading curio slot {}", (Object)resourcelocation, (Object)e);
            }
        }
        for (Map.Entry<Object, Object> entry3 : LegacySlotManager.getImcBuilders().entrySet()) {
            SlotType.Builder builder = map.computeIfAbsent((String)entry3.getKey(), k -> new SlotType.Builder((String)entry2.getKey()));
            builder.apply((SlotType.Builder)entry3.getValue());
        }
        for (Map.Entry<Object, Object> entry4 : LegacySlotManager.getIdsToMods().entrySet()) {
            modMap.computeIfAbsent((String)entry4.getKey(), k -> ImmutableSet.builder()).addAll((Iterable)entry4.getValue());
        }
        for (Map.Entry<Object, Object> entry5 : sorted.entrySet()) {
            resourcelocation = (ResourceLocation)entry5.getKey();
            if (resourcelocation.getPath().startsWith("_") || resourcelocation.getNamespace().equals("curios")) continue;
            try {
                id = resourcelocation.getPath();
                if (!ICondition.conditionsMatched((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry5.getValue()).getAsJsonObject())) {
                    Curios.LOGGER.debug("Skipping loading slot {} as its conditions were not met", (Object)resourcelocation);
                    continue;
                }
                CuriosSlotManager.fromJson(map.computeIfAbsent(id, k -> new SlotType.Builder(id)), GsonHelper.convertToJsonObject((JsonElement)((JsonElement)entry5.getValue()), (String)"top element"));
                modMap.computeIfAbsent(id, k -> ImmutableSet.builder()).add((Object)resourcelocation.getNamespace());
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Curios.LOGGER.error("Parsing error loading curio slot {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.slots = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((SlotType.Builder)entry.getValue()).build()));
        this.idToMods = (Map)modMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
        Curios.LOGGER.info("Loaded {} curio slots", (Object)map.size());
    }

    public Map<String, ISlotType> getSlots() {
        return this.slots;
    }

    public Optional<ISlotType> getSlot(String id) {
        return Optional.ofNullable(this.slots.get(id));
    }

    public void setIcons(Map<String, ResourceLocation> icons) {
        this.icons = ImmutableMap.copyOf(icons);
    }

    public Map<String, ResourceLocation> getIcons() {
        return this.icons;
    }

    public ResourceLocation getIcon(String identifier) {
        return this.icons.getOrDefault(identifier, new ResourceLocation("curios", "slot/empty_curio_slot"));
    }

    public Map<String, Set<String>> getModsFromSlots() {
        return this.idToMods;
    }

    public static void fromJson(SlotType.Builder builder, JsonObject jsonObject) throws IllegalArgumentException, JsonParseException {
        Boolean jsonNative;
        Integer jsonSize;
        Integer n = jsonSize = jsonObject.has("size") ? Integer.valueOf(GsonHelper.getAsInt((JsonObject)jsonObject, (String)"size")) : null;
        if (jsonSize != null && jsonSize < 0) {
            throw new IllegalArgumentException("Size cannot be less than 0!");
        }
        String operation = GsonHelper.getAsString((JsonObject)jsonObject, (String)"operation", (String)"SET");
        if (!(operation.equals("SET") || operation.equals("ADD") || operation.equals("REMOVE"))) {
            throw new IllegalArgumentException(operation + " is not a valid operation!");
        }
        String jsonDropRule = GsonHelper.getAsString((JsonObject)jsonObject, (String)"drop_rule", (String)"");
        if (!jsonDropRule.isEmpty() && !EnumUtils.isValidEnum(ICurio.DropRule.class, (String)jsonDropRule)) {
            throw new IllegalArgumentException(jsonDropRule + " is not a valid drop rule!");
        }
        boolean replace = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"replace", (boolean)false);
        Integer jsonOrder = jsonObject.has("order") ? Integer.valueOf(GsonHelper.getAsInt((JsonObject)jsonObject, (String)"order")) : null;
        String jsonIcon = GsonHelper.getAsString((JsonObject)jsonObject, (String)"icon", (String)"");
        Boolean jsonToggle = jsonObject.has("render_toggle") ? Boolean.valueOf(GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"render_toggle")) : null;
        Boolean jsonCosmetic = jsonObject.has("add_cosmetic") ? Boolean.valueOf(GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"add_cosmetic")) : null;
        Boolean bl = jsonNative = jsonObject.has("use_native_gui") ? Boolean.valueOf(GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"use_native_gui")) : null;
        if (jsonOrder != null) {
            builder.order(jsonOrder, replace);
        }
        if (!jsonIcon.isEmpty()) {
            builder.icon(new ResourceLocation(jsonIcon));
        }
        if (!jsonDropRule.isEmpty()) {
            builder.dropRule(jsonDropRule);
        }
        if (jsonSize != null) {
            builder.size(jsonSize, operation, replace);
        }
        if (jsonCosmetic != null) {
            builder.hasCosmetic(jsonCosmetic, replace);
        }
        if (jsonNative != null) {
            builder.useNativeGui(jsonNative, replace);
        }
        if (jsonToggle != null) {
            builder.renderToggle(jsonToggle, replace);
        }
    }
}

