/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.mixin.core.AccessorEntity;

public class CurioSlot
extends SlotItemHandler {
    private final String identifier;
    private final Player player;
    private final SlotContext slotContext;
    private NonNullList<Boolean> renderStatuses;
    private boolean canToggleRender;

    public CurioSlot(Player player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders, boolean canToggleRender) {
        super((IItemHandler)handler, index, xPosition, yPosition);
        this.identifier = identifier;
        this.renderStatuses = renders;
        this.player = player;
        this.canToggleRender = canToggleRender;
        this.slotContext = new SlotContext(identifier, (LivingEntity)player, index, this instanceof CosmeticCurioSlot, this instanceof CosmeticCurioSlot || (Boolean)renders.get(index) != false);
        this.setBackground(InventoryMenu.BLOCK_ATLAS, CuriosApi.getSlotIcon(identifier));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean canToggleRender() {
        return this.canToggleRender;
    }

    public boolean getRenderStatus() {
        if (!this.canToggleRender) {
            return true;
        }
        return this.renderStatuses.size() > this.getSlotIndex() && (Boolean)this.renderStatuses.get(this.getSlotIndex()) != false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        return I18n.get((String)("curios.identifier." + this.identifier), (Object[])new Object[0]);
    }

    public void set(@Nonnull ItemStack stack) {
        ItemStack current = this.getItem();
        boolean flag = current.isEmpty() && stack.isEmpty();
        super.set(stack);
        if (!(flag || ItemStack.matches((ItemStack)current, (ItemStack)stack) || ((AccessorEntity)this.player).getFirstTick())) {
            CuriosApi.getCurio(stack).ifPresent(curio -> curio.onEquipFromUse(this.slotContext));
        }
    }

    public boolean allowModification(@Nonnull Player pPlayer) {
        return true;
    }
}

