/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.NetworkEvent;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

public class SPacketScroll {
    private int windowId;
    private int index;

    public SPacketScroll(int windowId, int index) {
        this.windowId = windowId;
        this.index = index;
    }

    public static void encode(SPacketScroll msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.windowId);
        buf.writeInt(msg.index);
    }

    public static SPacketScroll decode(FriendlyByteBuf buf) {
        return new SPacketScroll(buf.readInt(), buf.readInt());
    }

    public static void handle(SPacketScroll msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            AbstractContainerMenu container;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer clientPlayer = mc.player;
            Screen screen = mc.screen;
            if (clientPlayer != null && (container = clientPlayer.containerMenu) instanceof CuriosContainer && container.containerId == msg.windowId) {
                ((CuriosContainer)container).scrollToIndex(msg.index);
            }
            if (screen instanceof CuriosScreen) {
                ((CuriosScreen)screen).updateRenderButtons();
            }
        });
        ctx.setPacketHandled(true);
    }
}

