/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

public class SPacketSyncCurios {
    private int entityId;
    private int entrySize;
    private Map<String, CompoundTag> map;

    public SPacketSyncCurios(int entityId, Map<String, ICurioStacksHandler> map) {
        LinkedHashMap<String, CompoundTag> result = new LinkedHashMap<String, CompoundTag>();
        for (Map.Entry<String, ICurioStacksHandler> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getSyncTag());
        }
        this.entityId = entityId;
        this.entrySize = map.size();
        this.map = result;
    }

    public SPacketSyncCurios(Map<String, CompoundTag> map, int entityId) {
        this.entityId = entityId;
        this.entrySize = map.size();
        this.map = map;
    }

    public static void encode(SPacketSyncCurios msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.entrySize);
        for (Map.Entry<String, CompoundTag> entry : msg.map.entrySet()) {
            buf.writeUtf(entry.getKey());
            buf.writeNbt((Tag)entry.getValue());
        }
    }

    public static SPacketSyncCurios decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int entrySize = buf.readInt();
        LinkedHashMap<String, CompoundTag> map = new LinkedHashMap<String, CompoundTag>();
        for (int i = 0; i < entrySize; ++i) {
            String key = buf.readUtf();
            map.put(key, buf.readNbt());
        }
        return new SPacketSyncCurios(map, entityId);
    }

    public static void handle(SPacketSyncCurios msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Entity entity;
            ClientLevel world = Minecraft.getInstance().level;
            if (world != null && (entity = world.getEntity(msg.entityId)) instanceof LivingEntity) {
                CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> {
                    LinkedHashMap<String, ICurioStacksHandler> stacks = new LinkedHashMap<String, ICurioStacksHandler>();
                    for (Map.Entry<String, CompoundTag> entry : msg.map.entrySet()) {
                        CurioStacksHandler stacksHandler = new CurioStacksHandler((ICuriosItemHandler)handler, entry.getKey());
                        stacksHandler.applySyncTag(entry.getValue());
                        stacks.put(entry.getKey(), stacksHandler);
                    }
                    handler.setCurios(stacks);
                    if (entity instanceof LocalPlayer) {
                        LocalPlayer player = (LocalPlayer)entity;
                        AbstractContainerMenu patt3892$temp = player.containerMenu;
                        if (patt3892$temp instanceof CuriosContainer) {
                            CuriosContainer curiosContainer = (CuriosContainer)patt3892$temp;
                            curiosContainer.resetSlots();
                        }
                    }
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

