/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.LazyOptional;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.SPacketBreak;
import top.theillusivec4.curios.common.slottype.SlotType;

public class CuriosImplMixinHooks {
    private static final Map<Item, ICurioItem> REGISTRY = new ConcurrentHashMap<Item, ICurioItem>();

    public static void registerCurio(Item item, ICurioItem icurio) {
        REGISTRY.put(item, icurio);
    }

    public static Optional<ICurioItem> getCurioFromRegistry(Item item) {
        return Optional.ofNullable(REGISTRY.get(item));
    }

    public static Optional<ISlotType> getSlot(String id) {
        return Optional.ofNullable(CuriosApi.getSlots().get(id));
    }

    public static ResourceLocation getSlotIcon(String id) {
        return CuriosSlotManager.INSTANCE.getIcon(id);
    }

    public static Map<String, ISlotType> getSlots() {
        return CuriosSlotManager.INSTANCE.getSlots();
    }

    public static Map<String, ISlotType> getPlayerSlots() {
        return CuriosApi.getEntitySlots(EntityType.PLAYER);
    }

    public static Map<String, ISlotType> getEntitySlots(EntityType<?> type) {
        return CuriosEntityManager.INSTANCE.getEntitySlots(type);
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack) {
        HashMap<String, ISlotType> result = new HashMap<String, ISlotType>();
        Set ids = stack.getTags().filter(tagKey -> tagKey.location().getNamespace().equals("curios")).map(tagKey -> tagKey.location().getPath()).collect(Collectors.toSet());
        Map<String, ISlotType> allSlots = CuriosSlotManager.INSTANCE.getSlots();
        for (String id : ids) {
            ISlotType slotType = allSlots.get(id);
            if (slotType != null) {
                result.put(id, slotType);
                continue;
            }
            result.put(id, new SlotType.Builder(id).build());
        }
        return result;
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack, LivingEntity livingEntity) {
        HashMap<String, ISlotType> result = new HashMap<String, ISlotType>();
        Set ids = stack.getTags().filter(tagKey -> tagKey.location().getNamespace().equals("curios")).map(tagKey -> tagKey.location().getPath()).collect(Collectors.toSet());
        Map<String, ISlotType> entitySlots = CuriosImplMixinHooks.getEntitySlots(livingEntity.getType());
        for (String id : ids) {
            ISlotType slotType = entitySlots.get(id);
            if (slotType != null) {
                result.put(id, slotType);
                continue;
            }
            result.put(id, new SlotType.Builder(id).build());
        }
        return result;
    }

    public static LazyOptional<ICurio> getCurio(ItemStack stack) {
        return stack.getCapability(CuriosCapability.ITEM);
    }

    public static LazyOptional<ICuriosItemHandler> getCuriosInventory(LivingEntity livingEntity) {
        return livingEntity.getCapability(CuriosCapability.INVENTORY);
    }

    public static boolean isStackValid(SlotContext slotContext, ItemStack stack) {
        String id = slotContext.identifier();
        Set<String> slots = CuriosImplMixinHooks.getItemStackSlots(stack).keySet();
        return !slots.isEmpty() && id.equals("curio") || slots.contains(id) || slots.contains("curio");
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (stack.getTag() != null && stack.getTag().contains("CurioAttributeModifiers", 9)) {
            ListTag listnbt = stack.getTag().getList("CurioAttributeModifiers", 10);
            String identifier = slotContext.identifier();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt = listnbt.getCompound(i);
                if (!compoundnbt.getString("Slot").equals(identifier)) continue;
                ResourceLocation rl = ResourceLocation.tryParse((String)compoundnbt.getString("AttributeName"));
                UUID id = uuid;
                if (rl == null) continue;
                if (compoundnbt.contains("UUID")) {
                    id = compoundnbt.getUUID("UUID");
                }
                if (id.getLeastSignificantBits() == 0L || id.getMostSignificantBits() == 0L) continue;
                AttributeModifier.Operation operation = AttributeModifier.Operation.fromValue((int)compoundnbt.getInt("Operation"));
                double amount = compoundnbt.getDouble("Amount");
                String name = compoundnbt.getString("Name");
                if (rl.getNamespace().equals("curios")) {
                    String identifier1 = rl.getPath();
                    if (!CuriosApi.getSlot(identifier1).isPresent()) continue;
                    CuriosApi.addSlotModifier((Multimap<Attribute, AttributeModifier>)multimap, identifier1, id, amount, operation);
                    continue;
                }
                Attribute attribute = BuiltInRegistries.ATTRIBUTE.getOptional(rl).orElse(null);
                if (attribute == null) continue;
                multimap.put((Object)attribute, (Object)new AttributeModifier(id, name, amount, operation));
            }
        } else {
            multimap = (Multimap)CuriosImplMixinHooks.getCurio(stack).map(curio -> curio.getAttributeModifiers(slotContext, uuid)).orElse(multimap);
        }
        CurioAttributeModifierEvent evt = new CurioAttributeModifierEvent(stack, slotContext, uuid, (Multimap<Attribute, AttributeModifier>)multimap);
        NeoForge.EVENT_BUS.post((Event)evt);
        return HashMultimap.create(evt.getModifiers());
    }

    public static void addSlotModifier(Multimap<Attribute, AttributeModifier> map, String identifier, UUID uuid, double amount, AttributeModifier.Operation operation) {
        map.put((Object)SlotAttribute.getOrCreate(identifier), (Object)new AttributeModifier(uuid, identifier, amount, operation));
    }

    public static void addSlotModifier(ItemStack stack, String identifier, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        CuriosImplMixinHooks.addModifier(stack, SlotAttribute.getOrCreate(identifier), name, uuid, amount, operation, slot);
    }

    public static void addModifier(ItemStack stack, Attribute attribute, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        CompoundTag tag = stack.getOrCreateTag();
        if (!tag.contains("CurioAttributeModifiers", 9)) {
            tag.put("CurioAttributeModifiers", (Tag)new ListTag());
        }
        ListTag listtag = tag.getList("CurioAttributeModifiers", 10);
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("Name", name);
        compoundtag.putDouble("Amount", amount);
        compoundtag.putInt("Operation", operation.toValue());
        if (uuid != null) {
            compoundtag.putUUID("UUID", uuid);
        }
        Object id = "";
        if (attribute instanceof SlotAttribute) {
            SlotAttribute wrapper = (SlotAttribute)attribute;
            id = "curios:" + wrapper.getIdentifier();
        } else {
            ResourceLocation rl = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
            if (rl != null) {
                id = rl.toString();
            }
        }
        if (!((String)id).isEmpty()) {
            compoundtag.putString("AttributeName", (String)id);
        }
        compoundtag.putString("Slot", slot);
        listtag.add((Object)compoundtag);
    }

    public static void broadcastCurioBreakEvent(SlotContext slotContext) {
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(slotContext::entity), (Object)new SPacketBreak(slotContext.entity().getId(), slotContext.identifier(), slotContext.index()));
    }
}

