/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

public class ClientEventHandler {
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (KeyRegistry.openCurios.consumeClick() && mc.isWindowActive()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketOpenCurios(ItemStack.EMPTY));
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key evt) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer != null && localPlayer.hasContainerOpen() && !(localPlayer.containerMenu instanceof CuriosContainer) && evt.getKey() == KeyRegistry.openCurios.getKey().getValue() && evt.getAction() == 1) {
            localPlayer.closeContainer();
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        Player player = evt.getEntity();
        if (!stack.isEmpty()) {
            Map<String, ISlotType> map;
            Set<String> curioTags;
            ArrayList<String> slots;
            List tooltip = evt.getToolTip();
            CompoundTag tag = stack.getTag();
            int i = 0;
            if (tag != null && tag.contains("HideFlags", 99)) {
                i = tag.getInt("HideFlags");
            }
            if (!(slots = new ArrayList<String>(curioTags = (map = player != null ? CuriosApi.getItemStackSlots(stack, (LivingEntity)player) : CuriosApi.getItemStackSlots(stack)).keySet())).isEmpty()) {
                ArrayList<MutableComponent> tagTooltips = new ArrayList<MutableComponent>();
                MutableComponent slotsTooltip = Component.translatable((String)"curios.tooltip.slot").append(" ").withStyle(ChatFormatting.GOLD);
                for (int j = 0; j < slots.size(); ++j) {
                    String key = "curios.identifier." + (String)slots.get(j);
                    MutableComponent type = Component.translatable((String)key);
                    if (j < slots.size() - 1) {
                        type = type.append(", ");
                    }
                    type = type.withStyle(ChatFormatting.YELLOW);
                    slotsTooltip.append((Component)type);
                }
                tagTooltips.add(slotsTooltip);
                Optional<ICurio> optionalCurio = CuriosApi.getCurio(stack);
                optionalCurio.ifPresent(curio -> {
                    List<Component> actualSlotsTooltip = curio.getSlotsTooltip(tagTooltips);
                    if (!actualSlotsTooltip.isEmpty()) {
                        tooltip.addAll(1, actualSlotsTooltip);
                    }
                });
                if (optionalCurio.isEmpty()) {
                    tooltip.addAll(1, tagTooltips);
                }
                ArrayList<MutableComponent> attributeTooltip = new ArrayList<MutableComponent>();
                for (String identifier : slots) {
                    Multimap<Attribute, AttributeModifier> multimap = CuriosApi.getAttributeModifiers(new SlotContext(identifier, (LivingEntity)player, 0, false, true), UUID.randomUUID(), stack);
                    if (multimap.isEmpty() || (i & 2) != 0) continue;
                    boolean init = false;
                    for (Map.Entry entry : multimap.entries()) {
                        if (entry.getKey() == null) continue;
                        if (!init) {
                            attributeTooltip.add(Component.empty());
                            attributeTooltip.add(Component.translatable((String)("curios.modifiers." + identifier)).withStyle(ChatFormatting.GOLD));
                            init = true;
                        }
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        double amount = attributemodifier.getAmount();
                        boolean flag = false;
                        if (player == null) continue;
                        if (attributemodifier.getId() == ATTACK_DAMAGE_MODIFIER) {
                            AttributeInstance att = player.getAttribute(Attributes.ATTACK_DAMAGE);
                            if (att != null) {
                                amount += att.getBaseValue();
                            }
                            amount += (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, (MobType)MobType.UNDEFINED);
                            flag = true;
                        } else if (attributemodifier.getId() == ATTACK_SPEED_MODIFIER) {
                            AttributeInstance att = player.getAttribute(Attributes.ATTACK_SPEED);
                            if (att != null) {
                                amount += att.getBaseValue();
                            }
                            flag = true;
                        }
                        double d1 = attributemodifier.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.KNOCKBACK_RESISTANCE) ? amount * 10.0 : amount) : amount * 100.0;
                        Object k = entry.getKey();
                        if (k instanceof SlotAttribute) {
                            SlotAttribute slotAttribute = (SlotAttribute)((Object)k);
                            if (amount > 0.0) {
                                attributeTooltip.add(Component.translatable((String)("curios.modifiers.slots.plus." + attributemodifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)("curios.identifier." + slotAttribute.getIdentifier()))}).withStyle(ChatFormatting.BLUE));
                                continue;
                            }
                            attributeTooltip.add(Component.translatable((String)("curios.modifiers.slots.take." + attributemodifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable((String)("curios.identifier." + slotAttribute.getIdentifier()))}).withStyle(ChatFormatting.RED));
                            continue;
                        }
                        if (flag) {
                            attributeTooltip.add(Component.literal((String)" ").append((Component)Component.translatable((String)("attribute.modifier.equals." + attributemodifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)entry.getKey()).getDescriptionId())})).withStyle(ChatFormatting.DARK_GREEN));
                            continue;
                        }
                        if (amount > 0.0) {
                            attributeTooltip.add(Component.translatable((String)("attribute.modifier.plus." + attributemodifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)entry.getKey()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                            continue;
                        }
                        if (!(amount < 0.0)) continue;
                        attributeTooltip.add(Component.translatable((String)("attribute.modifier.take." + attributemodifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable((String)((Attribute)entry.getKey()).getDescriptionId())}).withStyle(ChatFormatting.RED));
                    }
                }
                optionalCurio.ifPresent(curio -> {
                    List<Component> actualAttributeTooltips = curio.getAttributesTooltip(attributeTooltip);
                    if (!actualAttributeTooltips.isEmpty()) {
                        tooltip.addAll(actualAttributeTooltips);
                    }
                });
                if (!optionalCurio.isPresent()) {
                    tooltip.addAll(attributeTooltip);
                }
            }
        }
    }
}

