/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory.container;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketScroll;
import top.theillusivec4.curios.common.network.server.SPacketScroll;

public class CuriosContainer
extends InventoryMenu {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public final ICuriosItemHandler curiosHandler;
    public final Player player;
    private final boolean isLocalWorld;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
    private final ResultContainer craftResult = new ResultContainer();
    private int lastScrollIndex;
    private boolean cosmeticColumn;

    public CuriosContainer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(windowId, playerInventory);
    }

    public CuriosContainer(int windowId, Inventory playerInventory) {
        super(playerInventory, playerInventory.player.level().isClientSide, playerInventory.player);
        this.menuType = CuriosRegistry.CURIO_MENU.get();
        this.containerId = windowId;
        this.remoteSlots.clear();
        this.lastSlots.clear();
        this.slots.clear();
        this.player = playerInventory.player;
        this.isLocalWorld = this.player.level().isClientSide;
        this.curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)this.player).orElse(null);
        this.addSlot((Slot)new ResultSlot(playerInventory.player, this.craftMatrix, (Container)this.craftResult, 0, 154, 28));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot((Container)this.craftMatrix, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.addSlot(new Slot((Container)playerInventory, 36 + (3 - k), 8, 8 + k * 18){

                public void set(@Nonnull ItemStack stack) {
                    ItemStack itemstack = this.getItem();
                    super.set(stack);
                    CuriosContainer.this.player.onEquipItem(equipmentslottype, itemstack, stack);
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(@Nonnull ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)CuriosContainer.this.player);
                }

                public boolean mayPickup(@Nonnull Player playerIn) {
                    ItemStack itemstack = this.getItem();
                    return (itemstack.isEmpty() || playerIn.isCreative() || !EnchantmentHelper.hasBindingCurse((ItemStack)itemstack)) && super.mayPickup(playerIn);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.getIndex()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.addSlot(new Slot((Container)playerInventory, 40, 77, 62){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        if (this.curiosHandler != null) {
            int i;
            IDynamicStackHandler stackHandler;
            ICurioStacksHandler stacksHandler;
            Map<String, ICurioStacksHandler> curioMap = this.curiosHandler.getCurios();
            int slots = 0;
            int yOffset = 12;
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++slots, ++i) {
                    this.addSlot((Slot)new CurioSlot(this.player, stackHandler, i, identifier, -18, yOffset, stacksHandler.getRenders(), stacksHandler.canToggleRendering()));
                    yOffset += 18;
                }
            }
            yOffset = 12;
            slots = 0;
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++slots, ++i) {
                    if (stacksHandler.hasCosmetic()) {
                        IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                        this.cosmeticColumn = true;
                        this.addSlot((Slot)new CosmeticCurioSlot(this.player, cosmeticHandler, i, identifier, -37, yOffset));
                    }
                    yOffset += 18;
                }
            }
        }
        this.scrollToIndex(0);
    }

    public boolean hasCosmeticColumn() {
        return this.cosmeticColumn;
    }

    public void resetSlots() {
        this.scrollToIndex(this.lastScrollIndex);
    }

    public void scrollToIndex(int indexIn) {
        if (this.curiosHandler != null) {
            int i;
            IDynamicStackHandler stackHandler;
            ICurioStacksHandler stacksHandler;
            Map<String, ICurioStacksHandler> curioMap = this.curiosHandler.getCurios();
            int slots = 0;
            int yOffset = 12;
            int index = 0;
            int startingIndex = indexIn;
            this.slots.subList(46, this.slots.size()).clear();
            this.lastSlots.subList(46, this.lastSlots.size()).clear();
            this.remoteSlots.subList(46, this.remoteSlots.size()).clear();
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++i) {
                    if (index >= startingIndex) {
                        ++slots;
                    }
                    ++index;
                }
            }
            startingIndex = Math.min(startingIndex, Math.max(0, index - 8));
            index = 0;
            slots = 0;
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++i) {
                    if (index >= startingIndex) {
                        this.addSlot((Slot)new CurioSlot(this.player, stackHandler, i, identifier, -18, yOffset, stacksHandler.getRenders(), stacksHandler.canToggleRendering()));
                        yOffset += 18;
                        ++slots;
                    }
                    ++index;
                }
            }
            index = 0;
            slots = 0;
            yOffset = 12;
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++i) {
                    if (index >= startingIndex) {
                        if (stacksHandler.hasCosmetic()) {
                            IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                            this.cosmeticColumn = true;
                            this.addSlot((Slot)new CosmeticCurioSlot(this.player, cosmeticHandler, i, identifier, -37, yOffset));
                        }
                        yOffset += 18;
                        ++slots;
                    }
                    ++index;
                }
            }
            if (!this.isLocalWorld) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new SPacketScroll(this.containerId, indexIn));
            }
            this.lastScrollIndex = indexIn;
        }
    }

    public void scrollTo(float pos) {
        if (this.curiosHandler != null) {
            int k = this.curiosHandler.getVisibleSlots() - 8;
            int j = (int)((double)(pos * (float)k) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (j == this.lastScrollIndex) {
                return;
            }
            if (this.isLocalWorld) {
                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketScroll(this.containerId, j));
            }
        }
    }

    public void slotsChanged(@Nonnull Container inventoryIn) {
        if (!this.player.level().isClientSide) {
            ServerPlayer playerMP = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.EMPTY;
            MinecraftServer server = this.player.level().getServer();
            if (server == null) {
                return;
            }
            Optional recipe = server.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)this.craftMatrix, this.player.level());
            if (recipe.isPresent()) {
                ItemStack itemstack1;
                RecipeHolder recipeholder = (RecipeHolder)recipe.get();
                CraftingRecipe craftingRecipe = (CraftingRecipe)recipeholder.value();
                if (this.craftResult.setRecipeUsed(this.player.level(), playerMP, recipeholder) && (itemstack1 = craftingRecipe.assemble((Container)this.craftMatrix, this.player.level().registryAccess())).isItemEnabled(this.player.level().enabledFeatures())) {
                    stack = itemstack1;
                }
            }
            this.craftResult.setItem(0, stack);
            this.setRemoteSlot(0, stack);
            playerMP.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, stack));
        }
    }

    public void removed(@Nonnull Player playerIn) {
        super.removed(playerIn);
        this.craftResult.clearContent();
        if (!playerIn.level().isClientSide) {
            this.clearContainer(playerIn, (Container)this.craftMatrix);
        }
    }

    public boolean canScroll() {
        if (this.curiosHandler != null) {
            return this.curiosHandler.getVisibleSlots() > 8;
        }
        return false;
    }

    public boolean stillValid(@Nonnull Player playerIn) {
        return true;
    }

    public void setItem(int pSlotId, int pStateId, @Nonnull ItemStack pStack) {
        if (this.slots.size() > pSlotId) {
            super.setItem(pSlotId, pStateId, pStack);
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            int i;
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            EquipmentSlot entityequipmentslot = Mob.getEquipmentSlotForItem((ItemStack)itemstack);
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index < 5 ? !this.moveItemStackTo(itemstack1, 9, 45, false) : (index < 9 ? !this.moveItemStackTo(itemstack1, 9, 45, false) : (entityequipmentslot.getType() == EquipmentSlot.Type.ARMOR && !((Slot)this.slots.get(8 - entityequipmentslot.getIndex())).hasItem() ? !this.moveItemStackTo(itemstack1, i = 8 - entityequipmentslot.getIndex(), i + 1, false) : (index < 46 && !CuriosApi.getItemStackSlots(itemstack).isEmpty() ? !this.moveItemStackTo(itemstack1, 46, this.slots.size(), false) : (entityequipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(itemstack1, 45, 46, false) : (index < 36 ? !this.moveItemStackTo(itemstack1, 36, 45, false) : (index < 45 ? !this.moveItemStackTo(itemstack1, 9, 36, false) : !this.moveItemStackTo(itemstack1, 9, 45, false)))))))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
            if (index == 0) {
                playerIn.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    @Nonnull
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public void fillCraftSlotsStackedContents(@Nonnull StackedContents itemHelperIn) {
        this.craftMatrix.fillStackedContents(itemHelperIn);
    }

    public void clearCraftingContent() {
        this.craftMatrix.clearContent();
        this.craftResult.clearContent();
    }

    public boolean recipeMatches(RecipeHolder<? extends Recipe<CraftingContainer>> recipeHolder) {
        return recipeHolder.value().matches((Container)this.craftMatrix, this.player.level());
    }

    public int getGridWidth() {
        return this.craftMatrix.getWidth();
    }

    public int getGridHeight() {
        return this.craftMatrix.getHeight();
    }
}

