/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.client;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.NetworkEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.SPacketGrabbedItem;

public class CPacketOpenVanilla {
    private final ItemStack carried;

    public CPacketOpenVanilla(ItemStack stack) {
        this.carried = stack;
    }

    public static void encode(CPacketOpenVanilla msg, FriendlyByteBuf buf) {
        buf.writeItem(msg.carried);
    }

    public static CPacketOpenVanilla decode(FriendlyByteBuf buf) {
        return new CPacketOpenVanilla(buf.readItem());
    }

    public static void handle(CPacketOpenVanilla msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender != null) {
                ItemStack stack = sender.isCreative() ? msg.carried : sender.containerMenu.getCarried();
                sender.containerMenu.setCarried(ItemStack.EMPTY);
                sender.doCloseContainer();
                if (!stack.isEmpty()) {
                    if (!sender.isCreative()) {
                        sender.containerMenu.setCarried(stack);
                    }
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new SPacketGrabbedItem(stack));
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

