/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class SPacketSyncRender {
    private int entityId;
    private int slotId;
    private String curioId;
    private boolean value;

    public SPacketSyncRender(int entityId, String curioId, int slotId, boolean value) {
        this.entityId = entityId;
        this.slotId = slotId;
        this.curioId = curioId;
        this.value = value;
    }

    public static void encode(SPacketSyncRender msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeUtf(msg.curioId);
        buf.writeInt(msg.slotId);
        buf.writeBoolean(msg.value);
    }

    public static SPacketSyncRender decode(FriendlyByteBuf buf) {
        return new SPacketSyncRender(buf.readInt(), buf.readUtf(), buf.readInt(), buf.readBoolean());
    }

    public static void handle(SPacketSyncRender msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Entity entity;
            ClientLevel world = Minecraft.getInstance().level;
            if (world != null && (entity = world.getEntity(msg.entityId)) instanceof LivingEntity) {
                CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.getStacksHandler(msg.curioId)).ifPresent(stacksHandler -> {
                    int index = msg.slotId;
                    NonNullList<Boolean> renderStatuses = stacksHandler.getRenders();
                    if (renderStatuses.size() > index) {
                        renderStatuses.set(index, (Object)msg.value);
                    }
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

