/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class SPacketSyncStack {
    private int entityId;
    private int slotId;
    private String curioId;
    private ItemStack stack;
    private int handlerType;
    private CompoundTag compound;

    public SPacketSyncStack(int entityId, String curioId, int slotId, ItemStack stack, HandlerType handlerType, CompoundTag data) {
        this.entityId = entityId;
        this.slotId = slotId;
        this.stack = stack.copy();
        this.curioId = curioId;
        this.handlerType = handlerType.ordinal();
        this.compound = data;
    }

    public static void encode(SPacketSyncStack msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeUtf(msg.curioId);
        buf.writeInt(msg.slotId);
        buf.writeItem(msg.stack);
        buf.writeInt(msg.handlerType);
        buf.writeNbt((Tag)msg.compound);
    }

    public static SPacketSyncStack decode(FriendlyByteBuf buf) {
        return new SPacketSyncStack(buf.readInt(), buf.readUtf(), buf.readInt(), buf.readItem(), HandlerType.fromValue(buf.readInt()), buf.readNbt());
    }

    public static void handle(SPacketSyncStack msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Entity entity;
            ClientLevel world = Minecraft.getInstance().level;
            if (world != null && (entity = world.getEntity(msg.entityId)) instanceof LivingEntity) {
                CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.getStacksHandler(msg.curioId)).ifPresent(stacksHandler -> {
                    boolean cosmetic;
                    ItemStack stack = msg.stack;
                    CompoundTag compoundNBT = msg.compound;
                    int slot = msg.slotId;
                    boolean bl = cosmetic = HandlerType.fromValue(msg.handlerType) == HandlerType.COSMETIC;
                    if (!compoundNBT.isEmpty()) {
                        NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                        CuriosApi.getCurio(stack).ifPresent(curio -> curio.readSyncData(new SlotContext(msg.curioId, (LivingEntity)entity, slot, cosmetic, renderStates.size() > slot && (Boolean)renderStates.get(slot) != false), compoundNBT));
                    }
                    if (cosmetic) {
                        stacksHandler.getCosmeticStacks().setStackInSlot(slot, stack);
                    } else {
                        stacksHandler.getStacks().setStackInSlot(slot, stack);
                    }
                });
            }
        });
        ctx.setPacketHandled(true);
    }

    public static enum HandlerType {
        EQUIPMENT,
        COSMETIC;


        public static HandlerType fromValue(int value) {
            try {
                return HandlerType.values()[value];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown handler value: " + value);
            }
        }
    }
}

