/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class EquipCurioTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final EquipCurioTrigger INSTANCE = new EquipCurioTrigger();

    @Nonnull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer, ItemStack stack) {
        LootParams lootparams = new LootParams.Builder(serverPlayer.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)serverPlayer.blockPosition().getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer).withParameter(LootContextParams.BLOCK_STATE, (Object)serverPlayer.getBlockStateOn()).withParameter(LootContextParams.TOOL, (Object)stack).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext lootcontext = new LootContext.Builder(lootparams).create(Optional.empty());
        this.trigger(serverPlayer, instance -> instance.matches(stack, lootcontext));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<ContextAwarePredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_311432_ -> p_311432_.group((App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.ADVANCEMENT_CODEC, (String)"player").forGetter(TriggerInstance::player), (App)ExtraCodecs.strictOptionalField((Codec)ItemPredicate.CODEC, (String)"item").forGetter(TriggerInstance::item), (App)ExtraCodecs.strictOptionalField((Codec)ContextAwarePredicate.CODEC, (String)"location").forGetter(TriggerInstance::location)).apply((Applicative)p_311432_, TriggerInstance::new));

        public boolean matches(ItemStack stack, LootContext lootContext) {
            if (this.location.isEmpty() || this.location.get().matches(lootContext)) {
                return this.item.isEmpty() || this.item.get().matches(stack);
            }
            return false;
        }

        public void validate(@Nonnull CriterionValidator validator) {
            super.validate(validator);
            this.location.ifPresent(loc -> validator.validate(loc, LootContextParamSets.ADVANCEMENT_LOCATION, ".location"));
        }
    }
}

