/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class SPacketSyncCurios
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("curios", "sync_curios");
    public final int entityId;
    public final int entrySize;
    public final Map<String, CompoundTag> map;

    public SPacketSyncCurios(int entityId, Map<String, ICurioStacksHandler> map) {
        LinkedHashMap<String, CompoundTag> result = new LinkedHashMap<String, CompoundTag>();
        for (Map.Entry<String, ICurioStacksHandler> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getSyncTag());
        }
        this.entityId = entityId;
        this.entrySize = map.size();
        this.map = result;
    }

    public SPacketSyncCurios(Map<String, CompoundTag> map, int entityId) {
        this.entityId = entityId;
        this.entrySize = map.size();
        this.map = map;
    }

    public SPacketSyncCurios(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int entrySize = buf.readInt();
        LinkedHashMap<String, CompoundTag> map = new LinkedHashMap<String, CompoundTag>();
        for (int i = 0; i < entrySize; ++i) {
            String key = buf.readUtf();
            map.put(key, buf.readNbt());
        }
        this.entityId = entityId;
        this.entrySize = map.size();
        this.map = map;
    }

    public void write(@Nonnull FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.entrySize);
        for (Map.Entry<String, CompoundTag> entry : this.map.entrySet()) {
            buf.writeUtf(entry.getKey());
            buf.writeNbt((Tag)entry.getValue());
        }
    }

    @Nonnull
    public ResourceLocation id() {
        return ID;
    }
}

