/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class SPacketSyncData
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("curios", "sync_data");
    public final ListTag slotData;
    public final ListTag entityData;

    public SPacketSyncData(ListTag slotData, ListTag entityData) {
        this.slotData = slotData;
        this.entityData = entityData;
    }

    public SPacketSyncData(FriendlyByteBuf buf) {
        CompoundTag tag = buf.readNbt();
        if (tag != null) {
            this.slotData = tag.getList("SlotData", 10);
            this.entityData = tag.getList("EntityData", 10);
        } else {
            this.slotData = new ListTag();
            this.entityData = new ListTag();
        }
    }

    public void write(@Nonnull FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        tag.put("SlotData", (Tag)this.slotData);
        tag.put("EntityData", (Tag)this.entityData);
        buf.writeNbt((Tag)tag);
    }

    @Nonnull
    public ResourceLocation id() {
        return ID;
    }
}

