/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record SPacketSyncStack(int entityId, String curioId, int slotId, ItemStack stack, int handlerType, CompoundTag compoundTag) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("curios", "sync_stack");

    public SPacketSyncStack(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readUtf(), buf.readInt(), buf.readItem(), buf.readInt(), buf.readNbt());
    }

    public void write(@Nonnull FriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        buf.writeUtf(this.curioId());
        buf.writeInt(this.slotId());
        buf.writeItem(this.stack());
        buf.writeInt(this.handlerType());
        buf.writeNbt((Tag)this.compoundTag());
    }

    @Nonnull
    public ResourceLocation id() {
        return ID;
    }

    public static enum HandlerType {
        EQUIPMENT,
        COSMETIC;


        public static HandlerType fromValue(int value) {
            try {
                return HandlerType.values()[value];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown handler value: " + value);
            }
        }
    }
}

