/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.crosshair.style.CrosshairStyleFactory;
import com.wjbaker.ccm.crosshair.style.ICrosshairStyle;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.type.RGBA;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.lwjgl.opengl.GL11;

public final class CrosshairRenderManager {
    private final CustomCrosshair crosshair;
    private final RenderManager renderManager;
    private final CrosshairStyleFactory crosshairStyleFactory;
    private final Set<class_1792> itemCooldownItems = ImmutableSet.of((Object)class_1802.field_8634, (Object)class_1802.field_8233);

    public CrosshairRenderManager(CustomCrosshair crosshair) {
        this.crosshair = crosshair;
        this.renderManager = new RenderManager();
        this.crosshairStyleFactory = new CrosshairStyleFactory();
    }

    public void draw(int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(this.crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        ICrosshairStyle style = this.crosshairStyleFactory.from((CrosshairStyle)((Object)this.crosshair.style.get()), this.crosshair);
        boolean isItemCooldownEnabled = (Boolean)this.crosshair.isItemCooldownEnabled.get();
        boolean isDotEnabled = (Boolean)this.crosshair.isDotEnabled.get();
        if (isItemCooldownEnabled) {
            this.drawItemCooldownIndicator(computedProperties, x, y);
        }
        if (isDotEnabled && this.crosshair.style.get() != CrosshairStyle.DEFAULT) {
            this.renderManager.drawCircle(x, y, 0.5f, 1.0f, (RGBA)this.crosshair.dotColour.get());
        }
        this.preRotation(x, y);
        style.draw(x, y, computedProperties);
        this.postRotation();
    }

    private void preRotation(int x, int y) {
        int rotation = (Integer)this.crosshair.rotation.get();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)x, (float)y, (float)8000.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }

    private void postRotation() {
        GL11.glPopMatrix();
    }

    private void drawItemCooldownIndicator(ComputedProperties computedProperties, int x, int y) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)this.crosshair.itemCooldownColour.get();
        int width = (Integer)this.crosshair.width.get();
        int height = (Integer)this.crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (class_1792 item : this.itemCooldownItems) {
            float cooldown = player.method_7357().method_7905(item, 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(x, y, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }
}

