/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm;

import com.wjbaker.ccm.config.ConfigManager;
import com.wjbaker.ccm.config.GlobalProperties;
import com.wjbaker.ccm.crosshair.property.ICrosshairProperty;
import com.wjbaker.ccm.crosshair.render.CrosshairRenderManager;
import com.wjbaker.ccm.helper.RequestHelper;
import com.wjbaker.ccm.render.gui.screen.screens.editCrosshair.EditCrosshairGuiScreen;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="custom-crosshair-mod")
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class CustomCrosshairMod {
    public static CustomCrosshairMod INSTANCE;
    public static final String TITLE = "Custom Crosshair Mod";
    public static final String VERSION = "1.2.1-forge";
    public static final String MC_VERSION = "1.16.5-forge";
    public static final String CURSEFORGE_PAGE = "https://www.curseforge.com/projects/242995/";
    public static final String MC_FORUMS_PAGE = "https://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/";
    private static final KeyBinding editCrosshairKeyBinding;
    private final Logger logger = LogManager.getLogger(CustomCrosshairMod.class);
    private final GlobalProperties properties = new GlobalProperties();
    private final CrosshairRenderManager crosshairRenderManager = new CrosshairRenderManager(this.properties.getCrosshair());
    private ConfigManager configManager;

    public CustomCrosshairMod() {
        INSTANCE = this;
        this.loadConfig();
        this.checkVersion();
        ClientRegistry.registerKeyBinding((KeyBinding)editCrosshairKeyBinding);
    }

    private void loadConfig() {
        List<ICrosshairProperty<?>> configProperties = this.properties.getCrosshair().propertiesAsList;
        configProperties.add(this.properties.getIsModEnabled());
        this.configManager = new ConfigManager("crosshair_config.ccmcfg", configProperties.stream().collect(Collectors.toMap(ICrosshairProperty::alias, p -> p)));
        if (!this.configManager.read() && !this.configManager.write()) {
            this.error("Config Manager (Load)", "Unable to load or write config.", new Object[0]);
        }
    }

    private void checkVersion() {
        try (BufferedReader reader = new RequestHelper().get("https://pastebin.com/raw/B2sL8QCh");){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                String[] lineSplit = currentLine.split(" ");
                if (lineSplit.length != 2) continue;
                String mcVersion = lineSplit[0];
                String expectedModVersion = lineSplit[1];
                if (!mcVersion.equals(MC_VERSION) || expectedModVersion.equals(VERSION)) continue;
                this.log("Version Checker", "Not using latest version of Customer Crosshair Mod.", new Object[0]);
                this.properties.setLatestVersion(false);
            }
        }
        catch (IOException e) {
            this.error("Version Checker", "Unable to check the version.", new Object[0]);
        }
    }

    private static String identifier(String id) {
        return String.format("key.custom-crosshair-mod.%s", id);
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71462_r == null && editCrosshairKeyBinding.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new EditCrosshairGuiScreen());
        }
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        ForgeIngameGui.renderCrosshairs = false;
        if (!((Boolean)CustomCrosshairMod.INSTANCE.properties.getIsModEnabled().get()).booleanValue()) {
            ForgeIngameGui.renderCrosshairs = true;
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null && !(Minecraft.func_71410_x().field_71462_r instanceof ChatScreen)) {
            return;
        }
        int width = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        int height = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        int x = Math.round((float)width / 2.0f);
        int y = Math.round((float)height / 2.0f);
        CustomCrosshairMod.INSTANCE.crosshairRenderManager.draw(x, y);
    }

    public GlobalProperties properties() {
        return this.properties;
    }

    public ConfigManager configManager() {
        return this.configManager;
    }

    public void log(String action, String message, Object ... values) {
        this.logger.info(String.format("[%s] %s", action, message), values);
    }

    public void error(String action, String message, Object ... values) {
        this.logger.error(String.format("[%s] %s", action, message), values);
    }

    static {
        editCrosshairKeyBinding = new KeyBinding(CustomCrosshairMod.identifier("edit_crosshair"), 96, CustomCrosshairMod.identifier("category"));
    }
}

