/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style.styles;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.AbstractCrosshairStyle;
import com.wjbaker.ccm.type.RGBA;
import net.minecraft.client.Minecraft;

public final class CrossStyle
extends AbstractCrosshairStyle {
    public CrossStyle(CustomCrosshair crosshair) {
        super(crosshair);
    }

    @Override
    public void draw(int x, int y, ComputedProperties computedProperties) {
        boolean isOutlineEnabled = (Boolean)this.crosshair.isOutlineEnabled.get();
        if (isOutlineEnabled) {
            this.drawOutline(x, y, computedProperties);
        }
        this.drawBars(x, y, computedProperties);
    }

    private void drawOutline(int x, int y, ComputedProperties computedProperties) {
        RGBA outlineColour = (RGBA)this.crosshair.outlineColour.get();
        float thickness = (float)((Integer)this.crosshair.thickness.get()).intValue() - 0.5f;
        int width = (Integer)this.crosshair.width.get();
        int height = (Integer)this.crosshair.height.get();
        int gap = computedProperties.gap();
        double guiScale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        float offsetA = guiScale > 2.0 ? 0.25f : 0.0f;
        float offsetB = guiScale == 4.0 ? 0.25f : 0.0f;
        float offsetC = guiScale == 3.0 && thickness > 1.0f ? 0.25f : 0.0f;
        float[] top = new float[]{(float)x - thickness - 0.5f + offsetB + offsetC, (float)(y - gap - height) - 0.5f + offsetA - offsetC, (float)x - thickness - 0.5f + offsetB + offsetC, (float)(y - gap) + 0.5f - offsetB - offsetC, (float)x - thickness - 0.5f + offsetB + offsetC, (float)(y - gap) + 0.5f - offsetB, (float)x + thickness + 0.5f - offsetA, (float)(y - gap) + 0.5f - offsetB - offsetC, (float)x + thickness + 0.5f - offsetA, (float)(y - gap) + 0.5f - offsetB - offsetC, (float)x + thickness + 0.5f - offsetA, (float)(y - gap - height) - 0.5f + offsetA, (float)x + thickness + 0.5f - offsetA, (float)(y - gap - height) - 0.5f + offsetA, (float)x - thickness - 0.5f + offsetB + offsetC, (float)(y - gap - height) - 0.5f + offsetA};
        float[] bottom = new float[]{(float)x - thickness - 0.5f + offsetB + offsetC, (float)(y + gap + height) + 0.5f - offsetB - offsetC, (float)x - thickness - 0.5f + offsetB + offsetC, (float)(y + gap) - 0.5f + offsetA, (float)x - thickness - 0.5f + offsetB + offsetC, (float)(y + gap) - 0.5f + offsetA, (float)x + thickness + 0.5f - offsetA, (float)(y + gap) - 0.5f + offsetA, (float)x + thickness + 0.5f - offsetA, (float)(y + gap) - 0.5f + offsetA, (float)x + thickness + 0.5f - offsetA, (float)(y + gap + height) + 0.5f - offsetB - offsetC, (float)x + thickness + 0.5f - offsetA, (float)(y + gap + height) + 0.5f - offsetB - offsetC, (float)x - thickness - 0.5f + offsetB + offsetC, (float)(y + gap + height) + 0.5f - offsetB - offsetC};
        float[] right = new float[]{(float)(x + gap + width) + 0.5f - offsetA, (float)y - thickness - 0.5f + offsetA, (float)(x + gap + width) + 0.5f - offsetA, (float)y + thickness + 0.5f - offsetB - offsetC, (float)(x + gap + width) + 0.5f - offsetA, (float)y + thickness + 0.5f - offsetB - offsetC, (float)(x + gap) - 0.5f + offsetB + offsetC, (float)y + thickness + 0.5f - offsetB - offsetC, (float)(x + gap) - 0.5f + offsetB + offsetC, (float)y + thickness + 0.5f - offsetB - offsetC, (float)(x + gap) - 0.5f + offsetB + offsetC, (float)y - thickness - 0.5f + offsetA, (float)(x + gap) - 0.5f + offsetB + offsetC, (float)y - thickness - 0.5f + offsetA, (float)(x + gap + width) + 0.5f - offsetA, (float)y - thickness - 0.5f + offsetA};
        float[] left = new float[]{(float)(x - gap - width) - 0.5f + offsetA, (float)y - thickness - 0.5f + offsetA, (float)(x - gap - width) - 0.5f + offsetA, (float)y + thickness + 0.5f - offsetB - offsetC, (float)(x - gap - width) - 0.5f + offsetA, (float)y + thickness + 0.5f - offsetB - offsetC, (float)(x - gap) + 0.5f - offsetB, (float)y + thickness + 0.5f - offsetB, (float)(x - gap) + 0.5f - offsetB, (float)y + thickness + 0.5f - offsetB, (float)(x - gap) + 0.5f - offsetB, (float)y - thickness - 0.5f + offsetA - offsetC, (float)(x - gap) + 0.5f - offsetB, (float)y - thickness - 0.5f + offsetA - offsetC, (float)(x - gap - width) - 0.5f + offsetA, (float)y - thickness - 0.5f + offsetA};
        this.renderManager.drawLines(top, 2.0f, outlineColour);
        this.renderManager.drawLines(bottom, 2.0f, outlineColour);
        this.renderManager.drawLines(right, 2.0f, outlineColour);
        this.renderManager.drawLines(left, 2.0f, outlineColour);
    }

    public void drawBars(int x, int y, ComputedProperties computedProperties) {
        RGBA colour = computedProperties.colour();
        int gap = computedProperties.gap();
        float thickness = (float)((Integer)this.crosshair.thickness.get()).intValue() - 0.5f;
        int width = (Integer)this.crosshair.width.get();
        int height = (Integer)this.crosshair.height.get();
        this.renderManager.drawFilledRectangle((float)x - thickness, y - gap - height, (float)x + thickness, y - gap, colour);
        this.renderManager.drawFilledRectangle((float)x - thickness, y + gap, (float)x + thickness, y + gap + height, colour);
        this.renderManager.drawFilledRectangle(x - gap - width, (float)y - thickness, x - gap, (float)y + thickness, colour);
        this.renderManager.drawFilledRectangle(x + gap, (float)y - thickness, x + gap + width, (float)y + thickness, colour);
    }
}

