/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render.gui.screen;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.helper.ExternalHelper;
import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.render.gui.component.GuiComponent;
import com.wjbaker.ccm.render.gui.component.GuiComponentWithComponents;
import com.wjbaker.ccm.render.gui.component.components.ButtonGuiComponent;
import com.wjbaker.ccm.render.gui.component.event.IOnClickEvent;
import com.wjbaker.ccm.render.gui.screen.GuiScreenAdapter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public abstract class GuiScreen
extends GuiScreenAdapter {
    protected final RenderManager renderManager = new RenderManager();
    protected final GuiScreen parentGuiScreen;
    protected final List<GuiComponent> components;
    protected final int headerHeight;
    private final ButtonGuiComponent newVersionButton;

    public GuiScreen(String title) {
        this(title, null);
    }

    public GuiScreen(String title, GuiScreen parentGuiScreen) {
        super(title);
        this.parentGuiScreen = parentGuiScreen;
        this.components = new ArrayList<GuiComponent>();
        this.headerHeight = 35;
        this.newVersionButton = new ButtonGuiComponent(this, -1, -1, 125, 25, "New Version Available!");
        this.newVersionButton.setBaseBackgroundColour(ModTheme.TERTIARY);
        this.newVersionButton.setHoverBackgroundColour(ModTheme.TERTIARY_DARK);
        this.newVersionButton.setBaseTextColour(ModTheme.BLACK);
        this.newVersionButton.setHoverTextColour(ModTheme.BLACK);
        this.newVersionButton.addEvent(IOnClickEvent.class, () -> {
            if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
                new ExternalHelper().openInBrowser("https://www.curseforge.com/projects/242995/");
            }
        });
    }

    @Override
    public void update() {
        this.components.forEach(GuiComponent::update);
        this.newVersionButton.setPosition(this.field_230708_k_ - this.newVersionButton.getWidth() - 5, this.headerHeight / 2 - this.newVersionButton.getHeight() / 2);
    }

    @Override
    public void draw() {
        this.renderManager.drawFilledRectangle(0.0f, 0.0f, this.field_230708_k_, this.field_230709_l_, ModTheme.BLACK.setOpacity(140));
        this.components.forEach(GuiComponentWithComponents::draw);
        this.drawHeader();
    }

    private void drawHeader() {
        this.renderManager.drawFilledRectangle(0.0f, 0.0f, this.field_230708_k_, this.headerHeight, ModTheme.PRIMARY);
        this.renderManager.drawLine(0.0f, this.headerHeight, this.field_230708_k_, this.headerHeight, 2.0f, ModTheme.DARK_GREY);
        int titleWidth = this.renderManager.textWidth("Custom Crosshair Mod");
        int centreY = this.headerHeight / 2 - 3;
        this.renderManager.drawText("Custom Crosshair Mod", 5, centreY, ModTheme.WHITE, true);
        this.renderManager.drawSmallText("v1.2.1-forge", 8 + titleWidth, this.headerHeight / 2, ModTheme.DARK_GREY, false);
        if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
            this.newVersionButton.draw();
        }
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        this.components.stream().filter(x -> x.isInsideComponent(mouseX, mouseY)).forEach(x -> x.onMouseDown(mouseX, mouseY, button));
        this.newVersionButton.onMouseDown(mouseX, mouseY, button);
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        this.components.forEach(x -> x.onMouseUp(mouseX, mouseY, button));
        this.newVersionButton.onMouseUp(mouseX, mouseY, button);
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseMove(mouseX, mouseY));
        this.newVersionButton.onMouseMove(mouseX, mouseY);
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseDrag(startX, startY, mouseX, mouseY));
    }

    @Override
    public void onMouseScrollUp() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollUp);
    }

    @Override
    public void onMouseScrollDown() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollDown);
    }

    @Override
    public void onKeyDown(int keyCode) {
        if (keyCode == 256 && this.parentGuiScreen != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)this.parentGuiScreen);
        }
    }

    @Override
    public void onKeyUp(int keyCode) {
    }

    @Override
    public void close() {
        CustomCrosshairMod.INSTANCE.configManager().write();
    }
}

