/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import java.util.function.Supplier;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.darkutils.features.charms.CharmEffects;
import net.darkhax.darkutils.features.charms.ItemCharm;
import net.darkhax.darkutils.features.enderhopper.BlockEnderHopper;
import net.darkhax.darkutils.features.enderhopper.TileEntityEnderHopper;
import net.darkhax.darkutils.features.filters.BlockFilter;
import net.darkhax.darkutils.features.filters.Filters;
import net.darkhax.darkutils.features.flatblocks.BlockFlatTile;
import net.darkhax.darkutils.features.flatblocks.BlockFlatTileRotating;
import net.darkhax.darkutils.features.flatblocks.BlockFlatTileRotatingTicking;
import net.darkhax.darkutils.features.flatblocks.TileEffects;
import net.darkhax.darkutils.features.flatblocks.TileEntityTickingEffect;
import net.darkhax.darkutils.features.flatblocks.collision.CollisionEffectAnchor;
import net.darkhax.darkutils.features.glass.BlockDarkGlass;
import net.darkhax.darkutils.features.grates.BlockItemGrate;
import net.darkhax.darkutils.features.redstone.BlockRedstoneRandomizer;
import net.darkhax.darkutils.features.redstone.BlockShieldedRedstone;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Content {
    public final Block blankPlate;
    public final Block vectorPlate;
    public final Block exportPlate;
    public final Block importPlate;
    public final Block vectorPlateFast;
    public final Block exportPlateFast;
    public final Block importPlateFast;
    public final Block vectorPlateHyper;
    public final Block exportPlateHyper;
    public final Block importPlateHyper;
    public final Block runeDamage;
    public final Block runeDamagePlayer;
    public final Block runePoison;
    public final Block runeWeakness;
    public final Block runeSlowness;
    public final Block runeWither;
    public final Block runeFire;
    public final Block runeFatigue;
    public final Block runeGlowing;
    public final Block runeHunger;
    public final Block runeBlindness;
    public final Block runeNausea;
    public final Block anchorPlate;
    public final Block filterPlayer;
    public final Block filterUndead;
    public final Block filterArthropod;
    public final Block filterIllager;
    public final Block filterRaid;
    public final Block filterHostile;
    public final Block filterAnimal;
    public final Block filterChild;
    public final Block filterPet;
    public final Block filterSlime;
    public final Block filterBoss;
    public final Block filterVillager;
    public final Block filterFireImmune;
    public final Block filterExplosionImmune;
    public final Block filterGolem;
    public final Block filterWater;
    public final Block filterNamed;
    public final Block itemGrate;
    public final Block enderHopper;
    public final Block redstoneRandomizer;
    public final Block shieldedRedstone;
    public final Block darkGlass;
    public final Item sleepCharm;
    public final Item portalCharm;
    public final Item experienceCharm;
    public final Item gluttonyCharm;
    public final Item bookGalactic;
    public final Item bookRunelic;
    public final Item bookRestore;
    public final TileEntityType<TileEntityTickingEffect> tileTickingEffect;
    public final TileEntityType<TileEntityEnderHopper> tileEnderHopper;

    public Content(RegistryHelper registry) {
        this.blankPlate = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(), "blank_plate");
        this.vectorPlate = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotating(TileEffects.PUSH_WEAK), "vector_plate");
        this.exportPlate = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotatingTicking(TileEffects.PUSH_WEAK, TileEffects.EXPORT_WEAK, 10), "export_plate");
        this.importPlate = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotating(TileEffects.IMPORT_WEAK), "import_plate");
        this.vectorPlateFast = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotating(TileEffects.PUSH_NORMAL), "vector_plate_fast");
        this.exportPlateFast = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotatingTicking(TileEffects.PUSH_NORMAL, TileEffects.EXPORT_NORMAL, 10), "export_plate_fast");
        this.importPlateFast = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotating(TileEffects.IMPORT_NORMAL), "import_plate_fast");
        this.vectorPlateHyper = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotating(TileEffects.PUSH_STRONG), "vector_plate_extreme");
        this.exportPlateHyper = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotatingTicking(TileEffects.PUSH_STRONG, TileEffects.EXPORT_STRONG, 10), "export_plate_extreme");
        this.importPlateHyper = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotating(TileEffects.IMPORT_STRONG), "import_plate_extreme");
        this.runeDamage = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_DAMAGE), "rune_damage");
        this.runeDamagePlayer = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_DAMAGE_PLAYER), "rune_damage_player");
        this.runePoison = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_POISON), "rune_poison");
        this.runeWeakness = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_WEAKNESS), "rune_weakness");
        this.runeSlowness = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_SLOWNESS), "rune_slowness");
        this.runeWither = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_WITHER), "rune_wither");
        this.runeFire = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_FIRE), "rune_fire");
        this.runeFatigue = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_FATIGUE), "rune_fatigue");
        this.runeGlowing = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_GLOWING), "rune_glowing");
        this.runeHunger = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_HUNGER), "rune_hunger");
        this.runeBlindness = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_BLINDNESS), "rune_blindness");
        this.runeNausea = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTile(TileEffects.RUNE_NAUSEA), "rune_nausea");
        this.anchorPlate = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFlatTileRotating(new CollisionEffectAnchor()), "anchor_plate");
        this.filterPlayer = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterPlayer), "filter_player");
        this.filterUndead = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterUndead), "filter_undead");
        this.filterArthropod = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterArthropod), "filter_arthropod");
        this.filterIllager = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterIllager), "filter_illager");
        this.filterRaid = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterRaid), "filter_raid");
        this.filterHostile = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterHostile), "filter_hostile");
        this.filterAnimal = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterAnimal), "filter_animal");
        this.filterChild = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterBaby), "filter_child");
        this.filterPet = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterPet), "filter_pet");
        this.filterSlime = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterSlime), "filter_slime");
        this.filterBoss = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterBoss), "filter_boss");
        this.filterVillager = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterVillager), "filter_villager");
        this.filterFireImmune = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterFireImmune), "filter_fire_immune");
        this.filterExplosionImmune = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterExplosionImmune), "filter_explosion_immune");
        this.filterGolem = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterGolem), "filter_golem");
        this.filterWater = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterWater), "filter_water");
        this.filterNamed = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockFilter(Filters::filterNamed), "filter_named");
        this.itemGrate = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockItemGrate(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)), "item_grate");
        this.enderHopper = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockEnderHopper(), "ender_hopper");
        this.redstoneRandomizer = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockRedstoneRandomizer(), "redstone_randomizer");
        this.shieldedRedstone = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockShieldedRedstone(), "shielded_redstone");
        this.darkGlass = (Block)registry.blocks.register((IForgeRegistryEntry)new BlockDarkGlass(), "dark_glass");
        this.portalCharm = (Item)registry.items.register((IForgeRegistryEntry)new ItemCharm().setTickingEffect(CharmEffects::applyPortalCharmEffect), "charm_portal");
        this.sleepCharm = (Item)registry.items.register((IForgeRegistryEntry)new ItemCharm().setTickingEffect(CharmEffects::applySleepCharmEffect), "charm_sleep");
        this.experienceCharm = (Item)registry.items.register((IForgeRegistryEntry)new ItemCharm().setTickingEffect(CharmEffects::applyExperienceCharmTickEffect).addEvent(CharmEffects::handleExpCharmBlock).addEvent(CharmEffects::handleExpCharmEntity), "charm_experience");
        this.gluttonyCharm = (Item)registry.items.register((IForgeRegistryEntry)new ItemCharm().addEvent(CharmEffects::handleGluttonCharm), "charm_gluttony");
        this.bookGalactic = (Item)registry.items.register((IForgeRegistryEntry)new Item(new Item.Properties().func_208103_a(Rarity.UNCOMMON)), "book_galactic");
        this.bookRunelic = (Item)registry.items.register((IForgeRegistryEntry)new Item(new Item.Properties().func_208103_a(Rarity.UNCOMMON)), "book_runelic");
        this.bookRestore = (Item)registry.items.register((IForgeRegistryEntry)new Item(new Item.Properties().func_208103_a(Rarity.UNCOMMON)), "book_restore");
        this.registerItemPattern(registry, "vector_plate", Rarity.UNCOMMON);
        this.tileTickingEffect = Content.register("ticking_tile", TileEntityTickingEffect::new, this.exportPlate, this.exportPlateFast, this.exportPlateHyper);
        registry.tileEntities.register(this.tileTickingEffect);
        this.tileEnderHopper = Content.register("ender_hopper", TileEntityEnderHopper::new, this.enderHopper);
        registry.tileEntities.register(this.tileEnderHopper);
        registry.trades.addBasicWanderingTrade((VillagerTrades.ITrade)new BasicTrade(10, new ItemStack((IItemProvider)this.bookGalactic), 5, 30, 1.3f));
        registry.trades.addBasicWanderingTrade((VillagerTrades.ITrade)new BasicTrade(10, new ItemStack((IItemProvider)this.bookRunelic), 5, 30, 1.3f));
        registry.trades.addRareWanderingTrade((VillagerTrades.ITrade)new BasicTrade(20, new ItemStack((IItemProvider)this.bookRestore), 2, 30, 1.7f));
    }

    @Deprecated
    private static <T extends TileEntity> TileEntityType<T> register(String key, Supplier<? extends T> factoryIn, Block ... validBlocks) {
        Type type = Util.func_240976_a_((DSL.TypeReference)TypeReferences.field_211294_j, (String)("darkutils:" + key));
        TileEntityType.Builder builder = TileEntityType.Builder.func_223042_a(factoryIn, (Block[])validBlocks);
        TileEntityType tileType = builder.func_206865_a(type);
        tileType.setRegistryName("darkutils", key);
        return tileType;
    }

    public void registerItemPattern(RegistryHelper registry, String id, Rarity rarity) {
        BannerPattern pattern = registry.banners.registerPattern(id, true);
        registry.items.register((IForgeRegistryEntry)new BannerPatternItem(pattern, new Item.Properties().func_200917_a(1).func_208103_a(rarity)), id + "_banner_pattern");
    }
}

