/*
 * Decompiled with CFR 0.152.
 */
package com.ironkiller.deepdarkoceanmod.dimension;

import com.ironkiller.deepdarkoceanmod.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TallSeaGrassBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;

public class DeepDarkOceanChunkGenerator
extends ChunkGenerator<Config> {
    private final INoiseGenerator surfaceDepthNoise;
    protected final SharedSeedRandom randomSeed;
    public Random r;
    BlockState block1;
    BlockState block2;
    BlockState block3;
    BlockState bedrock;
    BlockState oceancrystalore;
    BlockState deepoceanportal;

    public DeepDarkOceanChunkGenerator(IWorld world, BiomeProvider provider) {
        super(world, provider, (GenerationSettings)Config.createDefault());
        this.r = new Random(this.field_222540_a.func_72905_C());
        this.block1 = Blocks.field_150355_j.func_176223_P();
        this.block2 = ModBlocks.DEEPOCEANSTONE.func_176223_P();
        this.block3 = ModBlocks.DEEPOCEANGLOWINGSTONE.func_176223_P();
        this.bedrock = Blocks.field_150357_h.func_176223_P();
        this.oceancrystalore = ModBlocks.OCEANCRYSTALORE.func_176223_P();
        this.deepoceanportal = ModBlocks.DEEPOCEANPORTAL.func_176223_P();
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.surfaceDepthNoise = new PerlinNoiseGenerator((Random)this.randomSeed, 4);
    }

    public void func_222535_c(IChunk chunk) {
        int z;
        int x;
        ChunkPos chunkpos = chunk.func_76632_l();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                chunk.func_177436_a((BlockPos)pos.func_181079_c(x, 0, z), this.bedrock, false);
                chunk.func_177436_a((BlockPos)pos.func_181079_c(x, 1, z), this.block2, false);
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                int realx = chunkpos.field_77276_a * 16 + x;
                int realz = chunkpos.field_77275_b * 16 + z;
                int height = this.field_222540_a.func_217301_I() - 1;
                double d1 = this.surfaceDepthNoise.func_215460_a((double)realx * 0.0625, (double)realz * 0.0625, 0.0625, 0.0625);
                this.generateFloor(chunk, pos, x, z, height, d1, true, 1, 50);
                this.generateFloor(chunk, pos, x, z, height, d1, false, 160, 10);
                d1 = this.surfaceDepthNoise.func_215460_a((double)(realx + 50) * 0.0625, (double)(realz + 50) * 0.0625, 0.0625, 0.0625);
                this.generateFloor(chunk, pos, x, z, height, d1, true, 140, 10);
                this.generateFloor(chunk, pos, x, z, height, d1, false, height, 50);
                for (int y = 1; y < height; ++y) {
                    this.generatePlants(chunk, x, y, z, this.block1, this.block2);
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                chunk.func_177436_a((BlockPos)pos.func_181079_c(x, this.field_222540_a.func_217301_I() - 1, z), this.bedrock, false);
                if (!chunk.func_180495_p((BlockPos)pos.func_181079_c(x, this.field_222540_a.func_217301_I() - 2, z)).getBlockState().equals((Object)this.block1)) continue;
                chunk.func_177436_a((BlockPos)pos.func_181079_c(x, this.field_222540_a.func_217301_I() - 2, z), this.deepoceanportal, false);
            }
        }
    }

    public void generateFloor(IChunk chunk, BlockPos.MutableBlockPos pos, int x, int z, int height, double d1, boolean pointedUp, int start, int offset) {
        int y;
        for (y = start; y < height; ++y) {
            if (chunk.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).getBlockState().equals((Object)this.block2) || chunk.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).getBlockState().equals((Object)this.block3) || !pointedUp) continue;
            if ((double)y < d1 * 10.0 + (double)offset + (double)start) {
                this.generateWorldBlock(chunk, pos, x, y, z);
                continue;
            }
            chunk.func_177436_a((BlockPos)pos.func_181079_c(x, y, z), this.block1, false);
        }
        if (!pointedUp) {
            for (y = 1; y < start; ++y) {
                if (chunk.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).getBlockState().equals((Object)this.block2) || chunk.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).getBlockState().equals((Object)this.block3)) continue;
                if ((double)y > d1 * 10.0 + (double)start - (double)offset) {
                    this.generateWorldBlock(chunk, pos, x, y, z);
                    continue;
                }
                chunk.func_177436_a((BlockPos)pos.func_181079_c(x, y, z), this.block1, false);
            }
        }
    }

    public void generateWorldBlock(IChunk chunk, BlockPos.MutableBlockPos pos, int x, int y, int z) {
        double i = this.r.nextInt((int)(40.0 * (0.1 * (double)(260 - y))));
        if (i > 1.0) {
            chunk.func_177436_a((BlockPos)pos.func_181079_c(x, y, z), this.block2, false);
        } else {
            chunk.func_177436_a((BlockPos)pos.func_181079_c(x, y, z), this.block3, false);
        }
    }

    public void generateOre(IChunk chunk, BlockPos.MutableBlockPos pos, int maxY, int minY, BlockState ore, int amount) {
        for (int count = 0; count < amount; ++count) {
            int numY = this.r.nextInt(maxY - minY) + minY;
            int numZ = this.r.nextInt(16);
            int numX = this.r.nextInt(16);
            if (!chunk.func_180495_p(new BlockPos(numX, numY, numZ)).getBlockState().equals((Object)this.block2)) continue;
            chunk.func_177436_a(new BlockPos(numX, numY, numZ), ore, false);
        }
    }

    public void generatePlants(IChunk chunk, int x, int y, int z, BlockState block1, BlockState block2) {
        int i = this.r.nextInt(10);
        if (i < 5 && chunk.func_180495_p(new BlockPos(x, y, z)).getBlockState().equals((Object)block2) && chunk.func_180495_p(new BlockPos(x, y + 1, z)).getBlockState().equals((Object)block1)) {
            chunk.func_177436_a(new BlockPos(x, y + 1, z), Blocks.field_203199_aR.func_176223_P(), false);
            if (chunk.func_180495_p(new BlockPos(x, y + 2, z)).getBlockState().equals((Object)block1) && i < 4) {
                chunk.func_177436_a(new BlockPos(x, y + 2, z), (BlockState)Blocks.field_203199_aR.func_176223_P().func_206870_a((IProperty)TallSeaGrassBlock.field_208065_c, (Comparable)DoubleBlockHalf.UPPER), false);
            }
        }
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
    }

    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type heightmapType) {
        return 0;
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F();
    }

    public static class Config
    extends GenerationSettings {
        public static Config createDefault() {
            Config config = new Config();
            config.func_214969_a(Blocks.field_150348_b.func_176223_P());
            config.func_214970_b(Blocks.field_150353_l.func_176223_P());
            return config;
        }
    }
}

