/*
 * Decompiled with CFR 0.152.
 */
package com.ironkiller.deepdarkoceanmod.entities;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerBossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuardianSquid
extends WaterMobEntity {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(GuardianSquid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(GuardianSquid.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private LivingEntity targetedEntity;
    protected RandomWalkingGoal wander;
    private int clientSideAttackTime;

    public GuardianSquid(EntityType<? extends GuardianSquid> type, World worldIn) {
        super(type, worldIn);
        this.field_70146_Z.setSeed(this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
        this.field_70749_g = new LookController((MobEntity)this);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 75;
    }

    protected void func_184651_r() {
        this.wander = new RandomWalkingGoal((CreatureEntity)this, 1.0, 80);
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 15, true, false, this::shouldAttack));
        this.field_70714_bg.func_75776_a(1, (Goal)new MoveRandomGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    public boolean func_213392_I() {
        return true;
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
    }

    public int getAttackDuration() {
        return 70;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public boolean shouldAttack(@Nullable LivingEntity p_204714_1_) {
        return true;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    public float getAttackAnimationScale(float p_175477_1_) {
        return ((float)this.clientSideAttackTime + p_175477_1_) / (float)this.getAttackDuration();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.squidRotation < (float)Math.PI) {
                float f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_213293_j(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vec3d vec3d = this.func_213322_ci();
            float f1 = MathHelper.func_76133_a((double)GuardianSquid.func_213296_b((Vec3d)vec3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)MathHelper.func_181159_b((double)f1, (double)vec3d.field_72448_b)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                double d0 = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d0 = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    d0 -= 0.08;
                }
                this.func_213293_j(0.0, d0 * (double)0.98f, 0.0);
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
        if (this.hasTargetedEntity()) {
            LivingEntity livingentity;
            if (this.clientSideAttackTime < this.getAttackDuration()) {
                ++this.clientSideAttackTime;
            }
            if ((livingentity = this.getTargetedEntity()) != null) {
                this.func_70671_ap().func_75651_a((Entity)livingentity, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
                double d5 = this.getAttackAnimationScale(0.0f);
                double d0 = livingentity.field_70165_t - this.field_70165_t;
                double d1 = livingentity.field_70163_u + (double)(livingentity.func_213302_cg() * 0.5f) - (this.field_70163_u + (double)this.func_70047_e());
                double d2 = livingentity.field_70161_v - this.field_70161_v;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.field_70146_Z.nextDouble();
                while (d4 < d3) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.field_70165_t + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.field_70163_u + d1 * d4 + (double)this.func_70047_e(), this.field_70161_v + d2 * d4, 0.0, 0.0, 0.0);
                }
            }
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount) && this.func_70643_av() != null) {
            this.squirtInk();
            return true;
        }
        return false;
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private Vec3d func_207400_b(Vec3d p_207400_1_) {
        Vec3d vec3d = p_207400_1_.func_178789_a(this.prevSquidPitch * ((float)Math.PI / 180));
        vec3d = vec3d.func_178785_b(-this.field_70760_ar * ((float)Math.PI / 180));
        return vec3d;
    }

    private void squirtInk() {
        this.func_184185_a(SoundEvents.field_203639_hT, this.func_70599_aP(), this.func_70647_i());
        Vec3d vec3d = this.func_207400_b(new Vec3d(0.0, -1.0, 0.0)).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < 30; ++i) {
            Vec3d vec3d1 = this.func_207400_b(new Vec3d((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3, -1.0, (double)this.field_70146_Z.nextFloat() * 0.6 - 0.3));
            Vec3d vec3d2 = vec3d1.func_186678_a(0.3 + (double)(this.field_70146_Z.nextFloat() * 2.0f));
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_203219_V, vec3d.field_72450_a, vec3d.field_72448_b + 0.5, vec3d.field_72449_c, 0, vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c, (double)0.1f);
        }
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public static boolean func_223365_b(EntityType<GuardianSquid> p_223365_0_, IWorld p_223365_1_, SpawnReason p_223365_2_, BlockPos p_223365_3_, Random p_223365_4_) {
        return p_223365_3_.func_177956_o() > 45 && p_223365_3_.func_177956_o() < p_223365_1_.func_181545_F();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    static class AttackGoal
    extends Goal {
        private final GuardianSquid guardian;
        private int tickCounter;

        public AttackGoal(GuardianSquid guardian) {
            this.guardian = guardian;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.guardian.func_70638_az();
            return livingentity != null && livingentity.func_70089_S();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.guardian.func_70068_e((Entity)this.guardian.func_70638_az()) > 9.0;
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.guardian.func_70661_as().func_75499_g();
            this.guardian.func_70671_ap().func_75651_a((Entity)this.guardian.func_70638_az(), 90.0f, 90.0f);
            this.guardian.field_70160_al = true;
        }

        public void func_75251_c() {
            this.guardian.setTargetedEntity(0);
            this.guardian.func_70624_b(null);
            this.guardian.wander.func_179480_f();
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.guardian.func_70638_az();
            this.guardian.func_70661_as().func_75499_g();
            this.guardian.func_70671_ap().func_75651_a((Entity)livingentity, 90.0f, 90.0f);
            if (!this.guardian.func_70685_l((Entity)livingentity)) {
                this.guardian.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.guardian.setTargetedEntity(this.guardian.func_70638_az().func_145782_y());
                } else if (this.tickCounter >= this.guardian.getAttackDuration()) {
                    float f = 1.0f;
                    if (this.guardian.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                        f += 2.0f;
                    }
                    livingentity.func_70097_a(DamageSource.func_76354_b((Entity)this.guardian, (Entity)this.guardian), f);
                    livingentity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.guardian), (float)this.guardian.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.guardian.func_70624_b(null);
                }
                super.func_75246_d();
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        private final GuardianSquid squid;

        public MoveRandomGoal(GuardianSquid p_i48823_2_) {
            this.squid = p_i48823_2_;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.squid.func_70654_ax();
            if (i > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.func_70681_au().nextInt(50) == 0 || !this.squid.field_70171_ac || !this.squid.hasMovementVector()) {
                float f = this.squid.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.squid.setMovementVector(f1, f2, f3);
            }
        }
    }

    class FleeGoal
    extends Goal {
        private int tickCounter;

        private FleeGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = GuardianSquid.this.func_70643_av();
            if (GuardianSquid.this.func_70090_H() && livingentity != null) {
                return GuardianSquid.this.func_70068_e((Entity)livingentity) < 100.0;
            }
            return false;
        }

        public void func_75249_e() {
            this.tickCounter = 0;
        }

        public void func_75246_d() {
            ++this.tickCounter;
            LivingEntity livingentity = GuardianSquid.this.func_70643_av();
            if (livingentity != null) {
                Vec3d vec3d = new Vec3d(GuardianSquid.this.field_70165_t - livingentity.field_70165_t, GuardianSquid.this.field_70163_u - livingentity.field_70163_u, GuardianSquid.this.field_70161_v - livingentity.field_70161_v);
                BlockState blockstate = GuardianSquid.this.field_70170_p.func_180495_p(new BlockPos(GuardianSquid.this.field_70165_t + vec3d.field_72450_a, GuardianSquid.this.field_70163_u + vec3d.field_72448_b, GuardianSquid.this.field_70161_v + vec3d.field_72449_c));
                IFluidState ifluidstate = GuardianSquid.this.field_70170_p.func_204610_c(new BlockPos(GuardianSquid.this.field_70165_t + vec3d.field_72450_a, GuardianSquid.this.field_70163_u + vec3d.field_72448_b, GuardianSquid.this.field_70161_v + vec3d.field_72449_c));
                if (ifluidstate.func_206884_a(FluidTags.field_206959_a) || blockstate.func_196958_f()) {
                    double d0 = vec3d.func_72433_c();
                    if (d0 > 0.0) {
                        vec3d.func_72432_b();
                        float f = 3.0f;
                        if (d0 > 5.0) {
                            f = (float)((double)f - (d0 - 5.0) / 5.0);
                        }
                        if (f > 0.0f) {
                            vec3d = vec3d.func_186678_a((double)f);
                        }
                    }
                    if (blockstate.func_196958_f()) {
                        vec3d = vec3d.func_178786_a(0.0, vec3d.field_72448_b, 0.0);
                    }
                    GuardianSquid.this.setMovementVector((float)vec3d.field_72450_a / 20.0f, (float)vec3d.field_72448_b / 20.0f, (float)vec3d.field_72449_c / 20.0f);
                }
                if (this.tickCounter % 10 == 5) {
                    GuardianSquid.this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, GuardianSquid.this.field_70165_t, GuardianSquid.this.field_70163_u, GuardianSquid.this.field_70161_v, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

