/*
 * Decompiled with CFR 0.152.
 */
package com.ironkiller.deepdarkoceanmod.entities;

import com.ironkiller.deepdarkoceanmod.entities.GuardianSquid;
import com.ironkiller.deepdarkoceanmod.entities.Piranha;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SummonedPiranha
extends WaterMobEntity {
    private SummonedPiranha groupLeader;
    private int groupSize = 1;

    public SummonedPiranha(EntityType<? extends SummonedPiranha> type, World worldIN) {
        super(type, worldIN);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new LookController((MobEntity)this);
    }

    public void func_70636_d() {
        if (!this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        super.func_70636_d();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, p_213619_0_ -> p_213619_0_ instanceof IMob || p_213619_0_ instanceof GuardianSquid || p_213619_0_ instanceof Piranha));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal(this));
    }

    protected void func_209207_l(int p_209207_1_) {
        this.func_70050_g(p_209207_1_ - 1);
        if (this.func_70086_ai() == -300) {
            this.func_70097_a(DamageSource.field_76369_e, 2.0f);
        }
    }

    public SummonedPiranha func_212803_a(SummonedPiranha groupLeaderIn) {
        this.groupLeader = groupLeaderIn;
        groupLeaderIn.increaseGroupSize();
        return groupLeaderIn;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (spawnDataIn == null) {
            spawnDataIn = new GroupData(this);
        } else {
            this.func_212803_a(((GroupData)spawnDataIn).groupLeader);
        }
        return spawnDataIn;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
    }

    public boolean shouldAttack(@Nullable LivingEntity p_204714_1_) {
        return true;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_204413_iX;
    }

    public int func_70641_bl() {
        return this.getMaxGroupSize();
    }

    public int getMaxGroupSize() {
        return 15;
    }

    protected boolean func_212800_dy() {
        return !this.hasGroupLeader();
    }

    public boolean hasGroupLeader() {
        return this.groupLeader != null && this.groupLeader.func_70089_S();
    }

    private void increaseGroupSize() {
        ++this.groupSize;
    }

    private void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canGroupGrow() {
        return this.isGroupLeader() && this.groupSize < this.getMaxGroupSize();
    }

    public boolean isGroupLeader() {
        return this.groupSize > 1;
    }

    public boolean inRangeOfGroupLeader() {
        return this.func_70068_e((Entity)this.groupLeader) <= 121.0;
    }

    public void moveToGroupLeader() {
        if (this.hasGroupLeader()) {
            this.func_70661_as().func_75497_a((Entity)this.groupLeader, 1.0);
        }
    }

    public void func_212810_a(Stream<SummonedPiranha> p_212810_1_) {
        p_212810_1_.limit(this.getMaxGroupSize() - this.groupSize).filter(p_212801_1_ -> p_212801_1_ != this).forEach(p_212804_1_ -> p_212804_1_.func_212803_a(this));
    }

    public void leaveGroup() {
        this.groupLeader.decreaseGroupSize();
        this.groupLeader = null;
    }

    public static class GroupData
    implements ILivingEntityData {
        public final SummonedPiranha groupLeader;

        public GroupData(SummonedPiranha groupLeaderIn) {
            this.groupLeader = groupLeaderIn;
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final SummonedPiranha piranha;

        public SwimGoal(SummonedPiranha piranhaIn) {
            super((CreatureEntity)piranhaIn, 1.0, 40);
            this.piranha = piranhaIn;
        }

        public boolean func_75250_a() {
            return this.piranha.func_212800_dy() && super.func_75250_a();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final SummonedPiranha piranha;

        MoveHelperController(SummonedPiranha piranhaIn) {
            super((MobEntity)piranhaIn);
            this.piranha = piranhaIn;
        }

        public void func_75641_c() {
            if (this.piranha.func_208600_a(FluidTags.field_206959_a)) {
                this.piranha.func_213317_d(this.piranha.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.piranha.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.piranha.field_70165_t;
                double d1 = this.field_75647_c - this.piranha.field_70163_u;
                double d2 = this.field_75644_d - this.piranha.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.piranha.field_70761_aq = this.piranha.field_70177_z = this.func_75639_a(this.piranha.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.piranha.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.piranha.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.piranha.func_70689_ay(), (float)f1));
                this.piranha.func_213317_d(this.piranha.func_213322_ci().func_72441_c(d0 * 0.05, (double)this.piranha.func_70689_ay() * (d1 /= d3) * 0.1, d2 * 0.05));
            } else {
                this.piranha.func_70659_e(0.0f);
            }
        }
    }
}

