/*
 * Decompiled with CFR 0.152.
 */
package com.ironkiller.deepdarkoceanmod.feature;

import com.ironkiller.deepdarkoceanmod.blocks.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class DeepWaterMelonPlant
extends Feature<NoFeatureConfig> {
    public DeepWaterMelonPlant(Function<Dynamic<?>, ? extends NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!this.correctPosition(worldIn, pos)) {
            pos = this.getNearbyCorrectPosition(worldIn, pos);
        }
        if (this.correctPosition(worldIn, pos)) {
            this.generatePlantAtLocation(worldIn, pos);
            return true;
        }
        this.createSecondPlant(worldIn, pos);
        this.createSecondPlant(worldIn, pos.func_177976_e().func_177976_e());
        return false;
    }

    public Boolean createSecondPlant(IWorld worldIn, BlockPos pos) {
        if (!this.correctPosition(worldIn, pos = pos.func_177974_f())) {
            pos = this.getNearbyCorrectPosition(worldIn, pos);
        }
        if (this.correctPosition(worldIn, pos)) {
            this.generatePlantAtLocation(worldIn, pos);
            return true;
        }
        return false;
    }

    public void generatePlantAtLocation(IWorld worldIn, BlockPos pos) {
        this.placeBlockAttempt(worldIn, pos, ModBlocks.DEEP_WATER_MELON_STALK.func_176223_P());
        pos = pos.func_177977_b();
        int stalkLength = new Random().nextInt(6);
        for (int x = 0; x < stalkLength; ++x) {
            Boolean b = this.placeBlockAttempt(worldIn, pos, ModBlocks.DEEP_WATER_MELON_STALK.func_176223_P());
            if (!b.booleanValue()) {
                return;
            }
            pos = pos.func_177977_b();
        }
        this.placeBlockAttempt(worldIn, pos, ModBlocks.DEEP_WATER_MELON_BLOCK.func_176223_P());
    }

    public BlockPos getNearbyCorrectPosition(IWorld worldIn, BlockPos pos) {
        int x;
        for (x = 0; x < 30; ++x) {
            if (x + pos.func_177956_o() >= worldIn.func_217301_I() || !this.correctPosition(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + x, pos.func_177952_p()))) continue;
            pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + x, pos.func_177952_p());
            return pos;
        }
        for (x = 0; x < 30; ++x) {
            if (pos.func_177956_o() - x <= 0 || !this.correctPosition(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - x, pos.func_177952_p()))) continue;
            pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - x, pos.func_177952_p());
            return pos;
        }
        return pos;
    }

    public boolean correctPosition(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_200132_m() && world.func_180495_p(pos).equals((Object)Blocks.field_150355_j.func_176223_P());
    }

    public Boolean placeBlockAttempt(IWorld world, BlockPos pos, BlockState blockstate) {
        if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150355_j)) {
            world.func_180501_a(pos, blockstate, 1);
            return true;
        }
        return false;
    }
}

