/*
 * Decompiled with CFR 0.152.
 */
package com.ironkiller.deepdarkoceanmod.tools;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeleportationTools {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Entity changeDimension(DimensionType destination, ServerPlayerEntity entity) {
        if (!ForgeHooks.onTravelToDimension((Entity)entity, (DimensionType)destination)) {
            return null;
        }
        DimensionType dimensiontype = entity.field_71093_bK;
        ServerWorld serverworld = entity.field_71133_b.func_71218_a(dimensiontype);
        entity.field_71093_bK = destination;
        ServerWorld serverworld1 = entity.field_71133_b.func_71218_a(destination);
        WorldInfo worldinfo = entity.field_70170_p.func_72912_H();
        NetworkHooks.sendDimensionDataPacket((NetworkManager)entity.field_71135_a.field_147371_a, (ServerPlayerEntity)entity);
        entity.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination, worldinfo.func_76067_t(), entity.field_71134_c.func_73081_b()));
        entity.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = entity.field_71133_b.func_184103_al();
        playerlist.func_187243_f(entity);
        serverworld.removeEntity((Entity)entity, true);
        entity.revive();
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        float f = entity.field_70125_A;
        float f1 = entity.field_70177_z;
        double d3 = 8.0;
        float f2 = f1;
        serverworld.func_217381_Z().func_76320_a("moving");
        double moveFactor = serverworld.func_201675_m().getMovementFactor() / serverworld1.func_201675_m().getMovementFactor();
        d0 *= moveFactor;
        d2 *= moveFactor;
        if ((dimensiontype != DimensionType.field_223227_a_ || destination != DimensionType.field_223228_b_) && dimensiontype == DimensionType.field_223227_a_ && destination == DimensionType.field_223229_c_) {
            BlockPos blockpos = serverworld1.func_180504_m();
            d0 = blockpos.func_177958_n();
            d1 = blockpos.func_177956_o();
            d2 = blockpos.func_177952_p();
            f1 = 90.0f;
            f = 0.0f;
        }
        entity.func_70012_b(d0, d1, d2, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        serverworld.func_217381_Z().func_76320_a("placing");
        double d7 = Math.min(-2.9999872E7, serverworld1.func_175723_af().func_177726_b() + 16.0);
        double d4 = Math.min(-2.9999872E7, serverworld1.func_175723_af().func_177736_c() + 16.0);
        double d5 = Math.min(2.9999872E7, serverworld1.func_175723_af().func_177728_d() - 16.0);
        double d6 = Math.min(2.9999872E7, serverworld1.func_175723_af().func_177733_e() - 16.0);
        d0 = MathHelper.func_151237_a((double)d0, (double)d7, (double)d5);
        d2 = MathHelper.func_151237_a((double)d2, (double)d4, (double)d6);
        entity.func_70012_b(d0, d1, d2, f1, f);
        if (destination == DimensionType.field_223229_c_) {
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u) - 1;
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            boolean l = true;
            boolean i1 = false;
            for (int j1 = -2; j1 <= 2; ++j1) {
                for (int k1 = -2; k1 <= 2; ++k1) {
                    for (int l1 = -1; l1 < 3; ++l1) {
                        int i2 = i + k1 * 1 + j1 * 0;
                        int j2 = j + l1;
                        int k2 = k + k1 * 0 - j1 * 1;
                        boolean flag = l1 < 0;
                        serverworld1.func_175656_a(new BlockPos(i2, j2, k2), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            entity.func_70012_b((double)i, (double)j, (double)k, f1, 0.0f);
            entity.func_213317_d(Vec3d.field_186680_a);
        } else if (!serverworld1.func_85176_s().func_222268_a((Entity)entity, f2)) {
            serverworld1.func_85176_s().func_222268_a((Entity)entity, f2);
        }
        serverworld.func_217381_Z().func_76319_b();
        entity.func_70029_a((World)serverworld1);
        serverworld1.func_217447_b(entity);
        TeleportationTools.func_213846_b(serverworld, entity);
        entity.field_71135_a.func_147364_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, f1, f);
        entity.field_71134_c.func_73080_a(serverworld1);
        entity.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(entity.field_71075_bZ));
        playerlist.func_72354_b(entity, serverworld1);
        playerlist.func_72385_f(entity);
        for (EffectInstance effectinstance : entity.func_70651_bq()) {
            entity.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), effectinstance));
        }
        entity.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)entity, (DimensionType)dimensiontype, (DimensionType)destination);
        return entity;
    }

    public static void teleportToSafePlace(Entity e, boolean goUp) {
        block8: {
            World world = e.field_70170_p;
            if (goUp) {
                for (int y = world.getMaxHeight() - 1; y > 0; --y) {
                    for (int x = 0; x < 3; ++x) {
                        for (int z = 0; z < 3; ++z) {
                            if (!TeleportationTools.checkIfSafe(world, (int)e.field_70165_t + x, y, (int)e.field_70161_v + z)) continue;
                            e.func_70634_a(e.field_70165_t + (double)x, (double)(y - 2), e.field_70161_v + (double)z);
                            break block8;
                        }
                    }
                }
            } else {
                for (int y = e.field_70170_p.getMaxHeight(); y > 1; --y) {
                    for (int x = 0; x < 3; ++x) {
                        for (int z = 0; z < 3; ++z) {
                            if (!TeleportationTools.checkIfSafe(world, (int)e.field_70165_t + x, y, (int)e.field_70161_v + z)) continue;
                            e.func_70634_a(e.field_70165_t + (double)x, (double)y, e.field_70161_v + (double)z);
                            break block8;
                        }
                    }
                }
            }
        }
    }

    private static boolean checkIfSafe(World world, int x, int y, int z) {
        if (world.func_180495_p(new BlockPos(x, y - 1, z)).func_200132_m() && world.func_180495_p(new BlockPos(x, y, z)).equals((Object)Blocks.field_150350_a.func_176223_P()) && world.func_180495_p(new BlockPos(x, y + 1, z)).equals((Object)Blocks.field_150350_a.func_176223_P())) {
            LOGGER.info("found position: " + y);
            return true;
        }
        if (world.func_180495_p(new BlockPos(x, y, z)).equals((Object)Blocks.field_150355_j.func_176223_P()) && world.func_180495_p(new BlockPos(x, y + 1, z)).equals((Object)Blocks.field_150355_j.func_176223_P())) {
            LOGGER.info("found position: " + y);
            return true;
        }
        return false;
    }

    private static void func_213846_b(ServerWorld p_213846_1_, ServerPlayerEntity entity) {
        DimensionType dimensiontype = p_213846_1_.field_73011_w.func_186058_p();
        DimensionType dimensiontype1 = entity.field_70170_p.field_73011_w.func_186058_p();
        CriteriaTriggers.field_193134_u.func_193143_a(entity, dimensiontype, dimensiontype1);
    }
}

