/*
 * Decompiled with CFR 0.152.
 */
package com.ironkiller.deepdarkoceanmod.entities;

import com.ironkiller.deepdarkoceanmod.entities.goal.WaterTemptGoal;
import com.ironkiller.deepdarkoceanmod.items.ModItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;

public class MantaRay
extends WaterMobEntity
implements IJumpingMount {
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(MantaRay.class, (IDataSerializer)DataSerializers.field_187191_a);

    public MantaRay(EntityType<? extends MantaRay> type, World worldIN) {
        super(type, worldIN);
        this.field_70749_g = new LookController((MobEntity)this);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_110147_ax() {
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111267_a);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111266_c);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111263_d);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188791_g);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_189429_h);
        this.func_110140_aT().func_111150_b(SWIM_SPEED);
        this.func_110140_aT().func_111150_b(NAMETAG_DISTANCE);
        this.func_110140_aT().func_111150_b(ENTITY_GRAVITY);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new WaterTemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.DEEPWATERMELON}), false));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public boolean shouldAttack(@Nullable LivingEntity p_204714_1_) {
        return this.isTame();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
    }

    protected void setMantaRayWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        if (p_110208_2_) {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public void setMantaRayTamed(boolean tamed) {
        this.setMantaRayWatchableBoolean(2, tamed);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_213352_e(Vec3d moveVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF()) {
                double d3;
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    if (!this.func_70090_H()) {
                        this.func_70659_e(0.0f);
                    }
                    super.func_213352_e(new Vec3d((double)f, moveVector.field_72448_b, (double)f1));
                    if (this.func_70090_H()) {
                        float rp = 0.0f;
                        if (f1 > 0.0f) {
                            rp = this.field_70125_A / 20.0f * -1.0f;
                        }
                        this.func_213309_a(0.12f, new Vec3d((double)f, (double)rp, (double)f1));
                    }
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d2 = (double)this.func_180425_c().func_177958_n() - this.field_70169_q;
                float f4 = MathHelper.func_76133_a((double)(d2 * d2 + (d3 = (double)this.func_180425_c().func_177952_p() - this.field_70166_s) * d3)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(moveVector);
            }
        }
    }

    protected float func_189749_co() {
        return 0.8f;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = !itemstack.func_190926_b();
        if (flag && itemstack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(player, hand);
        }
        if (this.func_184207_aI()) {
            return super.func_184645_a(player, hand);
        }
        if (flag) {
            if (this.handleEating(player, itemstack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_111282_a(player, (LivingEntity)this, hand)) {
                return true;
            }
        }
        if (this.func_70631_g_() || !this.isTame()) {
            return super.func_184645_a(player, hand);
        }
        this.mountTo(player);
        return true;
    }

    protected void mountTo(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_184220_m((Entity)this);
        }
    }

    protected boolean getMantaRayWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & p_110233_1_) != 0;
    }

    public boolean isTame() {
        return this.getMantaRayWatchableBoolean(2);
    }

    protected boolean handleEating(PlayerEntity player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        Item item = stack.func_77973_b();
        if (item == ModItems.LIGNONUT) {
            f = 2.0f;
            i = 20;
            j = 3;
        } else if (item == ModItems.DEEPWATERMELON) {
            f = 2.0f;
            i = 20;
            j = 3;
            flag = true;
            if (new Random().nextInt(4) == 1) {
                this.setMantaRayTamed(true);
                if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
                    for (int u = 0; u < 7; ++u) {
                        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, (double)this.func_180425_c().func_177958_n() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), (double)this.func_180425_c().func_177956_o() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), (double)this.func_180425_c().func_177952_p() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                    }
                }
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (flag) {
            this.eatingMantaRay();
        }
        return flag;
    }

    private void eatingMantaRay() {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p(), SoundEvents.field_205207_aX, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
    }

    public boolean func_184776_b() {
        return false;
    }

    public void func_184775_b(int p_184775_1_) {
    }

    public void func_184777_r_() {
    }

    static class MoveTowardsTargetGoal
    extends net.minecraft.entity.ai.goal.MoveTowardsTargetGoal {
        private final MantaRay mantaRay;

        public MoveTowardsTargetGoal(MantaRay creature, double speedIn, float targetMaxDistance) {
            super((CreatureEntity)creature, 1.0, 10.0f);
            this.mantaRay = creature;
        }

        public boolean func_75253_b() {
            if (!this.mantaRay.func_184207_aI()) {
                return super.func_75253_b();
            }
            return false;
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final MantaRay MantaRay;

        MoveHelperController(MantaRay MantaRayIn) {
            super((MobEntity)MantaRayIn);
            this.MantaRay = MantaRayIn;
        }

        public void func_75641_c() {
            if (this.MantaRay.func_208600_a(FluidTags.field_206959_a)) {
                this.MantaRay.func_213317_d(this.MantaRay.func_213322_ci().func_72441_c(0.0, 0.004, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.MantaRay.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.MantaRay.func_226277_ct_();
                double d1 = this.field_75647_c - this.MantaRay.func_226278_cu_();
                double d2 = this.field_75644_d - this.MantaRay.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.MantaRay.field_70761_aq = this.MantaRay.field_70177_z = this.func_75639_a(this.MantaRay.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.MantaRay.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.MantaRay.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.MantaRay.func_70689_ay(), (float)f1));
                this.MantaRay.func_213317_d(this.MantaRay.func_213322_ci().func_72441_c(d0 * 0.01, (double)this.MantaRay.func_70689_ay() * (d1 /= d3) * 0.01, d2 * 0.01));
            }
        }
    }
}

