/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainingTile;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.IBCoreBlock;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBCore
extends Block
implements IBCoreBlock {
    public static final String BC_TILE_DATA_TAG = "bc_tile_data";
    public static final String BC_MANAGED_DATA_FLAG = "bc_managed_data";
    protected boolean canProvidePower = false;
    protected boolean hasSubItemTypes = false;
    protected boolean isMobResistant = false;
    public Map<Integer, String> nameOverrides = new HashMap<Integer, String>();

    public BlockBCore(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IDataRetainingTile && !BrandonsCore.proxy.isCTRLKeyDown()) {
            CompoundNBT tileData = new CompoundNBT();
            ((IDataRetainingTile)tile).writeToItemStack(tileData, false);
            if (!tileData.isEmpty()) {
                ItemNBTHelper.getCompound(stack).func_218657_a(BC_TILE_DATA_TAG, (INBT)tileData);
            }
        }
        if (tile instanceof INameable && ((INameable)tile).func_145818_k_()) {
            stack.func_200302_a(((INameable)tile).func_200200_C_());
        }
        return stack;
    }

    public boolean isBlockFullCube() {
        return false;
    }

    public BlockBCore addName(int meta, String name) {
        this.nameOverrides.put(meta, name);
        this.setHasSubItemTypes(true);
        return this;
    }

    public BlockBCore setHasSubItemTypes(boolean hasSubItemTypes) {
        this.hasSubItemTypes = hasSubItemTypes;
        return this;
    }

    @Override
    public boolean hasSubItemTypes() {
        return this.hasSubItemTypes;
    }

    @Override
    public Map<Integer, String> getNameOverrides() {
        return this.nameOverrides;
    }

    @Deprecated
    public boolean isBlockEnabled() {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (this.hasTileEntity(state)) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof IRedstoneEmitter;
        }
        return this.canProvidePower || super.canConnectRedstone(state, world, pos, side);
    }

    public boolean func_149744_f(BlockState state) {
        return this.canProvidePower;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        if (this.hasTileEntity(state)) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof IChangeListener;
        }
        return super.shouldCheckWeakPower(state, world, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity tile;
        if (this.hasTileEntity(blockState) && (tile = blockAccess.func_175625_s(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getWeakPower(blockState, side);
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity tile;
        if (this.hasTileEntity(blockState) && (tile = blockAccess.func_175625_s(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getStrongPower(blockState, side);
        }
        return super.func_176211_b(blockState, blockAccess, pos, side);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntity tile;
        if (this.hasTileEntity(state) && (tile = world.func_175625_s(pos)) instanceof IChangeListener) {
            ((IChangeListener)tile).onNeighborChange(fromPos);
        }
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile;
        if (this.hasTileEntity(state) && (tile = worldIn.func_175625_s(pos)) instanceof IActivatableTile) {
            return ((IActivatableTile)tile).onBlockActivated(state, player, handIn, hit) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IDataRetainingTile && stack.func_77942_o() && stack.func_77978_p().func_74764_b(BC_TILE_DATA_TAG)) {
            ((IDataRetainingTile)tile).readFromItemStack(stack.func_179543_a(BC_TILE_DATA_TAG));
        }
        if (tile instanceof TileBCore && stack.func_82837_s()) {
            ((TileBCore)tile).setCustomName(stack.func_200301_q().getString());
        }
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack heldStack) {
        ItemStack stack = null;
        if (te instanceof IDataRetainingTile && ((IDataRetainingTile)te).saveToItem()) {
            CompoundNBT tileData = new CompoundNBT();
            ((IDataRetainingTile)te).writeToItemStack(tileData, true);
            if (!tileData.isEmpty()) {
                stack = new ItemStack((IItemProvider)this, 1);
                ItemNBTHelper.getCompound(stack).func_218657_a(BC_TILE_DATA_TAG, (INBT)tileData);
            }
        }
        if (te instanceof INameable && ((INameable)te).func_145818_k_()) {
            if (stack == null) {
                stack = new ItemStack((IItemProvider)this, 1);
            }
            stack.func_200302_a(((INameable)te).func_200200_C_());
        }
        if (stack != null) {
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
            player.func_71020_j(0.005f);
            BlockBCore.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            world.func_175713_t(pos);
        } else {
            super.func_180657_a(world, player, pos, state, te, heldStack);
        }
    }

    public BlockBCore setMobResistant() {
        this.isMobResistant = true;
        return this;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (!this.isMobResistant) {
            return super.canEntityDestroy(state, world, pos, entity);
        }
        return entity instanceof PlayerEntity;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (!this.isMobResistant) {
            super.onBlockExploded(state, world, pos, explosion);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        if (!this.isMobResistant) {
            return super.func_149659_a(explosionIn);
        }
        return false;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return !this.isBlockFullCube();
    }

    public static int getRedstonePower(IWorldReader world, BlockPos pos, Direction facing) {
        BlockState blockstate = world.func_180495_p(pos);
        return blockstate.shouldCheckWeakPower(world, pos, facing) ? BlockBCore.getStrongPower(world, pos) : blockstate.func_185911_a((IBlockReader)world, pos, facing);
    }

    public static int getStrongPower(IWorldReader world, BlockPos pos) {
        int i = 0;
        if ((i = Math.max(i, world.func_175627_a(pos.func_177977_b(), Direction.DOWN))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.func_175627_a(pos.func_177984_a(), Direction.UP))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.func_175627_a(pos.func_177978_c(), Direction.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.func_175627_a(pos.func_177968_d(), Direction.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.func_175627_a(pos.func_177976_e(), Direction.WEST))) >= 15) {
            return i;
        }
        return (i = Math.max(i, world.func_175627_a(pos.func_177974_f(), Direction.EAST))) >= 15 ? i : i;
    }

    public static boolean isBlockPowered(IWorldReader world, BlockPos pos) {
        if (BlockBCore.getRedstonePower(world, pos.func_177977_b(), Direction.DOWN) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.func_177984_a(), Direction.UP) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.func_177978_c(), Direction.NORTH) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.func_177968_d(), Direction.SOUTH) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.func_177976_e(), Direction.WEST) > 0) {
            return true;
        }
        return BlockBCore.getRedstonePower(world, pos.func_177974_f(), Direction.EAST) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(BC_TILE_DATA_TAG)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.brandonscore.block_has_saved_data"));
        }
    }

    @Override
    public boolean overrideShareTag() {
        return false;
    }

    @Override
    public CompoundNBT getNBTShareTag(ItemStack stack) {
        return stack.func_77978_p();
    }
}

