/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.math.MathHelper;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.IGuiParentElement;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.HoverTextSupplier;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMouseOver;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GuiElement<E extends GuiElement<E>>
implements IMouseOver,
IGuiParentElement<E> {
    private static final String INTERNAL_TRANSLATION_PREFIX = "mod_gui.brandonscore.";
    protected static final ResourceLocation WIDGETS_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    public static final RenderType transColourType = RenderType.func_228632_a_((String)"trans_colour", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228714_a_(RenderState.field_228491_A_).func_228723_a_(RenderState.field_228520_l_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private int xPos;
    private int yPos;
    private int lastTickXPos;
    private int lastTickYPos;
    private int animFrameX;
    private int animFrameY;
    private int animTranslateX;
    private int animTranslateY;
    private int animSpeed;
    private int xSize;
    private int ySize;
    private Point parentRelPos;
    private Point parentInsetRelPos;
    private Insets insets = new Insets(0, 0, 0, 0);
    private boolean enabled = true;
    private boolean elementInitialized = false;
    private Rectangle insetRectangle = new Rectangle();
    private List<String> groups = new ArrayList<String>();
    private GuiElement parentElement = null;
    private Supplier<Boolean> enabledCallback = null;
    private Rectangle rectangle = new Rectangle();
    protected int hoverTime = 0;
    protected int hoverTextDelay = 10;
    protected IDrawCallback preDrawCallback = null;
    protected IDrawCallback postDrawCallback = null;
    protected String elementTranslationExt = "";
    protected String id = "";
    protected boolean boundless = false;
    protected boolean drawHoverText = false;
    protected boolean capturesClicks = false;
    protected boolean frameAnimation = false;
    protected boolean disableOnRemove = false;
    protected boolean resetHoverOnClick = false;
    protected boolean animatedTranslating = false;
    protected List<GuiElement> toRemove = new ArrayList<GuiElement>();
    protected List<GuiElement> boundSizeElements = new ArrayList<GuiElement>();
    protected List<GuiElement> boundInsetSizeElements = new ArrayList<GuiElement>();
    protected LinkedList<GuiElement> childElements = new LinkedList();
    public int screenWidth;
    public int screenHeight;
    public int displayZLevel = 0;
    public double zOffset = 0.0;
    @Deprecated
    public Object linkedObject = null;
    public boolean reportXSizeChange = false;
    public boolean reportYSizeChange = false;
    public boolean consumeHoverOverlay = false;
    public Minecraft mc = Minecraft.func_71410_x();
    public IModularGui modularGui;
    public BCFontRenderer fontRenderer;
    protected Consumer<E> onReload;
    protected Consumer<E> onInit;
    protected HoverTextSupplier<E> hoverText;
    protected BiFunction<E, Integer, Integer> xPosModifier;
    protected BiFunction<E, Integer, Integer> yPosModifier;
    protected BiFunction<E, Integer, Integer> xSizeModifier;
    protected BiFunction<E, Integer, Integer> ySizeModifier;
    protected BiConsumer<Integer, Integer> posChangeListener;
    private Runnable onSizeChanged;
    private Vector3 colourRatio;

    public GuiElement() {
        this.fontRenderer = BCFontRenderer.convert(this.mc.field_71466_p);
        this.onReload = null;
        this.onInit = null;
        this.hoverText = null;
        this.xPosModifier = null;
        this.yPosModifier = null;
        this.xSizeModifier = null;
        this.ySizeModifier = null;
        this.posChangeListener = null;
        this.colourRatio = new Vector3();
    }

    public GuiElement(int xPos, int yPos) {
        this.fontRenderer = BCFontRenderer.convert(this.mc.field_71466_p);
        this.onReload = null;
        this.onInit = null;
        this.hoverText = null;
        this.xPosModifier = null;
        this.yPosModifier = null;
        this.xSizeModifier = null;
        this.ySizeModifier = null;
        this.posChangeListener = null;
        this.colourRatio = new Vector3();
        this.setPos(xPos, yPos);
    }

    public GuiElement(int xPos, int yPos, int xSize, int ySize) {
        this(xPos, yPos);
        this.setSize(xSize, ySize);
    }

    protected String i18ni(String translationKey) {
        if (translationKey.startsWith(".")) {
            translationKey = translationKey.substring(1);
        }
        if (!this.elementTranslationExt.isEmpty()) {
            translationKey = this.elementTranslationExt + "." + translationKey;
        }
        return I18n.func_135052_a((String)(INTERNAL_TRANSLATION_PREFIX + translationKey), (Object[])new Object[0]);
    }

    public void addChildElements() {
        if (this.elementInitialized) {
            throw new RuntimeException("MGuiElementBase.addChildElements was fired but child elements have already been added!");
        }
        if (this.onInit != null) {
            this.onInit.accept(this);
        }
    }

    public void reloadElement() {
        if (this.onReload != null) {
            this.onReload.accept(this);
        }
        for (GuiElement element : this.childElements) {
            element.reloadElement();
        }
    }

    @Deprecated
    public E addReloadCallback(Consumer<E> callBack) {
        this.onReload = this.onReload != null ? this.onReload.andThen(callBack) : callBack;
        return (E)this;
    }

    @Deprecated
    public E addAndFireReloadCallback(Consumer<E> callBack) {
        this.onReload = this.onReload != null ? this.onReload.andThen(callBack) : callBack;
        this.onReload.accept(this);
        return (E)this;
    }

    public E onReload(Consumer<E> callBack) {
        return this.onReload(callBack, true);
    }

    public E onReload(Runnable callBack) {
        return (E)this.onReload(e -> callBack.run(), true);
    }

    public E onReload(Consumer<E> callBack, boolean callNow) {
        Consumer<E> consumer = this.onReload = this.onReload != null ? this.onReload.andThen(callBack) : callBack;
        if (callNow) {
            this.onReload.accept(this);
        }
        return (E)this;
    }

    public E addInitCallback(Consumer<E> callBack) {
        this.onInit = this.onInit != null ? this.onInit.andThen(callBack) : callBack;
        return (E)this;
    }

    @Override
    public <C extends GuiElement> C addChild(C child) {
        if (child == this) {
            throw new InvalidParameterException("Attempted to add element to itself as a child element.");
        }
        this.toRemove.remove(child);
        if (this.childElements.contains(child)) {
            return child;
        }
        this.childElements.add(child);
        this.onChildAdded(child);
        return child;
    }

    @Override
    public <C extends GuiElement> boolean hasChild(C child) {
        return this.childElements.contains(child);
    }

    @Override
    public <C extends GuiElement> C addBackGroundChild(C child) {
        if (this.childElements.contains(child)) {
            return child;
        }
        this.childElements.addFirst(child);
        this.onChildAdded(child);
        return child;
    }

    @Override
    public E addChildren(Collection<? extends GuiElement> elements) {
        this.childElements.addAll(elements);
        for (GuiElement guiElement : elements) {
            this.onChildAdded(guiElement);
        }
        return (E)this;
    }

    protected void onChildAdded(GuiElement childElement) {
        childElement.applyGeneralElementData(this.modularGui, this.mc, this.screenWidth, this.screenHeight, this.fontRenderer);
        childElement.setParent(this);
        if (!childElement.elementInitialized) {
            childElement.addChildElements();
            childElement.elementInitialized = true;
        }
        childElement.reloadElement();
        this.addDefaultListener(childElement);
    }

    protected void addDefaultListener(GuiElement childElement) {
        if (childElement instanceof IGuiEventDispatcher && ((IGuiEventDispatcher)((Object)childElement)).getListener() == null) {
            if (this instanceof IGuiEventListener) {
                ((IGuiEventDispatcher)((Object)childElement)).setListener((IGuiEventListener)((Object)this));
            } else if (this.modularGui instanceof IGuiEventListener) {
                ((IGuiEventDispatcher)((Object)childElement)).setListener((IGuiEventListener)((Object)this.modularGui));
            }
        }
    }

    public void bringToForeground(GuiElement childElement) {
        if (this.childElements.contains(childElement)) {
            this.childElements.remove(childElement);
            this.childElements.add(childElement);
        }
    }

    public void sendToBackground(GuiElement childElement) {
        if (this.childElements.contains(childElement)) {
            this.childElements.remove(childElement);
            this.childElements.addFirst(childElement);
        }
    }

    @Override
    public <C extends GuiElement> C removeChild(C child) {
        if (child != null && this.childElements.contains(child)) {
            this.toRemove.add(child);
            if (this.disableOnRemove) {
                child.setEnabled(false);
            }
            return child;
        }
        return null;
    }

    @Override
    public E removeChildByID(String id) {
        for (GuiElement element : this.childElements) {
            if (element.id == null || !element.id.equals(id)) continue;
            this.toRemove.add(element);
        }
        return (E)this;
    }

    @Override
    public E removeChildByGroup(String group) {
        for (GuiElement element : this.childElements) {
            if (!element.isInGroup(group)) continue;
            this.toRemove.add(element);
        }
        return (E)this;
    }

    @Override
    public E setChildIDEnabled(String id, boolean enabled) {
        for (GuiElement element : this.childElements) {
            if (element.id == null || !element.id.equals(id)) continue;
            element.enabled = enabled;
            return (E)this;
        }
        return (E)this;
    }

    @Override
    public E setChildGroupEnabled(String group, boolean enabled) {
        for (GuiElement element : this.childElements) {
            if (!element.isInGroup(group)) continue;
            element.enabled = enabled;
        }
        return (E)this;
    }

    public E setParent(GuiElement parent) {
        this.parentElement = parent;
        if (this.parentRelPos != null) {
            this.setRelPos(this.parentRelPos.x, this.parentRelPos.y);
            this.parentRelPos = null;
        }
        if (this.parentInsetRelPos != null) {
            this.setInsetRelPos(this.parentInsetRelPos.x, this.parentInsetRelPos.y);
            this.parentInsetRelPos = null;
        }
        return (E)this;
    }

    @Nullable
    public GuiElement getParent() {
        return this.parentElement;
    }

    public void ifParent(Consumer<GuiElement> action) {
        if (this.parentElement != null) {
            action.accept(this.parentElement);
        }
    }

    public List<GuiElement> getChildElements() {
        return Collections.unmodifiableList(this.childElements);
    }

    public E addToGroup(String group) {
        this.groups.add(group);
        return (E)this;
    }

    public E removeFromGroup(String group) {
        if (this.groups.contains(group)) {
            this.groups.remove(group);
        }
        return (E)this;
    }

    public E removeFromAllGroups() {
        this.groups.clear();
        return (E)this;
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<GuiElement> getChildGroup(String group) {
        ArrayList<GuiElement> list = new ArrayList<GuiElement>();
        DataUtils.forEachMatch(this.childElements, elementBase -> elementBase.isInGroup(group), list::add);
        return list;
    }

    public E setId(@Nonnull String id) {
        this.id = id;
        return (E)this;
    }

    public String getId() {
        return this.id;
    }

    public GuiElement findChildById(String id) {
        return DataUtils.firstMatch(this.childElements, elementBase -> elementBase.getId().equals(id));
    }

    public <C extends GuiElement> C findChildById(String id, Class<C> clazz) {
        GuiElement element = DataUtils.firstMatch(this.childElements, elementBase -> elementBase.getId().equals(id) && clazz.isAssignableFrom(elementBase.getClass()));
        return (C)(element == null ? null : (GuiElement)clazz.cast(element));
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return GuiHelperOld.isInRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), mouseX, mouseY) && this.allowMouseOver(this, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (GuiElement element : Lists.reverse(this.childElements)) {
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (mouseOver && this.resetHoverOnClick) {
            this.hoverTime = 0;
        }
        return mouseOver && this.capturesClicks;
    }

    public void globalClick(double mouseX, double mouseY, int button) {
        for (GuiElement element : Lists.reverse(this.childElements)) {
            if (!element.isEnabled()) continue;
            element.globalClick(mouseX, mouseY, button);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (GuiElement element : Lists.reverse(this.childElements)) {
            if (!element.isEnabled() || !element.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        for (GuiElement element : Lists.reverse(this.childElements)) {
            if (!element.isEnabled() || !element.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseMoved(double mouseX, double mouseY) {
        for (GuiElement element : Lists.reverse(this.childElements)) {
            if (!element.isEnabled() || !element.mouseMoved(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean handleMouseScroll(double mouseX, double mouseY, double scrollDirection) {
        for (GuiElement element : this.childElements) {
            if (!element.isEnabled() || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
            return true;
        }
        return false;
    }

    public boolean allowMouseOver(GuiElement elementRequesting, double mouseX, double mouseY) {
        return this.getParent() == null || this.getParent().allowMouseOver(this, mouseX, mouseY);
    }

    public E setCapturesClicks(boolean capturesClicks) {
        this.capturesClicks = capturesClicks;
        return (E)this;
    }

    protected boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiElement element : this.childElements) {
            if (!element.isEnabled() || !element.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    protected boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (GuiElement element : this.childElements) {
            if (!element.isEnabled() || !element.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char charTyped, int charCode) {
        for (GuiElement element : this.childElements) {
            if (!element.isEnabled() || !element.charTyped(charTyped, charCode)) continue;
            return true;
        }
        return false;
    }

    public boolean onUpdate() {
        int mouseY;
        if (this.frameAnimation && this.animFrameX == 0 && this.animFrameY == 0) {
            this.frameAnimation = false;
        }
        this.lastTickXPos = this.xPos;
        this.lastTickYPos = this.yPos;
        if (this.frameAnimation) {
            this.frameAnimation = false;
            this.translate(this.animFrameX, this.animFrameY);
            this.animFrameY = 0;
            this.animFrameX = 0;
            this.frameAnimation = true;
        }
        if (!this.toRemove.isEmpty()) {
            this.childElements.removeAll(this.toRemove);
            this.toRemove.clear();
            return true;
        }
        int mouseX = (int)this.getMouseX();
        this.hoverTime = this.isMouseOver(mouseX, mouseY = (int)this.getMouseY()) ? ++this.hoverTime : 0;
        if (this.animatedTranslating) {
            int x = net.minecraft.util.math.MathHelper.func_76125_a((int)this.animTranslateX, (int)(-this.animSpeed), (int)this.animSpeed);
            int y = net.minecraft.util.math.MathHelper.func_76125_a((int)this.animTranslateY, (int)(-this.animSpeed), (int)this.animSpeed);
            this.animTranslateX -= x;
            this.animTranslateY -= y;
            this.animateMoveFrames();
            this.translate(x, y);
            if (this.animTranslateX == 0 && this.animTranslateY == 0) {
                this.animatedTranslating = false;
            }
        }
        for (GuiElement element : this.childElements) {
            if (!element.onUpdate()) continue;
            return true;
        }
        return false;
    }

    public final void preDraw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.preDrawCallback != null) {
            this.preDrawCallback.call(minecraft, mouseX, mouseY, partialTicks, this.isMouseOver(mouseX, mouseY));
        }
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.frameAnimation) {
            RenderSystem.pushMatrix();
            double x = ((double)this.lastTickXPos - (double)this.xPos) * (double)partialTicks;
            double y = ((double)this.lastTickYPos - (double)this.yPos) * (double)partialTicks;
            RenderSystem.translated((double)x, (double)y, (double)0.0);
        }
        for (GuiElement element : this.childElements) {
            if (!element.isEnabled()) continue;
            element.preDraw(minecraft, mouseX, mouseY, partialTicks);
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
            element.postDraw(minecraft, mouseX, mouseY, partialTicks);
        }
        if (this.frameAnimation) {
            RenderSystem.popMatrix();
        }
    }

    public final void postDraw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.postDrawCallback != null) {
            this.postDrawCallback.call(minecraft, mouseX, mouseY, partialTicks, this.isMouseOver(mouseX, mouseY));
        }
    }

    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        List<String> hoverText;
        for (GuiElement element : this.childElements) {
            if (!element.isEnabled() || !element.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks)) continue;
            return true;
        }
        if (this.isHoverTextEnabled() && this.isMouseOver(mouseX, mouseY) && this.hoverTime >= this.hoverTextDelay && !(hoverText = this.getHoverText()).isEmpty()) {
            this.drawHoveringText(hoverText, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
            return true;
        }
        return this.isMouseOver(mouseX, mouseY) && this.consumeHoverOverlay;
    }

    public int xPos() {
        return this.xPosModifier != null ? this.xPosModifier.apply(this, this.xPos) : this.xPos;
    }

    public int maxXPos() {
        return this.xPos() + this.xSize();
    }

    public int yPos() {
        return this.yPosModifier != null ? this.yPosModifier.apply(this, this.yPos) : this.yPos;
    }

    public int maxYPos() {
        return this.yPos() + this.ySize();
    }

    public E translate(int xAmount, int yAmount) {
        if (this.frameAnimation) {
            this.animFrameX += xAmount;
            this.animFrameY += yAmount;
            return (E)this;
        }
        this.xPos += xAmount;
        this.yPos += yAmount;
        for (GuiElement element : this.childElements) {
            element.translate(xAmount, yAmount);
        }
        if (this.posChangeListener != null) {
            this.posChangeListener.accept(this.xPos(), this.yPos());
        }
        return (E)this;
    }

    public E translateAnim(int xAmount, int yAmount, int speed) {
        this.animTranslateX += xAmount;
        this.animTranslateY += yAmount;
        this.animSpeed = speed;
        this.animatedTranslating = true;
        return (E)this;
    }

    @Deprecated
    public E animateMoveFrames() {
        this.frameAnimation = true;
        return (E)this;
    }

    public E setXPos(int x) {
        this.translate(x - this.xPos(), 0);
        return (E)this;
    }

    public E setXPos(int x, boolean reshape) {
        int maxX = this.maxXPos();
        this.translate(x - this.xPos(), 0);
        if (reshape) {
            this.setMaxXPos(maxX, true);
        }
        return (E)this;
    }

    public E setYPos(int y) {
        this.translate(0, y - this.yPos());
        return (E)this;
    }

    public E setYPos(int y, boolean reshape) {
        int maxY = this.maxYPos();
        this.translate(0, y - this.yPos());
        if (reshape) {
            this.setMaxYPos(maxY, true);
        }
        return (E)this;
    }

    public E setPos(int x, int y) {
        this.translate(x - this.xPos(), y - this.yPos());
        return (E)this;
    }

    public E setPos(int x, int y, boolean reshape) {
        int maxX = this.maxXPos();
        int maxY = this.maxYPos();
        this.translate(x - this.xPos(), y - this.yPos());
        if (reshape) {
            this.setMaxXPos(maxX, true);
            this.setMaxYPos(maxY, true);
        }
        return (E)this;
    }

    public E setPos(GuiElement element) {
        this.setPos(element.xPos(), element.yPos());
        return (E)this;
    }

    public E setMaxXPos(int x, boolean resize) {
        if (resize) {
            return this.setXSize(x - this.xPos());
        }
        return this.setXPos(x - this.xSize());
    }

    public E setMaxYPos(int y, boolean resize) {
        if (resize) {
            return this.setYSize(y - this.yPos());
        }
        return this.setYPos(y - this.ySize());
    }

    public E setMaxPos(int x, int y, boolean resize) {
        this.setMaxXPos(x, resize);
        this.setMaxYPos(y, resize);
        return (E)this;
    }

    public E setRawPos(int x, int y) {
        this.xPos = x;
        this.yPos = y;
        return (E)this;
    }

    public E setPosModifiers(BiFunction<E, Integer, Integer> xMod, BiFunction<E, Integer, Integer> yMod) {
        this.xPosModifier = xMod;
        this.yPosModifier = yMod;
        return (E)this;
    }

    public E setPosModifiers(Supplier<Integer> xMod, Supplier<Integer> yMod) {
        this.xPosModifier = (e, e2) -> (Integer)xMod.get();
        this.yPosModifier = (e, e2) -> (Integer)yMod.get();
        return (E)this;
    }

    public E setXPosMod(BiFunction<E, Integer, Integer> xMod) {
        this.xPosModifier = xMod;
        return (E)this;
    }

    public E setYPosMod(BiFunction<E, Integer, Integer> yMod) {
        this.yPosModifier = yMod;
        return (E)this;
    }

    public E setXPosMod(Supplier<Integer> xMod) {
        return (E)this.setXPosMod((E e, Integer integer) -> (Integer)xMod.get());
    }

    public E setYPosMod(Supplier<Integer> yMod) {
        return (E)this.setYPosMod((E e, Integer integer) -> (Integer)yMod.get());
    }

    public E setRelPos(int xOffset, int yOffset) {
        if (this.getParent() == null) {
            this.parentRelPos = new Point(xOffset, yOffset);
        } else {
            this.setPos(this.getParent().xPos() + xOffset, this.getParent().yPos() + yOffset);
        }
        return (E)this;
    }

    public E setRelPos(@Nonnull GuiElement relativeTo, int xOffset, int yOffset) {
        this.setPos(relativeTo.xPos() + xOffset, relativeTo.yPos() + yOffset);
        return (E)this;
    }

    public E setRelPosRight(@Nonnull GuiElement relativeTo, int xOffset, int yOffset) {
        this.setPos(relativeTo.maxXPos() + xOffset, relativeTo.yPos() + yOffset);
        return (E)this;
    }

    public E setRelPosBottom(@Nonnull GuiElement relativeTo, int xOffset, int yOffset) {
        this.setPos(relativeTo.xPos() + xOffset, relativeTo.maxYPos() + yOffset);
        return (E)this;
    }

    public E setRelPosBottomRight(@Nonnull GuiElement relativeTo, int xOffset, int yOffset) {
        this.setPos(relativeTo.maxXPos() + xOffset, relativeTo.maxYPos() + yOffset);
        return (E)this;
    }

    public E setInsetRelPos(int xOffset, int yOffset) {
        if (this.getParent() == null) {
            this.parentInsetRelPos = new Point(xOffset, yOffset);
        } else {
            this.setPos(this.getParent().getInsetRect().x + xOffset, this.getParent().getInsetRect().y + yOffset);
        }
        return (E)this;
    }

    public E normalizePosition() {
        if (this.xPos() < 0) {
            this.setXPos(0);
        }
        if (this.yPos() < 0) {
            this.setYPos(0);
        }
        if (this.maxXPos() > this.screenWidth) {
            this.setXPos(this.screenWidth - this.xSize());
        }
        if (this.maxYPos() > this.screenHeight) {
            this.setYPos(this.screenHeight - this.ySize());
        }
        return (E)this;
    }

    public E addPosChangeListener(BiConsumer<Integer, Integer> posChangeListener) {
        this.posChangeListener = this.posChangeListener == null ? posChangeListener : this.posChangeListener.andThen(posChangeListener);
        return (E)this;
    }

    public int xSize() {
        return this.xSizeModifier != null ? this.xSizeModifier.apply(this, this.xSize) : this.xSize;
    }

    public int ySize() {
        return this.ySizeModifier != null ? this.ySizeModifier.apply(this, this.ySize) : this.ySize;
    }

    public E setXSize(int xSize) {
        if (this.animatedTranslating) {
            this.animatedTranslating = false;
            this.translate(this.animTranslateX, this.animTranslateY);
            this.animTranslateX = 0;
            this.animTranslateY = 0;
        }
        this.xSize = xSize;
        this.boundSizeElements.forEach(elementBase -> elementBase.setXSize(this.xSize()));
        this.boundInsetSizeElements.forEach(elementBase -> elementBase.setXSize(this.getInsetRect().width));
        this.xSizeChanged(this);
        return (E)this;
    }

    public E setYSize(int ySize) {
        if (this.animatedTranslating) {
            this.animatedTranslating = false;
            this.translate(this.animTranslateX, this.animTranslateY);
            this.animTranslateX = 0;
            this.animTranslateY = 0;
        }
        this.ySize = ySize;
        this.boundSizeElements.forEach(elementBase -> elementBase.setYSize(this.ySize()));
        this.boundInsetSizeElements.forEach(elementBase -> elementBase.setYSize(this.getInsetRect().height));
        this.ySizeChanged(this);
        return (E)this;
    }

    public E setSize(int xSize, int ySize) {
        this.setXSize(xSize);
        this.setYSize(ySize);
        return (E)this;
    }

    public E setSize(GuiElement element) {
        this.setSize(element.xSize(), element.ySize());
        return (E)this;
    }

    public E setSize(Rectangle rect) {
        this.setSize(rect.width, rect.height);
        return (E)this;
    }

    public E setSize(Dimension rect) {
        this.setSize(rect.width, rect.height);
        return (E)this;
    }

    public E addToXSize(int x) {
        this.setXSize(this.xSize() + x);
        return (E)this;
    }

    public E addToYSize(int y) {
        this.setYSize(this.ySize() + y);
        return (E)this;
    }

    public E addToSize(int x, int y) {
        this.addToXSize(x);
        this.addToYSize(y);
        return (E)this;
    }

    public E bindSize(GuiElement element, boolean insetSize) {
        if (insetSize) {
            element.boundInsetSizeElements.add(this);
        } else {
            element.boundSizeElements.add(this);
        }
        return (E)this;
    }

    public E imposeSize(GuiElement element, boolean insetSize) {
        if (insetSize) {
            this.boundInsetSizeElements.add(element);
        } else {
            this.boundSizeElements.add(element);
        }
        return (E)this;
    }

    public E setSizeModifiers(BiFunction<E, Integer, Integer> xMod, BiFunction<E, Integer, Integer> yMod) {
        this.xSizeModifier = xMod;
        this.ySizeModifier = yMod;
        return (E)this;
    }

    public E setSizeModifiers(Supplier<Integer> xMod, Supplier<Integer> yMod) {
        this.xSizeModifier = (e, e2) -> (Integer)xMod.get();
        this.ySizeModifier = (e, e2) -> (Integer)yMod.get();
        return (E)this;
    }

    public E setXSizeMod(BiFunction<E, Integer, Integer> xMod) {
        this.xSizeModifier = xMod;
        return (E)this;
    }

    public E setYSizeMod(BiFunction<E, Integer, Integer> yMod) {
        this.ySizeModifier = yMod;
        return (E)this;
    }

    public E setXSizeMod(Supplier<Integer> xMod) {
        return (E)this.setXSizeMod((E e, Integer integer) -> (Integer)xMod.get());
    }

    public E setYSizeMod(Supplier<Integer> yMod) {
        return (E)this.setYSizeMod((E e, Integer integer) -> (Integer)yMod.get());
    }

    public void xSizeChanged(GuiElement elementChanged) {
        if (this.onSizeChanged != null) {
            this.onSizeChanged.run();
        }
        if (this.getParent() != null) {
            this.getParent().xSizeChanged(this);
        }
    }

    public void ySizeChanged(GuiElement elementChanged) {
        if (this.onSizeChanged != null) {
            this.onSizeChanged.run();
        }
        if (this.getParent() != null) {
            this.getParent().ySizeChanged(this);
        }
    }

    public Runnable addSizeListener(Runnable newListener) {
        this.onSizeChanged = this.onSizeChanged != null ? SneakyUtils.concat((Runnable)this.onSizeChanged, (Runnable)newListener) : newListener;
        return this.onSizeChanged;
    }

    public E setPosAndSize(GuiElement element) {
        this.setPos(element);
        this.setSize(element);
        return (E)this;
    }

    public E setPosAndSize(Rectangle rect) {
        this.setPos(rect.x, rect.y);
        this.setSize(rect.width, rect.height);
        return (E)this;
    }

    public E setPosAndSize(int xPos, int yPos, int xSize, int ySize) {
        this.setPos(xPos, yPos);
        this.setSize(xSize, ySize);
        return (E)this;
    }

    public Rectangle getRect() {
        this.rectangle.setBounds(this.xPos(), this.yPos(), this.xSize(), this.ySize());
        return this.rectangle;
    }

    public Rectangle getEnclosingRect() {
        return this.addBoundsToRect(this.getRect().getBounds());
    }

    public Rectangle addBoundsToRect(Rectangle enclosingRect) {
        if (!this.boundless) {
            int enRectMaxX = (int)enclosingRect.getMaxX();
            int enRectMaxY = (int)enclosingRect.getMaxY();
            if (this.getRect().x < enclosingRect.x) {
                enclosingRect.x = this.getRect().x;
                enclosingRect.width = enRectMaxX - enclosingRect.x;
            }
            if (this.getRect().getMaxX() > (double)enRectMaxX) {
                enclosingRect.width = (int)this.getRect().getMaxX() - enclosingRect.x;
            }
            if (this.getRect().y < enclosingRect.y) {
                enclosingRect.y = this.getRect().y;
                enclosingRect.height = enRectMaxY - enclosingRect.y;
            }
            if (this.getRect().getMaxY() > (double)enRectMaxY) {
                enclosingRect.height = (int)this.getRect().getMaxY() - enclosingRect.y;
            }
        }
        for (GuiElement element : this.childElements) {
            if (this.toRemove.contains(element) || !element.isEnabled()) continue;
            element.addBoundsToRect(enclosingRect);
        }
        return enclosingRect;
    }

    public E setInsets(Insets insets) {
        this.insets = insets;
        return (E)this;
    }

    public E setInsets(int top, int left, int bottom, int right) {
        this.insets.set(top, left, bottom, right);
        return (E)this;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Rectangle getInsetRect() {
        this.insetRectangle.setBounds(this.getRect());
        this.insetRectangle.setLocation(this.xPos() + this.getInsets().left, this.yPos() + this.getInsets().top);
        this.insetRectangle.setSize(this.xSize() - (this.getInsets().left + this.getInsets().right), this.ySize() - (this.getInsets().top + this.getInsets().bottom));
        return this.insetRectangle;
    }

    public Screen getScreen() {
        return this.modularGui.getScreen();
    }

    public void bindTexture(ResourceLocation texture) {
        if (this.mc != null) {
            this.mc.func_110434_K().func_110577_a(texture);
        }
    }

    public void applyGeneralElementData(IModularGui modularGui, Minecraft mc, int width, int height, BCFontRenderer fontRenderer) {
        this.mc = mc;
        this.fontRenderer = fontRenderer;
        this.screenWidth = width;
        this.screenHeight = height;
        this.modularGui = modularGui;
        for (GuiElement element : this.childElements) {
            element.applyGeneralElementData(modularGui, mc, width, height, fontRenderer);
        }
    }

    public void initializeElementData(GuiElement initializer) {
        this.mc = initializer.mc;
        if (this.mc == null) {
            this.mc = Minecraft.func_71410_x();
        }
        this.fontRenderer = initializer.fontRenderer;
        this.screenWidth = initializer.screenWidth;
        this.screenHeight = initializer.screenHeight;
        this.modularGui = initializer.modularGui;
        for (GuiElement element : this.childElements) {
            element.applyGeneralElementData(this.modularGui, this.mc, this.screenWidth, this.screenHeight, this.fontRenderer);
        }
    }

    public E setLinkedObject(Object linkedObject) {
        this.linkedObject = linkedObject;
        return (E)this;
    }

    public E setEnabled(boolean enabled) {
        this.enabled = enabled;
        return (E)this;
    }

    public E setEnabledCallback(Supplier<Boolean> enabledCallback) {
        this.enabledCallback = enabledCallback;
        return (E)this;
    }

    public boolean isEnabled() {
        return this.enabledCallback == null ? this.enabled : this.enabledCallback.get();
    }

    public boolean isElementInitialized() {
        return this.elementInitialized;
    }

    public void setElementInitialized() {
        this.elementInitialized = true;
    }

    public int distFromElement(double x, double y) {
        if (x >= (double)this.xPos() && x <= (double)(this.xPos() + this.xSize()) && y >= (double)this.yPos() && y <= (double)(this.yPos() + this.ySize())) {
            return 0;
        }
        double xDist = x < (double)this.xPos() ? (double)this.xPos() - x : x - (double)(this.xPos() + this.xSize());
        double yDist = y < (double)this.yPos() ? (double)this.yPos() - y : y - (double)(this.yPos() + this.ySize());
        return (int)Math.max(xDist, yDist);
    }

    public List<GuiElement> getElementsAtPosition(double posX, double posY, List<GuiElement> list) {
        if (this.isMouseOver(posX, posY)) {
            list.add(this);
        }
        for (GuiElement element : this.childElements) {
            element.getElementsAtPosition(posX, posY, list);
        }
        return list;
    }

    public <C extends GuiElement> List<C> findChildElementsByClass(Class<C> clazz, List<C> list) {
        if (clazz.isAssignableFrom(this.getClass())) {
            list.add(clazz.cast(this));
        }
        for (GuiElement element : this.childElements) {
            element.findChildElementsByClass(clazz, list);
        }
        return list;
    }

    public E setPreDrawCallback(IDrawCallback preDrawCallback) {
        this.preDrawCallback = preDrawCallback;
        return (E)this;
    }

    public E setPostDrawCallback(IDrawCallback postDrawCallback) {
        this.postDrawCallback = postDrawCallback;
        return (E)this;
    }

    public String toString() {
        return String.format("%s:[x=%s,y=%s,w=%s,h=%s|ix=%s,iy=%s,iw=%s,ih=%s|children:%s]", this.getClass().getSimpleName(), this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.getInsetRect().x, this.getInsetRect().y, this.getInsetRect().width, this.getInsetRect().height, this.childElements.size());
    }

    public E modifyZOffset(double zOffset) {
        this.zOffset += zOffset;
        this.childElements.forEach(e -> e.modifyZOffset(zOffset));
        return (E)this;
    }

    public double getZOffset() {
        return this.zOffset;
    }

    public int displayWidth() {
        return this.mc.func_228018_at_().func_198105_m();
    }

    public int displayHeight() {
        return this.mc.func_228018_at_().func_198083_n();
    }

    public double getMouseX() {
        return this.mc.field_71417_B.func_198024_e() * (double)this.mc.func_228018_at_().func_198107_o() / (double)this.mc.func_228018_at_().func_198105_m();
    }

    public double getMouseY() {
        return this.mc.field_71417_B.func_198026_f() * (double)this.mc.func_228018_at_().func_198087_p() / (double)this.mc.func_228018_at_().func_198083_n();
    }

    @Deprecated
    public List<String> getTooltipFromItemString(ItemStack stack) {
        List list = stack.func_82840_a((PlayerEntity)this.mc.field_71439_g, (ITooltipFlag)(this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList list1 = Lists.newArrayList();
        for (ITextComponent itextcomponent : list) {
            list1.add(itextcomponent.getString());
        }
        return list1;
    }

    public List<ITextComponent> getTooltipFromItem(ItemStack stack) {
        return stack.func_82840_a((PlayerEntity)this.mc.field_71439_g, (ITooltipFlag)(this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
    }

    public float getRenderZLevel() {
        return (float)((double)this.modularGui.getZLevel() + this.zOffset);
    }

    @Deprecated
    public void drawRect(double left, double top, double right, double bottom, int color) {
        double zLevel = this.getRenderZLevel();
        if (left < right) {
            double i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            double j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)f3);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_(left, bottom, zLevel).func_181675_d();
        buffer.func_225582_a_(right, bottom, zLevel).func_181675_d();
        buffer.func_225582_a_(right, top, zLevel).func_181675_d();
        buffer.func_225582_a_(left, top, zLevel).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    @Deprecated
    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        double zLevel = this.getRenderZLevel();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), zLevel).func_225583_a_((float)textureX * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, zLevel).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)textureY * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, zLevel).func_225583_a_((float)textureX * 0.00390625f, (float)textureY * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    @Deprecated
    public void drawTexturedModalRect(double xCoord, double yCoord, int minU, int minV, int maxU, int maxV) {
        double zLevel = this.getRenderZLevel();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(xCoord + 0.0, yCoord + (double)maxV, zLevel).func_225583_a_((float)minU * 0.00390625f, (float)(minV + maxV) * 0.00390625f).func_181675_d();
        buffer.func_225582_a_(xCoord + (double)maxU, yCoord + (double)maxV, zLevel).func_225583_a_((float)(minU + maxU) * 0.00390625f, (float)(minV + maxV) * 0.00390625f).func_181675_d();
        buffer.func_225582_a_(xCoord + (double)maxU, yCoord + 0.0, zLevel).func_225583_a_((float)(minU + maxU) * 0.00390625f, (float)minV * 0.00390625f).func_181675_d();
        buffer.func_225582_a_(xCoord + 0.0, yCoord + 0.0, zLevel).func_225583_a_((float)minU * 0.00390625f, (float)minV * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    @Deprecated
    public void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = this.getRenderZLevel();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)xCoord, (double)(yCoord + heightIn), zLevel).func_225583_a_(textureSprite.func_94209_e(), textureSprite.func_94210_h()).func_181675_d();
        buffer.func_225582_a_((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_225583_a_(textureSprite.func_94212_f(), textureSprite.func_94210_h()).func_181675_d();
        buffer.func_225582_a_((double)(xCoord + widthIn), (double)yCoord, zLevel).func_225583_a_(textureSprite.func_94212_f(), textureSprite.func_94206_g()).func_181675_d();
        buffer.func_225582_a_((double)xCoord, (double)yCoord, zLevel).func_225583_a_(textureSprite.func_94209_e(), textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    @Deprecated
    public void drawModalRectWithCustomSizedTexture(float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        float zLevel = this.getRenderZLevel();
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_(u * f, (v + height) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((u + width) * f, (v + height) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_((u + width) * f, v * f1).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    @Deprecated
    public void drawScaledCustomSizeModalRect(float xPos, float yPos, float u, float v, float uWidth, float vHeight, float width, float height, float textureSheetWidth, float testureSheetHeight) {
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        float zLevel = this.getRenderZLevel();
        float f = 1.0f / textureSheetWidth;
        float f1 = 1.0f / testureSheetHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)xPos, (double)(yPos + height), (double)zLevel).func_225583_a_(u * f, (v + vHeight) * f1).func_181675_d();
        buffer.func_225582_a_((double)(xPos + width), (double)(yPos + height), (double)zLevel).func_225583_a_((u + uWidth) * f, (v + vHeight) * f1).func_181675_d();
        buffer.func_225582_a_((double)(xPos + width), (double)yPos, (double)zLevel).func_225583_a_((u + uWidth) * f, v * f1).func_181675_d();
        buffer.func_225582_a_((double)xPos, (double)yPos, (double)zLevel).func_225583_a_(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    @Deprecated
    public void drawGradientRect(double left, double top, double right, double bottom, int startColor, int endColor) {
        if (startColor == endColor && endColor == 0) {
            return;
        }
        double zLevel = this.getRenderZLevel();
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(right, top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_225582_a_(left, top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_225582_a_(left, bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_225582_a_(right, bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    @Deprecated
    public void drawMultiPassGradientRect(double left, double top, double right, double bottom, int colour1, int colour2, int layers) {
        if (colour1 == colour2 && colour2 == 0) {
            return;
        }
        double zLevel = this.getRenderZLevel();
        float alpha1 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(colour1 & 0xFF) / 255.0f;
        float alpha2 = (float)(colour2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(colour2 & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < layers; ++i) {
            buffer.func_225582_a_(right, top, zLevel).func_227885_a_(red1, green1, blue1, alpha1).func_181675_d();
            buffer.func_225582_a_(left, top, zLevel).func_227885_a_(red1, green1, blue1, alpha1).func_181675_d();
            buffer.func_225582_a_(left, bottom, zLevel).func_227885_a_(red2, green2, blue2, alpha2).func_181675_d();
            buffer.func_225582_a_(right, bottom, zLevel).func_227885_a_(red2, green2, blue2, alpha2).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    @Deprecated
    public void drawColouredRect(double posX, double posY, double xSize, double ySize, int colour) {
        this.drawGradientRect(posX, posY, posX + xSize, posY + ySize, colour, colour);
    }

    @Deprecated
    public void drawBorderedRect(double posX, double posY, double xSize, double ySize, double borderWidth, int fillColour, int borderColour) {
        this.drawColouredRect(posX, posY, xSize, borderWidth, borderColour);
        this.drawColouredRect(posX, posY + ySize - borderWidth, xSize, borderWidth, borderColour);
        this.drawColouredRect(posX, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour);
        this.drawColouredRect(posX + xSize - borderWidth, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour);
        this.drawColouredRect(posX + borderWidth, posY + borderWidth, xSize - 2.0 * borderWidth, ySize - 2.0 * borderWidth, fillColour);
    }

    @Deprecated
    public void drawShadedRect(double x, double y, double width, double height, double borderWidth, int fill, int topLeftColour, int bottomRightColour, int cornerMixColour) {
        this.drawColouredRect(x + borderWidth, y + borderWidth, width - borderWidth * 2.0, height - borderWidth * 2.0, fill);
        this.drawColouredRect(x, y, width - borderWidth, borderWidth, topLeftColour);
        this.drawColouredRect(x, y + borderWidth, borderWidth, height - borderWidth * 2.0, topLeftColour);
        this.drawColouredRect(x + borderWidth, y + height - borderWidth, width - borderWidth, borderWidth, bottomRightColour);
        this.drawColouredRect(x + width - borderWidth, y + borderWidth, borderWidth, height - borderWidth * 2.0, bottomRightColour);
        this.drawColouredRect(x + width - borderWidth, y, borderWidth, borderWidth, cornerMixColour);
        this.drawColouredRect(x, y + height - borderWidth, borderWidth, borderWidth, cornerMixColour);
    }

    @Deprecated
    public void renderVanillaButtonTexture(int xPos, int yPos, int xSize, int ySize, boolean hovered, boolean disabled) {
        ResourceHelperBC.bindTexture(WIDGETS_TEXTURES);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = 1;
        if (disabled) {
            k = 0;
        } else if (hovered) {
            k = 2;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int texHeight = Math.min(20, ySize);
        int texPos = 46 + k * 20;
        this.drawTexturedModalRect(xPos, yPos, 0, texPos, xSize % 2 + xSize / 2, texHeight);
        this.drawTexturedModalRect(xSize % 2 + xPos + xSize / 2, yPos, 200 - xSize / 2, texPos, xSize / 2, texHeight);
        if (ySize < 20) {
            this.drawTexturedModalRect(xPos, yPos + 3, 0, texPos + 20 - ySize + 3, xSize % 2 + xSize / 2, ySize - 3);
            this.drawTexturedModalRect(xSize % 2 + xPos + xSize / 2, yPos + 3, 200 - xSize / 2, texPos + 20 - ySize + 3, xSize / 2, ySize - 3);
        } else if (ySize > 20) {
            int y = yPos + 17;
            while (y + 15 < yPos + ySize) {
                this.drawTexturedModalRect(xPos, y, 0, texPos + 2, xSize % 2 + xSize / 2, 15);
                this.drawTexturedModalRect(xSize % 2 + xPos + xSize / 2, y, 200 - xSize / 2, texPos + 2, xSize / 2, 15);
                y += 15;
            }
            this.drawTexturedModalRect(xPos, yPos + ySize - 15, 0, texPos + 5, xSize % 2 + xSize / 2, 15);
            this.drawTexturedModalRect(xSize % 2 + xPos + xSize / 2, yPos + ySize - 15, 200 - xSize / 2, texPos + 5, xSize / 2, 15);
        }
    }

    @Deprecated
    public void drawTiledTextureRectWithTrim(int xPos, int yPos, int xSize, int ySize, int topTrim, int leftTrim, int bottomTrim, int rightTrim, int texU, int texV, int texWidth, int texHeight) {
        int trimWidth = texWidth - leftTrim - rightTrim;
        int trimHeight = texHeight - topTrim - bottomTrim;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightTrim);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = x == 0 ? texU : (x + trimWidth <= xSize ? texU + leftTrim : texU + (texWidth - (xSize - x)));
            this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos + x, yPos, trimU, texV, rWidth, topTrim);
            this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos + x, yPos + ySize - bottomTrim, trimU, texV + texHeight - bottomTrim, rWidth, bottomTrim);
            rWidth = Math.min(xSize - x - leftTrim - rightTrim, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int trimV;
                int rHeight = Math.min(ySize - y - topTrim - bottomTrim, trimHeight);
                int n = trimV = y + texHeight <= ySize ? texV + topTrim : texV + (texHeight - (ySize - y));
                if (x == 0) {
                    this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos, yPos + y + topTrim, texU, trimV, leftTrim, rHeight);
                    this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos + xSize - rightTrim, yPos + y + topTrim, trimU + texWidth - rightTrim, trimV, rightTrim, rHeight);
                }
                if (y >= ySize - bottomTrim || x >= xSize - rightTrim) continue;
                this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos + x + leftTrim, yPos + y + topTrim, texU + leftTrim, texV + topTrim, rWidth, rHeight);
            }
        }
        tessellator.func_78381_a();
    }

    public void drawRect(IRenderTypeBuffer getter, double left, double top, double right, double bottom, int color) {
        double zLevel = this.getRenderZLevel();
        if (left < right) {
            double i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            double j = top;
            top = bottom;
            bottom = j;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        IVertexBuilder builder = getter.getBuffer(transColourType);
        builder.func_225582_a_(left, bottom, zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(right, bottom, zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(right, top, zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(left, top, zLevel).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public void drawSprite(IVertexBuilder builder, float x, float y, float width, float height, TextureAtlasSprite sprite) {
        double zLevel = this.getRenderZLevel();
        builder.func_225582_a_((double)x, (double)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
    }

    public void drawSprite(IVertexBuilder builder, float x, float y, float width, float height, TextureAtlasSprite sprite, int colour) {
        double zLevel = this.getRenderZLevel();
        int[] colours = Colour.unpack((int)colour);
        builder.func_225582_a_((double)x, (double)(y + height), zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)y, zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
    }

    public void drawSprite(IVertexBuilder builder, float x, float y, TextureAtlasSprite sprite) {
        this.drawSprite(builder, x, y, sprite, -1);
    }

    public void drawSprite(IVertexBuilder builder, float x, float y, TextureAtlasSprite sprite, int colour) {
        double zLevel = this.getRenderZLevel();
        int[] colours = Colour.unpack((int)colour);
        float width = sprite.func_94211_a();
        float height = sprite.func_94216_b();
        builder.func_225582_a_((double)x, (double)(y + height), zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)y, zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
    }

    public void drawQuarterDynamicSprite(IVertexBuilder buffer, int xPos, int yPos, int xSize, int ySize, TextureAtlasSprite sprite) {
        float texU = sprite.func_94209_e();
        float texV = sprite.func_94206_g();
        int texWidth = sprite.func_94211_a();
        int texHeight = sprite.func_94216_b();
        float uScale = (sprite.func_94212_f() - texU) / (float)texWidth;
        float vScale = (sprite.func_94210_h() - texV) / (float)texHeight;
        this.bufferRect(buffer, xPos, yPos, (float)xSize / 2.0f, (float)ySize / 2.0f, sprite.func_94209_e(), sprite.func_94206_g(), (float)xSize / 2.0f * uScale, (float)ySize / 2.0f * vScale);
        this.bufferRect(buffer, (float)xPos + (float)xSize / 2.0f, yPos, (float)xSize / 2.0f, (float)ySize / 2.0f, sprite.func_94212_f() - (float)xSize / 2.0f * uScale, sprite.func_94206_g(), (float)xSize / 2.0f * uScale, (float)ySize / 2.0f * vScale);
        this.bufferRect(buffer, xPos, (float)yPos + (float)ySize / 2.0f, (float)xSize / 2.0f, (float)ySize / 2.0f, sprite.func_94209_e(), sprite.func_94210_h() - (float)ySize / 2.0f * vScale, (float)xSize / 2.0f * uScale, (float)ySize / 2.0f * vScale);
        this.bufferRect(buffer, (float)xPos + (float)xSize / 2.0f, (float)yPos + (float)ySize / 2.0f, (float)xSize / 2.0f, (float)ySize / 2.0f, sprite.func_94212_f() - (float)xSize / 2.0f * uScale, sprite.func_94210_h() - (float)ySize / 2.0f * vScale, (float)xSize / 2.0f * uScale, (float)ySize / 2.0f * vScale);
    }

    public void drawDynamicSprite(IVertexBuilder builder, TextureAtlasSprite tex, int xPos, int yPos, int xSize, int ySize, int topTrim, int leftTrim, int bottomTrim, int rightTrim) {
        this.drawDynamicSprite(builder, tex, xPos, yPos, xSize, ySize, topTrim, leftTrim, bottomTrim, rightTrim, -1);
    }

    public void drawDynamicSprite(IVertexBuilder builder, TextureAtlasSprite tex, int xPos, int yPos, int xSize, int ySize, int topTrim, int leftTrim, int bottomTrim, int rightTrim, int colour) {
        int texWidth = tex.func_94211_a();
        int texHeight = tex.func_94216_b();
        int trimWidth = texWidth - leftTrim - rightTrim;
        int trimHeight = texHeight - topTrim - bottomTrim;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightTrim);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = 0;
            if (x != 0) {
                trimU = x + leftTrim + trimWidth <= xSize ? leftTrim : texWidth - (xSize - x);
            }
            this.bufferTexturedModalRect(builder, tex, xPos + x, yPos, trimU, 0.0, rWidth, topTrim, colour);
            this.bufferTexturedModalRect(builder, tex, xPos + x, yPos + ySize - bottomTrim, trimU, texHeight - bottomTrim, rWidth, bottomTrim, colour);
            rWidth = Math.min(xSize - x - leftTrim - rightTrim, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int rHeight = Math.min(ySize - y - topTrim - bottomTrim, trimHeight);
                int trimV = y + (texHeight - topTrim - bottomTrim) <= ySize ? topTrim : texHeight - (ySize - y);
                if (x == 0 && y + topTrim < ySize - bottomTrim) {
                    this.bufferTexturedModalRect(builder, tex, xPos, yPos + y + topTrim, 0.0, trimV, leftTrim, rHeight, colour);
                    this.bufferTexturedModalRect(builder, tex, xPos + xSize - rightTrim, yPos + y + topTrim, trimU + texWidth - rightTrim, trimV, rightTrim, rHeight, colour);
                }
                if (y + topTrim >= ySize - bottomTrim || x + leftTrim >= xSize - rightTrim) continue;
                this.bufferTexturedModalRect(builder, tex, xPos + x + leftTrim, yPos + y + topTrim, leftTrim, topTrim, rWidth, rHeight, colour);
            }
        }
    }

    private void bufferTexturedModalRect(IVertexBuilder builder, TextureAtlasSprite tex, int x, int y, double textureX, double textureY, int width, int height, int colour) {
        double zLevel = this.getRenderZLevel();
        int w = tex.func_94211_a();
        int h = tex.func_94216_b();
        int[] colours = ColourARGB.unpack((int)colour);
        builder.func_225582_a_((double)x, (double)(y + height), zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(tex.func_94214_a(textureX / (double)w * 16.0), tex.func_94207_b((textureY + (double)height) / (double)h * 16.0)).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(tex.func_94214_a((textureX + (double)width) / (double)w * 16.0), tex.func_94207_b((textureY + (double)height) / (double)h * 16.0)).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)y, zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(tex.func_94214_a((textureX + (double)width) / (double)w * 16.0), tex.func_94207_b(textureY / (double)h * 16.0)).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, zLevel).func_225586_a_(colours[1], colours[2], colours[3], colours[0]).func_225583_a_(tex.func_94214_a(textureX / (double)w * 16.0), tex.func_94207_b(textureY / (double)h * 16.0)).func_181675_d();
    }

    @Deprecated
    private void bufferRect(IVertexBuilder buffer, float x, float y, float width, float height, float minU, float minV, float tWidth, float tHeight) {
        double zLevel = this.getRenderZLevel();
        buffer.func_225582_a_((double)x, (double)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, minV + tHeight).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU + tWidth, minV + tHeight).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU + tWidth, minV).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, minV).func_181675_d();
    }

    public void drawGradient(IRenderTypeBuffer getter, double xPos, double yPos, double xSize, double ySize, int startColor, int endColor) {
        this.drawGradientRect(getter, xPos, yPos, xPos + xSize, yPos + ySize, startColor, endColor);
    }

    public void drawGradientRect(IRenderTypeBuffer getter, double left, double top, double right, double bottom, int startColor, int endColor) {
        if (startColor == endColor && endColor == 0) {
            return;
        }
        double zLevel = this.getRenderZLevel();
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        IVertexBuilder builder = getter.getBuffer(transColourType);
        builder.func_225582_a_(right, top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(left, top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(left, bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_(right, bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
    }

    public void drawSideGradient(IRenderTypeBuffer getter, double xPos, double yPos, double xSize, double ySize, int leftColor, int rightColor) {
        this.drawSideGradientRect(getter, xPos, yPos, xPos + xSize, yPos + ySize, leftColor, rightColor);
    }

    public void drawSideGradientRect(IRenderTypeBuffer getter, double left, double top, double right, double bottom, int leftColor, int rightColor) {
        if (leftColor == rightColor && rightColor == 0) {
            return;
        }
        double zLevel = this.getRenderZLevel();
        float startAlpha = (float)(rightColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(rightColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(rightColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(rightColor & 0xFF) / 255.0f;
        float endAlpha = (float)(leftColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(leftColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(leftColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(leftColor & 0xFF) / 255.0f;
        IVertexBuilder builder = getter.getBuffer(transColourType);
        builder.func_225582_a_(right, top, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(left, top, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_(left, bottom, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_(right, bottom, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
    }

    public void drawMultiPassGradientRect(IRenderTypeBuffer getter, double left, double top, double right, double bottom, int colour1, int colour2, int layers) {
        if (colour1 == colour2 && colour2 == 0) {
            return;
        }
        double zLevel = this.getRenderZLevel();
        float alpha1 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(colour1 & 0xFF) / 255.0f;
        float alpha2 = (float)(colour2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(colour2 & 0xFF) / 255.0f;
        IVertexBuilder builder = getter.getBuffer(transColourType);
        for (int i = 0; i < layers; ++i) {
            builder.func_225582_a_(right, top, zLevel).func_227885_a_(red1, green1, blue1, alpha1).func_181675_d();
            builder.func_225582_a_(left, top, zLevel).func_227885_a_(red1, green1, blue1, alpha1).func_181675_d();
            builder.func_225582_a_(left, bottom, zLevel).func_227885_a_(red2, green2, blue2, alpha2).func_181675_d();
            builder.func_225582_a_(right, bottom, zLevel).func_227885_a_(red2, green2, blue2, alpha2).func_181675_d();
        }
    }

    public void drawColouredRect(IRenderTypeBuffer getter, double posX, double posY, double xSize, double ySize, int colour) {
        this.drawColouredRectABS(getter, posX, posY, posX + xSize, posY + ySize, colour);
    }

    public void drawColouredRectABS(IRenderTypeBuffer getter, double left, double top, double right, double bottom, int colour) {
        double zLevel = this.getRenderZLevel();
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        IVertexBuilder builder = getter.getBuffer(transColourType);
        builder.func_225582_a_(right, top, zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(left, top, zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(left, bottom, zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(right, bottom, zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public void drawBorderedRect(IRenderTypeBuffer getter, double posX, double posY, double xSize, double ySize, double borderWidth, int fillColour, int borderColour) {
        this.drawColouredRect(getter, posX, posY, xSize, borderWidth, borderColour);
        this.drawColouredRect(getter, posX, posY + ySize - borderWidth, xSize, borderWidth, borderColour);
        this.drawColouredRect(getter, posX, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour);
        this.drawColouredRect(getter, posX + xSize - borderWidth, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour);
        this.drawColouredRect(getter, posX + borderWidth, posY + borderWidth, xSize - 2.0 * borderWidth, ySize - 2.0 * borderWidth, fillColour);
    }

    public void drawShadedRect(IRenderTypeBuffer getter, double x, double y, double width, double height, double borderWidth, int fill, int topLeftColour, int bottomRightColour, int cornerMixColour) {
        this.drawColouredRect(getter, x + borderWidth, y + borderWidth, width - borderWidth * 2.0, height - borderWidth * 2.0, fill);
        this.drawColouredRect(getter, x, y, width - borderWidth, borderWidth, topLeftColour);
        this.drawColouredRect(getter, x, y + borderWidth, borderWidth, height - borderWidth * 2.0, topLeftColour);
        this.drawColouredRect(getter, x + borderWidth, y + height - borderWidth, width - borderWidth, borderWidth, bottomRightColour);
        this.drawColouredRect(getter, x + width - borderWidth, y + borderWidth, borderWidth, height - borderWidth * 2.0, bottomRightColour);
        this.drawColouredRect(getter, x + width - borderWidth, y, borderWidth, borderWidth, cornerMixColour);
        this.drawColouredRect(getter, x, y + height - borderWidth, borderWidth, borderWidth, cornerMixColour);
    }

    public void renderVanillaButtonTexture(IRenderTypeBuffer getter, int xPos, int yPos, int xSize, int ySize, boolean hovered, boolean disabled) {
        int k = 1;
        if (disabled) {
            k = 0;
        } else if (hovered) {
            k = 2;
        }
        int texHeight = Math.min(20, ySize);
        int texPos = 46 + k * 20;
        if (ySize >= 20 && ySize > 20) {
            int y = yPos + 17;
            while (y + 15 < yPos + ySize) {
                y += 15;
            }
        }
    }

    public void drawTiledTextureRectWithTrim(IRenderTypeBuffer getter, int xPos, int yPos, int xSize, int ySize, int topTrim, int leftTrim, int bottomTrim, int rightTrim, int texU, int texV, int texWidth, int texHeight) {
        int trimWidth = texWidth - leftTrim - rightTrim;
        int trimHeight = texHeight - topTrim - bottomTrim;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightTrim);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = x == 0 ? texU : (x + trimWidth <= xSize ? texU + leftTrim : texU + texWidth - (xSize - x));
            this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos + x, yPos, trimU, texV, rWidth, topTrim);
            this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos + x, yPos + ySize - bottomTrim, trimU, texV + texHeight - bottomTrim, rWidth, bottomTrim);
            rWidth = Math.min(xSize - x - leftTrim - rightTrim, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int trimV;
                int rHeight = Math.min(ySize - y - topTrim - bottomTrim, trimHeight);
                int n = trimV = y + texHeight <= ySize ? texV + topTrim : texV + texHeight - (ySize - y);
                if (x == 0) {
                    this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos, yPos + y + topTrim, texU, trimV, leftTrim, rHeight);
                    this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos + xSize - rightTrim, yPos + y + topTrim, trimU + texWidth - rightTrim, trimV, rightTrim, rHeight);
                }
                if (y >= ySize - bottomTrim || x >= xSize - rightTrim) continue;
                this.bufferTexturedModalRect((IVertexBuilder)buffer, xPos + x + leftTrim, yPos + y + topTrim, texU + leftTrim, texV + topTrim, rWidth, rHeight);
            }
        }
        tessellator.func_78381_a();
    }

    private void bufferTexturedModalRect(IVertexBuilder buffer, int x, int y, float textureX, float textureY, int width, int height) {
        double zLevel = this.getRenderZLevel();
        buffer.func_225582_a_((double)x, (double)(y + height), zLevel).func_225583_a_(textureX * 0.00390625f, (textureY + (float)height) * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225583_a_((textureX + (float)width) * 0.00390625f, (textureY + (float)height) * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, zLevel).func_225583_a_((textureX + (float)width) * 0.00390625f, textureY * 0.00390625f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, zLevel).func_225583_a_(textureX * 0.00390625f, textureY * 0.00390625f).func_181675_d();
    }

    public int drawString(BCFontRenderer fontRenderer, String text, float x, float y, int colour) {
        return this.drawString((FontRenderer)fontRenderer, text, x, y, colour, false);
    }

    public int drawString(FontRenderer fontRenderer, String text, float x, float y, int colour, boolean dropShadow) {
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack textStack = new MatrixStack();
        textStack.func_227861_a_(0.0, 0.0, (double)this.getRenderZLevel());
        Matrix4f textLocation = textStack.func_227866_c_().func_227870_a_();
        int i = fontRenderer.func_228079_a_(text, x, y, colour, dropShadow, textLocation, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
        renderType.func_228461_a_();
        return i;
    }

    public float drawString(FontRenderer fontRenderer, ITextProperties text, float x, float y, int colour) {
        return this.drawString(fontRenderer, text, x, y, colour, false);
    }

    public float drawString(FontRenderer fontRenderer, ITextProperties text, float x, float y, int colour, boolean dropShadow) {
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack textStack = new MatrixStack();
        textStack.func_227861_a_(0.0, 0.0, (double)this.getRenderZLevel());
        Matrix4f textLocation = textStack.func_227866_c_().func_227870_a_();
        float i = fontRenderer.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(text), x, y, colour, dropShadow, textLocation, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
        renderType.func_228461_a_();
        return i;
    }

    public void drawCenteredString(FontRenderer fontRenderer, String text, float x, float y, int colour, boolean dropShadow) {
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack textStack = new MatrixStack();
        textStack.func_227861_a_(0.0, 0.0, (double)this.getRenderZLevel());
        Matrix4f textLocation = textStack.func_227866_c_().func_227870_a_();
        fontRenderer.func_228079_a_(text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, colour, dropShadow, textLocation, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
        renderType.func_228461_a_();
    }

    public void drawSplitString(FontRenderer fontRenderer, String text, float x, float y, int wrapWidth, int colour, boolean dropShadow) {
        for (String s : BCFontRenderer.listFormattedStringToWidth(text, wrapWidth)) {
            this.drawString(fontRenderer, s, x, y, colour, dropShadow);
            fontRenderer.getClass();
            y += 9.0f;
        }
    }

    public void drawCenteredSplitString(FontRenderer fontRenderer, String str, float x, float y, int wrapWidth, int colour, boolean dropShadow) {
        for (String s : BCFontRenderer.listFormattedStringToWidth(str, wrapWidth)) {
            this.drawCenteredString(fontRenderer, s, x, y, colour, dropShadow);
            fontRenderer.getClass();
            y += 9.0f;
        }
    }

    public void drawCustomString(FontRenderer fr, String text, float x, float y, int width, int colour, GuiAlign alignment, GuiAlign.TextRotation rotation, boolean wrap, boolean trim, boolean dropShadow) {
        this.drawCustomString(fr, text, x, y, width, colour, alignment, rotation, wrap, trim, false, dropShadow);
    }

    public void drawCustomString(FontRenderer fr, String text, float x, float y, int width, int colour, GuiAlign alignment, GuiAlign.TextRotation rotation, boolean wrap, boolean trim, boolean midTrim, boolean dropShadow) {
        if (width <= 0) {
            return;
        }
        StringTextComponent textComponent = new StringTextComponent(text);
        if (trim && fr.func_78256_a(text) > width) {
            int dotW = fr.func_78256_a("..");
            text = midTrim ? fr.func_238412_a_(text, width / 2 - dotW / 2) + ".." + fr.func_238413_a_(text, width / 2 - dotW / 2, true) : fr.func_238412_a_(text, width - dotW) + "..";
        }
        if (rotation == GuiAlign.TextRotation.NORMAL) {
            if (wrap) {
                this.drawAlignedSplitString(fr, text, x, y, width, alignment, colour, dropShadow);
            } else if (text.contains("\n")) {
                int offset = 0;
                String prefix = "";
                if (text.startsWith("\u00a7") && text.length() > 1) {
                    prefix = text.substring(0, 2);
                }
                for (String str : text.split("\n")) {
                    if (str.isEmpty()) continue;
                    this.drawAlignedString(fr, str.startsWith("\u00a7") ? str : prefix + str, x, y + (float)offset, width, alignment, colour, dropShadow, trim);
                    ((Object)((Object)this.fontRenderer)).getClass();
                    offset += 9;
                }
            } else {
                this.drawAlignedString(fr, text, x, y, width, alignment, colour, dropShadow, trim);
            }
        } else {
            RenderSystem.pushMatrix();
            if (rotation == GuiAlign.TextRotation.ROT_C) {
                RenderSystem.translated((double)x, (double)y, (double)0.0);
                RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (rotation == GuiAlign.TextRotation.ROT_CC) {
                RenderSystem.translated((double)x, (double)(y + (float)width), (double)0.0);
                RenderSystem.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (rotation == GuiAlign.TextRotation.ROT_180) {
                RenderSystem.translated((double)(x + (float)width), (double)(y + (float)fr.func_78267_b(text, width)), (double)0.0);
                RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (wrap) {
                this.drawAlignedSplitString(fr, text, 0.0f, 0.0f, width, alignment, colour, dropShadow);
            } else {
                this.drawAlignedString(fr, text, 0.0f, 0.0f, width, alignment, colour, dropShadow, trim);
            }
            RenderSystem.popMatrix();
        }
    }

    public void drawCustomString(FontRenderer fr, ITextProperties text, float x, float y, int width, int colour, GuiAlign alignment, boolean wrap, boolean trim, boolean dropShadow) {
        boolean willTrim;
        if (width <= 0) {
            return;
        }
        boolean bl = willTrim = trim && fr.func_238414_a_(text) > width;
        if (willTrim) {
            int dotW = fr.func_78256_a("..");
            Style style = text instanceof ITextComponent ? ((ITextComponent)text).func_150256_b() : Style.field_240709_b_;
            text = fr.func_238420_b_().func_238358_a_(text, width - dotW, Style.field_240709_b_);
            text = ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{text, new StringTextComponent("..").func_240703_c_(style)});
        }
        if (wrap) {
            this.drawAlignedSplitString(fr, text, x, y, width, alignment, colour, dropShadow);
        } else {
            float f = this.drawAlignedString(fr, text, x, y, width, alignment, colour, dropShadow, trim);
        }
    }

    public void drawAlignedSplitString(FontRenderer fontRenderer, String text, float x, float y, int width, GuiAlign alignment, int colour, boolean dropShadow) {
        for (String s : BCFontRenderer.listFormattedStringToWidth(text, width)) {
            this.drawAlignedString(fontRenderer, s, x, y, width, alignment, colour, dropShadow, false);
            fontRenderer.getClass();
            y += 9.0f;
        }
    }

    public void drawAlignedSplitString(FontRenderer fontRenderer, ITextProperties text, float x, float y, int width, GuiAlign alignment, int colour, boolean dropShadow) {
        for (ITextProperties s : fontRenderer.func_238420_b_().func_238362_b_(text, width, Style.field_240709_b_)) {
            this.drawAlignedString(fontRenderer, s, x, y, width, alignment, colour, dropShadow, false);
            fontRenderer.getClass();
            y += 9.0f;
        }
    }

    public void drawAlignedString(FontRenderer fr, String text, float x, float y, int width, GuiAlign alignment, int colour, boolean dropShadow, boolean trim) {
        if (trim && fr.func_78256_a(text) > width) {
            text = fr.func_238412_a_(text, width - 8) + "..";
        }
        int stringWidth = fr.func_78256_a(text);
        switch (alignment) {
            case LEFT: {
                this.drawString((FontRenderer)this.fontRenderer, text, x, y, colour, dropShadow);
                break;
            }
            case CENTER: {
                this.drawString((FontRenderer)this.fontRenderer, text, x + (float)((width - stringWidth) / 2), y, colour, dropShadow);
                break;
            }
            case RIGHT: {
                this.drawString((FontRenderer)this.fontRenderer, text, x + (float)(width - stringWidth), y, colour, dropShadow);
            }
        }
    }

    public float drawAlignedString(FontRenderer fr, ITextProperties text, float x, float y, int width, GuiAlign alignment, int colour, boolean dropShadow, boolean trim) {
        boolean willTrim;
        boolean bl = willTrim = trim && fr.func_238414_a_(text) > width;
        if (willTrim) {
            int dotW = fr.func_78256_a("..");
            Style style = text instanceof ITextComponent ? ((ITextComponent)text).func_150256_b() : Style.field_240709_b_;
            text = fr.func_238420_b_().func_238358_a_(text, width - dotW, Style.field_240709_b_);
            text = ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{text, new StringTextComponent("..").func_240703_c_(style)});
        }
        float end = 0.0f;
        int stringWidth = fr.func_238414_a_(text);
        switch (alignment) {
            case LEFT: {
                end = this.drawString((FontRenderer)this.fontRenderer, text, x, y, colour, dropShadow);
                break;
            }
            case CENTER: {
                end = this.drawString((FontRenderer)this.fontRenderer, text, x + (float)((width - stringWidth) / 2), y, colour, dropShadow);
                break;
            }
            case RIGHT: {
                end = this.drawString((FontRenderer)this.fontRenderer, text, x + (float)(width - stringWidth), y, colour, dropShadow);
            }
        }
        return end;
    }

    public void drawHoveringText(List<String> textLines, int mouseX, int mouseY, BCFontRenderer font, int screenWidth, int screenHeight) {
        this.drawHoveringTextString(textLines, mouseX, mouseY, font, screenWidth, screenHeight, -1);
    }

    @Deprecated
    public void drawHoveringTextString(List<String> textLines, int mouseX, int mouseY, FontRenderer font) {
        this.drawHoveringTextString(textLines, mouseX, mouseY, font, this.screenWidth, this.screenHeight, Math.max(mouseX, this.screenWidth - mouseX));
    }

    @Deprecated
    public void drawHoveringTextString(List<String> textLines, int mouseX, int mouseY, FontRenderer font, int screenWidth, int screenHeight, int maxTextWidth) {
        font = this.mc.field_71466_p;
        if (!textLines.isEmpty()) {
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List<String> wrappedLine = BCFontRenderer.listFormattedStringToWidth(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            }
            double renderOffset = 800.0f - this.getRenderZLevel();
            this.zOffset += renderOffset;
            int backgroundColor = -267386864;
            this.drawGradientRect(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            this.drawGradientRect(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, 0x505000FF, 0x505000FF);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, 1344798847, 1344798847);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                this.drawString(font, line, (float)tooltipX, (float)tooltipY, -1, true);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            this.zOffset -= renderOffset;
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }

    public void drawHoveringText(List<? extends ITextProperties> textLines, int mouseX, int mouseY, FontRenderer font) {
        this.drawHoveringText(ItemStack.field_190927_a, textLines, mouseX, mouseY, this.screenWidth, this.screenHeight, Math.max(mouseX, this.screenWidth - mouseX), font);
    }

    public void drawHoveringText(@Nonnull ItemStack stack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        if (!textLines.isEmpty()) {
            int n;
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, new MatrixStack(), mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            maxTextWidth = event.getMaxWidth();
            font = event.getFontRenderer() == font ? font : BCFontRenderer.convert(event.getFontRenderer());
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (ITextProperties iTextProperties : textLines) {
                int textLineWidth = font.func_238414_a_(iTextProperties);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
                for (int i = 0; i < textLines.size(); ++i) {
                    ITextProperties textLine = textLines.get(i);
                    List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (ITextProperties line : wrappedLine) {
                        int lineWidth = font.func_238414_a_(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((ITextProperties)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            double renderOffset = 800.0f - this.getRenderZLevel();
            this.zOffset += renderOffset;
            int backgroundColor = -267386864;
            this.drawGradientRect(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            this.drawGradientRect(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, 0x505000FF, 0x505000FF);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, 1344798847, 1344798847);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, new MatrixStack(), tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                ITextProperties line = textLines.get(lineNumber);
                if (line != null) {
                    IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                    MatrixStack textStack = new MatrixStack();
                    textStack.func_227861_a_(0.0, 0.0, (double)this.getRenderZLevel());
                    Matrix4f mat = textStack.func_227866_c_().func_227870_a_();
                    font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
                    renderType.func_228461_a_();
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            this.zOffset -= renderOffset;
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, new MatrixStack(), tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }

    public static int mixColours(int colour1, int colour2) {
        return GuiElement.mixColours(colour1, colour2, false);
    }

    public static int mixColours(int colour1, int colour2, boolean subtract) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        int alpha = net.minecraft.util.math.MathHelper.func_76125_a((int)(alpha1 + (subtract ? -alpha2 : alpha2)), (int)0, (int)255);
        int red = net.minecraft.util.math.MathHelper.func_76125_a((int)(red1 + (subtract ? -red2 : red2)), (int)0, (int)255);
        int green = net.minecraft.util.math.MathHelper.func_76125_a((int)(green1 + (subtract ? -green2 : green2)), (int)0, (int)255);
        int blue = net.minecraft.util.math.MathHelper.func_76125_a((int)(blue1 + (subtract ? -blue2 : blue2)), (int)0, (int)255);
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int midColour(int colour1, int colour2) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        return (alpha2 + (alpha1 - alpha2) / 2 & 0xFF) << 24 | (red2 + (red1 - red2) / 2 & 0xFF) << 16 | (green2 + (green1 - green2) / 2 & 0xFF) << 8 | blue2 + (blue1 - blue2) / 2 & 0xFF;
    }

    public int changeShade(int colour, double shade) {
        double r = (double)(colour >> 16 & 0xFF) / 255.0;
        double g = (double)(colour >> 8 & 0xFF) / 255.0;
        double b = (double)(colour & 0xFF) / 255.0;
        double a = (double)(colour >> 24 & 0xFF) / 255.0;
        this.colourRatio.set(r, g, b);
        if (this.colourRatio.magSquared() == 0.0) {
            this.colourRatio.set(1.0);
        }
        this.colourRatio.normalize();
        r = MathHelper.clip((double)(r + this.colourRatio.x * shade), (double)0.0, (double)1.0);
        g = MathHelper.clip((double)(g + this.colourRatio.y * shade), (double)0.0, (double)1.0);
        b = MathHelper.clip((double)(b + this.colourRatio.z * shade), (double)0.0, (double)1.0);
        return ((int)(a * 255.0) & 0xFF) << 24 | ((int)(r * 255.0) & 0xFF) << 16 | ((int)(g * 255.0) & 0xFF) << 8 | (int)(b * 255.0) & 0xFF;
    }

    public E setHoverTextEnabled(boolean enableHoverText) {
        this.drawHoverText = enableHoverText;
        return (E)this;
    }

    public boolean isHoverTextEnabled() {
        return this.drawHoverText;
    }

    public E setHoverTextDelay(int hoverTextDelay) {
        this.hoverTextDelay = hoverTextDelay;
        return (E)this;
    }

    public E setHoverText(HoverTextSupplier<E> hoverText) {
        this.hoverText = hoverText;
        this.setHoverTextEnabled(true);
        return (E)this;
    }

    public E setHoverText(String singleLine) {
        this.setHoverText((E element) -> singleLine);
        return (E)this;
    }

    public E setHoverText(String ... textLines) {
        this.setHoverText((E element) -> textLines);
        return (E)this;
    }

    public E setHoverText(List<String> textLines) {
        this.setHoverText((E element) -> textLines);
        return (E)this;
    }

    public E setComponentHoverText(List<ITextComponent> textLines) {
        this.setHoverText((E element) -> textLines.stream().map(ITextComponent::getString).collect(Collectors.toList()));
        return (E)this;
    }

    public List<String> getHoverText() {
        return this.hoverText == null || !this.drawHoverText ? Collections.emptyList() : this.hoverText.getHoverText(this);
    }

    public int getHoverTime() {
        return this.hoverTime;
    }

    public E setResetHoverOnClick(boolean resetHoverOnClick) {
        this.resetHoverOnClick = resetHoverOnClick;
        return (E)this;
    }

    public GuiElement<E> $plus$eq(GuiElement<?> other) {
        this.addChild(other);
        return this;
    }

    public static interface IDrawCallback {
        public void call(Minecraft var1, int var2, int var3, float var4, boolean var5);

        public static void resetColour(Minecraft minecraft, int mouseX, int mouseY, float partialTicks, boolean mouseOver) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

