/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.baseelements;

import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiButton
extends GuiElement<GuiButton> {
    protected static ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    protected ResourceLocation textureOverride;
    protected Supplier<ResourceLocation> textureSupplier;
    protected Consumer<Integer> pressListener = null;
    protected Consumer<Integer> releaseListener = null;
    protected boolean trim = true;
    protected boolean wrap = false;
    protected boolean disabled = false;
    protected boolean dropShadow = true;
    protected GuiAlign alignment = GuiAlign.CENTER;
    protected GuiAlign.TextRotation rotation = GuiAlign.TextRotation.NORMAL;
    private double backgroundBorderWidth = 1.0;
    private String displayString = "";
    private boolean toggleMode = false;
    private boolean toggleActiveState = false;
    private boolean vanillaButtonRender = false;
    private boolean drawBorderedRectBackground = false;
    private Supplier<Boolean> toggleStateSupplier;
    private Supplier<String> displayStringSupplier;
    private Supplier<Boolean> disabledStateSupplier;
    private GuiColourProvider.HoverDisableColour<Integer> texColGetter;
    private GuiColourProvider.HoverDisableColour<Integer> rectFillColour;
    private GuiColourProvider.HoverDisableColour<Integer> rectBorderColour;
    public int buttonId = -1;
    public String buttonName = "";
    public boolean playClick = true;
    public int textXOffset = 0;
    public int textYOffset = 0;
    private boolean isPressed = false;
    private boolean is3dText = false;

    public GuiButton() {
        this.setSize(100, 20);
        this.setInsets(5, 5, 5, 5);
    }

    public GuiButton(int xPos, int yPos) {
        super(xPos, yPos);
        this.setSize(100, 20);
        this.setInsets(5, 5, 5, 5);
    }

    public GuiButton(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
        this.setInsets(5, 5, 5, 5);
    }

    public GuiButton(String buttonText) {
        this.setSize(100, 20);
        this.setInsets(5, 5, 5, 5);
        this.displayString = buttonText;
    }

    public GuiButton(int xPos, int yPos, String buttonText) {
        this(xPos, yPos);
        this.displayString = buttonText;
    }

    public GuiButton(int xPos, int yPos, int xSize, int ySize, String buttonText) {
        this(xPos, yPos, xSize, ySize);
        this.displayString = buttonText;
    }

    public GuiButton(int buttonId, String buttonText) {
        this(buttonText);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId, int xPos, int yPos, String buttonText) {
        this(xPos, yPos, buttonText);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId, int xPos, int yPos, int xSize, int ySize, String buttonText) {
        this(xPos, yPos, xSize, ySize, buttonText);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId) {
        this.setInsets(5, 5, 5, 5);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId, int xPos, int yPos) {
        this(xPos, yPos);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId, int xPos, int yPos, int xSize, int ySize) {
        this(xPos, yPos, xSize, ySize);
        this.buttonId = buttonId;
    }

    public GuiButton onPressed(Runnable action) {
        return this.onButtonPressed(m -> action.run());
    }

    public GuiButton onButtonPressed(Consumer<Integer> action) {
        this.pressListener = action;
        return this;
    }

    public GuiButton onReleased(Runnable action) {
        return this.onButtonReleased(m -> action.run());
    }

    public GuiButton onButtonReleased(Consumer<Integer> action) {
        this.releaseListener = action;
        return this;
    }

    public boolean isDisabled() {
        return this.disabledStateSupplier != null ? this.disabledStateSupplier.get() : this.disabled;
    }

    public GuiButton setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public GuiButton setDisabledStateSupplier(Supplier<Boolean> disabledStateSupplier) {
        this.disabledStateSupplier = disabledStateSupplier;
        return this;
    }

    public GuiButton set3dText(boolean is3dText) {
        this.is3dText = is3dText;
        return this;
    }

    public boolean isPressed() {
        return this.isPressed || this.toggleMode && this.getToggleState();
    }

    protected boolean actualPressedState() {
        return this.isPressed;
    }

    public GuiButton setButtonId(int buttonId) {
        this.buttonId = buttonId;
        return this;
    }

    public GuiButton setButtonName(String buttonName) {
        this.buttonName = buttonName;
        return this;
    }

    public GuiButton setText(String displayString) {
        this.displayString = displayString;
        return this;
    }

    public GuiButton setDisplaySupplier(Supplier<String> displayStringSupplier) {
        this.displayStringSupplier = displayStringSupplier;
        return this;
    }

    public String getDisplayString() {
        return this.displayStringSupplier != null ? this.displayStringSupplier.get() : this.displayString;
    }

    public GuiButton setAlignment(GuiAlign alignment) {
        this.alignment = alignment;
        return this;
    }

    public GuiAlign getAlignment() {
        return this.alignment;
    }

    public GuiButton setTrim(boolean trim) {
        this.trim = trim;
        if (trim) {
            this.wrap = false;
        }
        return this;
    }

    public GuiButton setWrap(boolean wrap) {
        this.wrap = wrap;
        if (wrap) {
            this.trim = false;
        }
        return this;
    }

    public GuiButton setRotation(GuiAlign.TextRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiAlign.TextRotation getRotation() {
        return this.rotation;
    }

    public GuiButton setShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public int getTextColour(boolean hovered, boolean disabled) {
        if (this.texColGetter != null) {
            return this.texColGetter.getColour(hovered, disabled);
        }
        if (disabled) {
            return 0xA0A0A0;
        }
        return hovered ? 0xFFFFA0 : 0xE0E0E0;
    }

    public GuiButton setTextColGetter(GuiColourProvider.HoverDisableColour<Integer> texColGetter) {
        this.texColGetter = texColGetter;
        return this;
    }

    public GuiButton setTextColour(int colour, int colourHover, int colourDisabled) {
        this.setTextColGetter((hovering, disabled1) -> disabled1 ? colourDisabled : (hovering ? colourHover : colour));
        return this;
    }

    public GuiButton setTextColour(TextFormatting colour, TextFormatting colourHover) {
        return this.setTextColour(colour.func_211163_e(), colourHover.func_211163_e());
    }

    public GuiButton setTextColour(int colour, int colourHover) {
        if (this.texColGetter != null) {
            int dis = this.texColGetter.getColour(false, true);
            this.setTextColGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? colourHover : colour));
        }
        this.setTextColGetter((hovering, disabled1) -> hovering ? colourHover : colour);
        return this;
    }

    public GuiButton setTextColour(TextFormatting colour) {
        return this.setTextColour(colour.func_211163_e());
    }

    public GuiButton setTextColour(int colour) {
        if (this.texColGetter != null) {
            int dis = this.texColGetter.getColour(false, true);
            int hover = this.texColGetter.getColour(true, false);
            this.setTextColGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? hover : colour));
        }
        this.setTextColGetter((hovering, disabled1) -> colour);
        return this;
    }

    public GuiButton setVanillaButtonRender(boolean vanillaButtonRender) {
        this.vanillaButtonRender = vanillaButtonRender;
        return this;
    }

    public GuiButton enableVanillaRender() {
        return this.setVanillaButtonRender(true);
    }

    public GuiButton disableVanillaRender() {
        return this.setVanillaButtonRender(false);
    }

    public GuiButton setDrawBorderedRectBackground(boolean drawBorderedRectBackground) {
        this.drawBorderedRectBackground = drawBorderedRectBackground;
        return this;
    }

    public GuiButton setRectFillColourGetter(GuiColourProvider.HoverDisableColour<Integer> rectBackColour) {
        this.rectFillColour = rectBackColour;
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setRectBorderColourGetter(GuiColourProvider.HoverDisableColour<Integer> rectBorderColour) {
        this.rectBorderColour = rectBorderColour;
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setRectColours(int fill, int fillHover, int fillDisabled, int border, int borderHover, int borderDisabled) {
        this.setRectFillColourGetter((hovering, disabled1) -> disabled1 ? fillDisabled : (hovering ? fillHover : fill));
        this.setRectBorderColourGetter((hovering, disabled1) -> disabled1 ? borderDisabled : (hovering ? borderHover : border));
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setRectColours(int fill, int fillHover, int border, int borderHover) {
        this.setRectFillColourGetter((hovering, disabled1) -> hovering ? fillHover : fill);
        this.setRectBorderColourGetter((hovering, disabled1) -> hovering ? borderHover : border);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setFillColours(int fill, int fillHover, int fillDisabled) {
        this.setRectFillColourGetter((hovering, disabled1) -> disabled1 ? fillDisabled : (hovering ? fillHover : fill));
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setFillColours(int fill, int fillHover) {
        if (this.rectFillColour != null) {
            int dis = this.rectFillColour.getColour(false, true);
            this.setRectFillColourGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? fillHover : fill));
        }
        this.setRectFillColourGetter((hovering, disabled1) -> hovering ? fillHover : fill);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setFillColour(int fill) {
        if (this.rectFillColour != null) {
            int dis = this.rectFillColour.getColour(false, true);
            int hover = this.rectFillColour.getColour(true, false);
            this.setRectFillColourGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? hover : fill));
        }
        this.setRectFillColourGetter((hovering, disabled1) -> fill);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setBorderColours(int border, int borderHover, int borderDisabled) {
        this.setRectBorderColourGetter((hovering, disabled1) -> disabled1 ? borderDisabled : (hovering ? borderHover : border));
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setBorderColours(int border, int borderHover) {
        if (this.rectBorderColour != null) {
            int dis = this.rectBorderColour.getColour(false, true);
            this.setRectBorderColourGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? borderHover : border));
        }
        this.setRectBorderColourGetter((hovering, disabled1) -> hovering ? borderHover : border);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setBorderColour(int border) {
        if (this.rectBorderColour != null) {
            int dis = this.rectBorderColour.getColour(false, true);
            int hover = this.rectBorderColour.getColour(true, false);
            this.setRectBorderColourGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? hover : border));
        }
        this.setRectBorderColourGetter((hovering, disabled1) -> border);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setBorderWidth(double backgroundBorderWidth) {
        this.backgroundBorderWidth = backgroundBorderWidth;
        return this;
    }

    public int getFillColour(boolean hover, boolean disabled) {
        if (this.rectFillColour != null) {
            return this.rectFillColour.getColour(hover, disabled);
        }
        if (this.rectBorderColour != null) {
            return this.rectBorderColour.getColour(hover, disabled);
        }
        return 0;
    }

    public int getBorderColour(boolean hover, boolean disabled) {
        if (this.rectBorderColour != null) {
            return this.rectBorderColour.getColour(hover, disabled);
        }
        if (this.rectFillColour != null) {
            return this.rectFillColour.getColour(hover, disabled);
        }
        return 0;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY) && !this.isDisabled()) {
            this.onPressed(mouseX, mouseY, button);
            this.isPressed = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isPressed) {
            this.playClickEvent(true);
            if (this.releaseListener != null && this.isMouseOver(mouseX, mouseY)) {
                this.releaseListener.accept(button);
            }
        }
        this.isPressed = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseMoved(double mouseX, double mouseY) {
        if (this.isPressed && !this.isMouseOver(mouseX, mouseY)) {
            this.isPressed = false;
        }
        return super.mouseMoved(mouseX, mouseY);
    }

    public void onPressed(double mouseX, double mouseY, int mouseButton) {
        if (this.toggleMode) {
            boolean bl = this.toggleActiveState = !this.getToggleState();
        }
        if (this.playClick) {
            this.playClickEvent(false);
        }
        if (this.pressListener != null) {
            this.pressListener.accept(mouseButton);
        }
    }

    public void playClickEvent(boolean released) {
        if (this.toggleMode) {
            if (released) {
                this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)(this.getToggleState() ? 1.0f : 0.9f)));
            } else {
                this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.85f));
            }
        } else if (!released) {
            this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    @Deprecated
    public static void playGenericClick(Minecraft mc) {
        GuiButton.playGenericClick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playGenericClick() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public GuiButton setClickEnabled(boolean playClick) {
        this.playClick = playClick;
        return this;
    }

    public GuiButton setToggleMode(boolean toggleMode) {
        this.toggleMode = toggleMode;
        return this;
    }

    public GuiButton setToggleState(boolean toggleState) {
        this.toggleActiveState = toggleState;
        return this;
    }

    public boolean getToggleMode() {
        return this.toggleMode;
    }

    public GuiButton setToggleStateSupplier(Supplier<Boolean> toggleStateSupplier) {
        this.toggleStateSupplier = toggleStateSupplier;
        return this;
    }

    public boolean getToggleState() {
        return this.toggleStateSupplier != null ? this.toggleStateSupplier.get() : this.toggleActiveState;
    }

    protected int getRenderState(boolean hovered) {
        int i = 1;
        if (this.isDisabled()) {
            i = 0;
        } else if (hovered) {
            i = 2;
        }
        return i;
    }

    @Override
    public void renderElement(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (this.drawBorderedRectBackground) {
            this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.backgroundBorderWidth, this.getFillColour(mouseOver || this.toggleMode && this.getToggleState(), this.isDisabled()), this.getBorderColour(mouseOver || this.toggleMode && this.getToggleState(), this.disabled));
        }
        if (this.vanillaButtonRender) {
            this.renderVanillaButton(mc, mouseX, mouseY);
        }
        super.renderElement(mc, mouseX, mouseY, partialTicks);
        String displayString = this.getDisplayString();
        if (!displayString.isEmpty()) {
            int colour = this.getTextColour(mouseOver, this.isDisabled());
            int widthLimit = this.rotation == GuiAlign.TextRotation.NORMAL || this.rotation == GuiAlign.TextRotation.ROT_180 ? this.getInsetRect().width : this.getInsetRect().height;
            ((Object)((Object)this.fontRenderer)).getClass();
            int ySize = 9;
            if (this.wrap && !this.trim) {
                ySize = this.fontRenderer.func_78267_b(displayString, widthLimit);
            }
            boolean wrap = this.wrap && this.fontRenderer.func_78256_a(displayString) > widthLimit;
            float xp = (float)this.screenWidth / (float)this.displayWidth();
            float yp = (float)this.screenHeight / (float)this.displayHeight();
            float xPos = (float)(this.textXOffset + this.getInsetRect().x) + (this.is3dText && !this.actualPressedState() ? -xp : 0.0f);
            float yPos = (float)(this.textYOffset + (this.getInsetRect().y + this.getInsetRect().height / 2 - ySize / 2)) + (this.is3dText && !this.actualPressedState() ? -yp : 0.0f);
            switch (this.rotation) {
                case NORMAL: {
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.dropShadow);
                    break;
                }
                case ROT_CC: {
                    xPos = (float)this.textXOffset + ((float)this.getInsetRect().x + (float)this.getInsetRect().width / 2.0f - (float)ySize / 2.0f);
                    yPos = this.textYOffset + this.getInsetRect().y;
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.dropShadow);
                    break;
                }
                case ROT_C: {
                    xPos = (float)this.textXOffset + ((float)this.getInsetRect().x + (float)this.getInsetRect().width / 2.0f - (float)ySize / 2.0f);
                    yPos = this.textYOffset + this.getInsetRect().y;
                    this.drawCustomString(this.fontRenderer, displayString, xPos + (float)ySize, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.dropShadow);
                    break;
                }
                case ROT_180: {
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.dropShadow);
                }
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    protected void renderVanillaButton(Minecraft minecraft, int mouseX, int mouseY) {
        IRenderTypeBuffer.Impl getter = minecraft.func_228019_au_().func_228487_b_();
        boolean hovered = this.isMouseOver(mouseX, mouseY) || this.toggleMode && this.getToggleState();
        RenderMaterial mat = BCSprites.getButton(this.getRenderState(hovered));
        IVertexBuilder builder = mat.func_229311_a_((IRenderTypeBuffer)getter, location -> BCSprites.GUI_TYPE);
        this.drawDynamicSprite(builder, mat.func_229314_c_(), this.xPos(), this.yPos(), this.xSize(), this.ySize(), 2, 2, 2, 2);
        getter.func_228461_a_();
    }

    public GuiButton setTextureOverride(ResourceLocation textureOverride) {
        this.textureOverride = textureOverride;
        return this;
    }

    public GuiButton setTextureSupplier(Supplier<ResourceLocation> textureSupplier) {
        this.textureSupplier = textureSupplier;
        return this;
    }
}

