/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiEntityRenderer
extends GuiElement<GuiEntityRenderer> {
    private static Map<ResourceLocation, Entity> entityCache = new HashMap<ResourceLocation, Entity>();
    private static List<ResourceLocation> invalidEntities = new ArrayList<ResourceLocation>();
    private float rotationSpeed = 1.0f;
    private float lockedRotation = 0.0f;
    private Entity entity;
    private ResourceLocation entityName;
    private boolean invalidEntity = false;
    private boolean rotationLocked = false;
    private boolean trackMouse = false;
    private boolean drawName = false;
    public boolean silentErrors = false;
    public boolean force2dSize = false;

    public GuiEntityRenderer() {
    }

    public GuiEntityRenderer(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiEntityRenderer(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    public GuiEntityRenderer setEntity(Entity entity) {
        this.entity = entity;
        if (this.entity == null) {
            if (!this.silentErrors) {
                LogHelperBC.dev("GuiEntityRenderer#setEntity: Invalid Entity - " + this.entityName);
            }
            this.invalidEntity = true;
            return this;
        }
        this.entityName = entity.func_200600_R().getRegistryName();
        this.invalidEntity = false;
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setEntity(ResourceLocation entity) {
        this.entityName = entity;
        this.entity = entityCache.computeIfAbsent(entity, resourceLocation -> {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
            return type == null ? null : type.func_200721_a((World)this.mc.field_71441_e);
        });
        this.invalidEntity = false;
        if (this.entity == null) {
            if (!this.silentErrors) {
                LogHelperBC.dev("GuiEntityRenderer#setEntity: Invalid Entity - " + this.entityName);
            }
            this.invalidEntity = true;
        }
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setSilentErrors(boolean silentErrors) {
        this.silentErrors = silentErrors;
        return this;
    }

    public GuiEntityRenderer setForce2dSize(boolean force2dSize) {
        this.force2dSize = force2dSize;
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.invalidEntity && !this.silentErrors) {
            LogHelperBC.dev("GuiEntityRenderer: Invalid Entity - " + this.entityName);
            return;
        }
        try {
            if (this.entity != null) {
                float rotation;
                Rectangle rect = this.getInsetRect();
                float scale = this.force2dSize ? Math.min((float)rect.height / this.entity.func_213302_cg(), (float)rect.width / this.entity.func_213311_cf()) : (float)rect.height / this.entity.func_213302_cg();
                double zLevel = this.getRenderZLevel() + 100.0f;
                double posX = (double)rect.x + (double)rect.width / 2.0;
                int yPos = this.yPos() + this.ySize() / 2 + rect.height / 2;
                float f = rotation = this.isRotationLocked() ? this.getLockedRotation() : ((float)BCClientEventHandler.elapsedTicks + partialTicks) * this.getRotationSpeedMultiplier();
                if (this.entity instanceof LivingEntity) {
                    int eyeOffset = (int)((this.entity.func_213302_cg() - this.entity.func_70047_e()) * scale);
                    RenderSystem.translated((double)0.0, (double)0.0, (double)zLevel);
                    InventoryScreen.func_228187_a_((int)((int)posX), (int)yPos, (int)((int)scale), (float)((int)posX - mouseX), (float)(yPos - mouseY - eyeOffset), (LivingEntity)((LivingEntity)this.entity));
                    RenderSystem.translated((double)0.0, (double)0.0, (double)(-zLevel));
                }
            }
        }
        catch (Throwable e) {
            this.invalidEntity = true;
            invalidEntities.add(this.entityName);
            LogHelperBC.error("Failed to build entity in GUI. This is not a bug there are just some entities that can not be rendered like this.");
            LogHelperBC.error("Entity: " + this.entity);
            e.printStackTrace();
        }
    }

    public boolean isRotationLocked() {
        return this.rotationLocked;
    }

    public GuiEntityRenderer rotationLocked(boolean rotationLocked) {
        this.rotationLocked = rotationLocked;
        return this;
    }

    public GuiEntityRenderer setLockedRotation(float lockedRotation) {
        this.lockedRotation = lockedRotation;
        this.rotationLocked(true);
        return this;
    }

    public float getLockedRotation() {
        return this.lockedRotation;
    }

    public boolean isInvalidEntity() {
        return this.invalidEntity;
    }

    public GuiEntityRenderer setRotationSpeedMultiplier(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public GuiEntityRenderer setTrackMouse(boolean trackMouse) {
        this.trackMouse = trackMouse;
        return this;
    }

    public GuiEntityRenderer setDrawName(boolean drawName) {
        this.drawName = drawName;
        return this;
    }

    public float getRotationSpeedMultiplier() {
        return this.rotationSpeed;
    }

    public static PlayerEntity createRenderPlayer(ClientWorld world, String username) {
        return new RemoteClientPlayerEntity(world, SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, username))){

            public String func_175154_l() {
                return super.func_175154_l();
            }

            public ResourceLocation func_110306_p() {
                ResourceLocation resourcelocation;
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(this.func_146103_bH());
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    UUID uuid = PlayerEntity.func_146094_a((GameProfile)this.func_146103_bH());
                    resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                }
                return resourcelocation;
            }

            public boolean func_175148_a(PlayerModelPart part) {
                return true;
            }
        };
    }

    @Override
    public boolean onUpdate() {
        return super.onUpdate();
    }
}

