/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;

public class GuiTexture
extends GuiElement<GuiTexture> {
    public int texU;
    public int texV;
    public int textSheetSizeX = 256;
    public int textSheetSizeY = 256;
    private int texUSize = 0;
    private int texVSize = 0;
    private boolean texSizeOverride = false;
    private Supplier<Integer> texXGetter = null;
    private Supplier<Integer> texYGetter = null;
    public RenderMaterial material;
    public Supplier<RenderMaterial> materialSupplier;
    @Deprecated
    public ResourceLocation texture;
    @Deprecated
    public Supplier<ResourceLocation> textureSupplier;

    @Deprecated
    public GuiTexture(int xPos, int yPos, int textureX, int textureY, int xSize, int ySize, ResourceLocation texture) {
        super(xPos, yPos, xSize, ySize);
        this.texU = textureX;
        this.texV = textureY;
        this.texture = texture;
    }

    @Deprecated
    public GuiTexture(int textureX, int textureY, int xSize, int ySize, ResourceLocation texture) {
        super(0, 0, xSize, ySize);
        this.texU = textureX;
        this.texV = textureY;
        this.texture = texture;
    }

    @Deprecated
    public GuiTexture(int xSize, int ySize, ResourceLocation texture) {
        super(0, 0, xSize, ySize);
        this.texture = texture;
    }

    public GuiTexture(int xPos, int yPos, int xSize, int ySize, RenderMaterial material) {
        super(xPos, yPos, xSize, ySize);
        this.material = material;
    }

    public GuiTexture(int xSize, int ySize, RenderMaterial material) {
        super(0, 0, xSize, ySize);
        this.material = material;
    }

    public GuiTexture(int xSize, int ySize, Supplier<RenderMaterial> materialSupplier) {
        super(0, 0, xSize, ySize);
        this.materialSupplier = materialSupplier;
    }

    public GuiTexture(Supplier<RenderMaterial> materialSupplier) {
        super(0, 0);
        this.materialSupplier = materialSupplier;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        RenderMaterial mat;
        if (this.preDrawCallback == null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if ((mat = this.getMaterial()) != null) {
            IRenderTypeBuffer.Impl getter = minecraft.func_228019_au_().func_228487_b_();
            this.drawSprite(mat.func_229311_a_((IRenderTypeBuffer)getter, BCSprites::makeType), this.xPos(), this.yPos(), this.xSize(), this.ySize(), mat.func_229314_c_());
            getter.func_228461_a_();
        } else {
            ResourceLocation texture = this.getTexture();
            if (texture != null) {
                this.bindTexture(texture);
                if (this.texSizeOverride) {
                    this.drawScaledCustomSizeModalRect(this.xPos(), this.yPos(), this.getTexU(), this.getTexV(), this.texUSize, this.texVSize, this.xSize(), this.ySize(), this.textSheetSizeX, this.textSheetSizeY);
                } else {
                    this.drawModalRectWithCustomSizedTexture(this.xPos(), this.yPos(), this.getTexU(), this.getTexV(), this.xSize(), this.ySize(), this.textSheetSizeX, this.textSheetSizeY);
                }
            }
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Deprecated
    public GuiTexture setTexturePos(int textureX, int textureY) {
        this.texU = textureX;
        this.texV = textureY;
        return this;
    }

    @Deprecated
    public GuiTexture setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    @Deprecated
    public GuiTexture setTextureSupplier(Supplier<ResourceLocation> textureSupplier) {
        this.textureSupplier = textureSupplier;
        return this;
    }

    public GuiTexture setMaterial(RenderMaterial material) {
        this.material = material;
        return this;
    }

    public RenderMaterial getMaterial() {
        return this.materialSupplier == null ? this.material : this.materialSupplier.get();
    }

    public GuiTexture setMaterialSupplier(Supplier<RenderMaterial> materialSupplier) {
        this.materialSupplier = materialSupplier;
        return this;
    }

    @Deprecated
    public ResourceLocation getTexture() {
        return this.textureSupplier == null ? this.texture : this.textureSupplier.get();
    }

    @Deprecated
    public GuiTexture setTexture(String texture) {
        this.texture = ResourceHelperBC.getResourceRAW(texture);
        return this;
    }

    @Deprecated
    public GuiTexture setTexSizeOverride(int texXOverride, int texYOverride) {
        this.texUSize = texXOverride;
        this.texVSize = texYOverride;
        this.texSizeOverride = true;
        return this;
    }

    @Deprecated
    public GuiTexture setTexSheetSize(int textureSizeX, int textureSizeY) {
        this.textSheetSizeX = textureSizeX;
        this.textSheetSizeY = textureSizeY;
        return this;
    }

    @Deprecated
    public GuiTexture setTexSheetSize(int textureSize) {
        return this.setTexSheetSize(textureSize, textureSize);
    }

    @Deprecated
    public GuiTexture setTexXGetter(Supplier<Integer> texXGetter) {
        this.texXGetter = texXGetter;
        return this;
    }

    @Deprecated
    public GuiTexture setTexYGetter(Supplier<Integer> texYGetter) {
        this.texYGetter = texYGetter;
        return this;
    }

    @Deprecated
    public int getTexU() {
        return this.texXGetter == null ? this.texU : this.texXGetter.get();
    }

    @Deprecated
    public int getTexV() {
        return this.texYGetter == null ? this.texV : this.texYGetter.get();
    }

    @Deprecated
    public static GuiTexture newBCTexture(int xSize, int ySize) {
        return new GuiTexture(0, 0, xSize, ySize, ResourceHelperBC.getResourceRAW("brandonscore:textures/gui/base_gui.png")){

            @Override
            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                ResourceHelperBC.bindTexture(this.getTexture());
                this.drawTexturedModalRect(this.xPos(), this.yPos(), 0, 0, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos() + this.xSize() / 2, this.yPos(), 256 - this.xSize() / 2, 0, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos(), this.yPos() + this.ySize() / 2, 0, 256 - this.ySize() / 2, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos() + this.xSize() / 2, this.yPos() + this.ySize() / 2, 256 - this.xSize() / 2, 256 - this.ySize() / 2, this.xSize() / 2, this.ySize() / 2);
                for (GuiElement element : this.childElements) {
                    if (!element.isEnabled()) continue;
                    element.renderElement(minecraft, mouseX, mouseY, partialTicks);
                }
            }
        };
    }

    @Deprecated
    public static GuiTexture newVanillaGuiTexture(int xSize, int ySize) {
        return new GuiTexture(0, 0, xSize, ySize, ResourceHelperBC.getResourceRAW("brandonscore:textures/gui/base_vanilla_gui.png")){

            @Override
            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                ResourceHelperBC.bindTexture(this.getTexture());
                this.drawTexturedModalRect(this.xPos(), this.yPos(), 0, 0, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos() + this.xSize() / 2, this.yPos(), 256 - this.xSize() / 2, 0, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos(), this.yPos() + this.ySize() / 2, 0, 256 - this.ySize() / 2, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos() + this.xSize() / 2, this.yPos() + this.ySize() / 2, 256 - this.xSize() / 2, 256 - this.ySize() / 2, this.xSize() / 2, this.ySize() / 2);
                for (GuiElement element : this.childElements) {
                    if (!element.isEnabled()) continue;
                    element.renderElement(minecraft, mouseX, mouseY, partialTicks);
                }
            }
        };
    }

    public static GuiTexture newDynamicTexture(int xSize, int ySize, Supplier<RenderMaterial> materialSupplier) {
        return (GuiTexture)GuiTexture.newDynamicTexture(materialSupplier).setSize(xSize, ySize);
    }

    public static GuiTexture newDynamicTexture(Supplier<RenderMaterial> materialSupplier) {
        return (GuiTexture)new GuiTexture(null){

            @Override
            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                IRenderTypeBuffer.Impl getter = minecraft.func_228019_au_().func_228487_b_();
                this.drawDynamicSprite(getter.getBuffer(BCSprites.GUI_TYPE), this.getMaterial().func_229314_c_(), this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.getInsets().top, this.getInsets().left, this.getInsets().bottom, this.getInsets().right);
                getter.func_228461_a_();
                for (GuiElement element : this.childElements) {
                    if (!element.isEnabled()) continue;
                    element.renderElement(minecraft, mouseX, mouseY, partialTicks);
                }
            }
        }.setMaterialSupplier(materialSupplier).setInsets(4, 4, 4, 4);
    }

    public GuiTexture centerOnParent() {
        if (this.getParent() != null) {
            this.setXPos(this.getParent().xPos() + this.getParent().xSize() / 2 - this.xSize() / 2);
            this.setYPos(this.getParent().yPos() + this.getParent().ySize() / 2 - this.ySize() / 2);
        }
        return this;
    }
}

