/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.lib;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public interface HoverTextSupplier<E extends GuiElement<?>> {
    public Object getText(E var1);

    default public List<String> getHoverText(E element) {
        Object hoverText = this.getText(element);
        if (hoverText instanceof String) {
            if (((String)hoverText).isEmpty()) {
                return Collections.emptyList();
            }
            if (((String)hoverText).contains("\n")) {
                return Arrays.asList(((String)hoverText).split("\n"));
            }
            return Collections.singletonList((String)hoverText);
        }
        if (hoverText instanceof String[]) {
            return HoverTextSupplier.splitNewLines(Arrays.asList((String[])hoverText));
        }
        if (hoverText instanceof List) {
            return HoverTextSupplier.splitNewLines((List)hoverText);
        }
        if (hoverText instanceof ITextComponent) {
            return Collections.singletonList(((ITextComponent)hoverText).getString());
        }
        return Collections.emptyList();
    }

    public static List<String> splitNewLines(Collection<String> collection) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : collection) {
            if (s.contains("\n")) {
                list.addAll(Arrays.asList(s.split("\n")));
                continue;
            }
            list.add(s);
        }
        return list;
    }
}

