/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityElement
extends MDElementBase<EntityElement> {
    private static Map<String, Entity> renderEntityCache = new HashMap<String, Entity>();
    public int xOffset = 0;
    public int yOffset = 0;
    public double rotateSpeed = 0.0;
    public double rotation = 0.0;
    public double drawScale = 1.0;
    public boolean animate = false;
    public boolean trackMouse = false;
    public boolean drawName = false;
    public String mainHand = "";
    public String offHand = "";
    public String head = "";
    public String chest = "";
    public String legs = "";
    public String boots = "";
    private Entity renderEntity = null;
    private String entityName;
    private boolean errored = false;
    boolean animateBroken = false;
    int animTick = 0;

    public EntityElement(String entityName) {
        this.entityName = entityName;
        this.size = 64;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.setSize(this.size, this.size);
        try {
            this.renderEntity = this.getRenderEntity(this.mc.field_71441_e, this.entityName, EquipmentHelper.create(this));
        }
        catch (IllegalArgumentException e) {
            this.error("[Broken Entity. " + e.getMessage() + "]");
        }
        if (this.trackMouse && !(this.renderEntity instanceof LivingEntity)) {
            this.error("[Broken Entity. track_mouse is only supported with living entities]");
        }
        if (this.drawName && !(this.renderEntity instanceof PlayerEntity)) {
            this.error("[Broken Entity. draw_name is only supported by player's]");
        }
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.errored) {
            return;
        }
        int xPos = this.xPos() + this.xOffset;
        int yPos = this.yPos() + this.yOffset;
        try {
            int scale = (int)((double)((float)this.size / Math.max(this.renderEntity.func_213302_cg(), this.renderEntity.func_213311_cf())) * this.drawScale);
            double posX = (double)xPos + (double)this.size / 2.0;
            double entityRotation = this.rotation + (double)((float)BCClientEventHandler.elapsedTicks + partialTicks) * this.rotateSpeed;
            this.renderEntity.field_70173_aa = BCClientEventHandler.elapsedTicks;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)0.0, (double)(25.0f + this.getRenderZLevel() + (float)scale));
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int eyeOffset = (int)((this.renderEntity.func_213302_cg() - this.renderEntity.func_70047_e()) * (float)scale);
            if (this.renderEntity instanceof LivingEntity) {
                EntityElement.drawEntityOnScreen((int)posX, yPos + this.ySize(), scale, (int)posX - mouseX, this.yPos() - mouseY + eyeOffset, (LivingEntity)this.renderEntity, this.trackMouse, entityRotation, this.drawName);
            } else {
                EntityElement.drawEntityOnScreen((int)posX, yPos + this.ySize(), scale, this.renderEntity, entityRotation);
            }
            RenderSystem.popMatrix();
        }
        catch (Throwable e) {
            LogHelperBC.error("Something went wrong while attempting to render an entity on the screen!");
            LogHelperBC.error("Entity: " + this.renderEntity);
            e.printStackTrace();
            this.errored = true;
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.tooltip.isEmpty() && !this.errored && this.renderEntity != null) {
            double ar = this.renderEntity.func_213302_cg() / this.renderEntity.func_213311_cf();
            double width = (double)this.size * this.drawScale;
            double height = (double)this.size * this.drawScale;
            if (ar > 1.0) {
                width *= (double)(this.renderEntity.func_213311_cf() / this.renderEntity.func_213302_cg());
            } else {
                height *= ar;
            }
            int x = (int)((double)(this.xPos() + this.xOffset) + ((double)this.xSize() - width) / 2.0);
            int y = (int)((double)this.yPos() + ((double)this.ySize() - height) + (double)this.yOffset);
            if (GuiHelperOld.isInRect(x, y, (int)width, (int)height, mouseX, mouseY)) {
                this.drawHoveringText(this.tooltip, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                return true;
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, Entity ent, double rotation) {
        RenderSystem.enableColorMaterial();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)posX, (double)posY, (double)50.0);
        RenderSystem.scalef((float)(-scale), (float)scale, (float)scale);
        RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        RenderSystem.rotatef((float)(135.0f + (float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_227780_a_();
        RenderSystem.rotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        RenderSystem.popMatrix();
        RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, LivingEntity ent, boolean trackMouse, double noTrackRotation, boolean drawName) {
        float rotation;
        float f = rotation = trackMouse ? 0.0f : (float)noTrackRotation;
        if (!trackMouse) {
            mouseX = 0.0f;
            mouseY = 0.0f;
        }
        if (ent instanceof EnderDragonEntity && trackMouse) {
            mouseY += (float)(scale * 16);
        }
        RenderSystem.enableColorMaterial();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)50.0f);
        RenderSystem.scalef((float)(-scale), (float)scale, (float)scale);
        RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f22 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        RenderSystem.rotatef((float)(135.0f + rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_227780_a_();
        RenderSystem.rotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        if (ent instanceof EnderDragonEntity) {
            RenderSystem.rotatef((float)ent.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)(-ent.field_70759_as + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        ent.field_70761_aq = f2;
        ent.field_70177_z = f1;
        ent.field_70125_A = f22;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        RenderSystem.popMatrix();
        RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
    }

    public Entity getRenderEntity(ClientWorld world, String entityString, EquipmentHelper helper) {
        String ident = String.format("%s|mh:%s|oh:%s|h:%s|ch:%s|le:%s|bo:%s", entityString, this.mainHand, this.offHand, this.head, this.chest, this.legs, this.boots);
        if (renderEntityCache.containsKey(ident) && !this.animate) {
            return renderEntityCache.get(ident);
        }
        if (!entityString.contains(":")) {
            throw new IllegalArgumentException("Invalid entity string! Must be ether modid:entityName or player:username");
        }
        PlayerEntity entity = null;
        if (entityString.startsWith("player:")) {
            entity = EntityElement.createRenderPlayer(world, entityString.replaceFirst("player:", ""));
        } else {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityString));
            if (type != null) {
                entity = type.func_200721_a((World)world);
            }
        }
        if (entity == null) {
            throw new IllegalArgumentException("No matching entity found for string: " + entityString);
        }
        if (entity instanceof LivingEntity && helper.hasEquipment) {
            helper.apply((LivingEntity)entity);
        } else if (helper.hasEquipment) {
            throw new IllegalArgumentException("The specified entity does not allow equipment!");
        }
        if (!this.animate) {
            renderEntityCache.put(ident, (Entity)entity);
        }
        return entity;
    }

    public static PlayerEntity createRenderPlayer(ClientWorld world, String username) {
        return new RemoteClientPlayerEntity(world, SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, username))){

            public String func_175154_l() {
                return super.func_175154_l();
            }

            public ResourceLocation func_110306_p() {
                ResourceLocation resourcelocation;
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(this.func_146103_bH());
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    UUID uuid = PlayerEntity.func_146094_a((GameProfile)this.func_146103_bH());
                    resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                }
                return resourcelocation;
            }

            public boolean func_175148_a(PlayerModelPart part) {
                return true;
            }
        };
    }

    @Override
    public boolean onUpdate() {
        if (this.animate && this.renderEntity != null && !this.errored && !this.animateBroken && this.animTick != BCClientEventHandler.elapsedTicks) {
            try {
                this.renderEntity.field_70173_aa = this.animTick;
                this.animTick = BCClientEventHandler.elapsedTicks;
                this.renderEntity.func_70071_h_();
            }
            catch (Throwable e) {
                this.animateBroken = true;
            }
        }
        return super.onUpdate();
    }

    static class EquipmentHelper {
        private ItemStack mainHand = ItemStack.field_190927_a;
        private ItemStack offHand = ItemStack.field_190927_a;
        private ItemStack head = ItemStack.field_190927_a;
        private ItemStack chest = ItemStack.field_190927_a;
        private ItemStack legs = ItemStack.field_190927_a;
        private ItemStack boots = ItemStack.field_190927_a;
        public boolean hasEquipment = false;

        EquipmentHelper() {
        }

        public void apply(LivingEntity entity) {
            if (!this.mainHand.func_190926_b()) {
                entity.func_184611_a(Hand.MAIN_HAND, this.mainHand);
            }
            if (!this.offHand.func_190926_b()) {
                entity.func_184611_a(Hand.OFF_HAND, this.offHand);
            }
            if (!this.head.func_190926_b()) {
                entity.func_184201_a(EquipmentSlotType.HEAD, this.head);
            }
            if (!this.chest.func_190926_b()) {
                entity.func_184201_a(EquipmentSlotType.CHEST, this.chest);
            }
            if (!this.legs.func_190926_b()) {
                entity.func_184201_a(EquipmentSlotType.LEGS, this.legs);
            }
            if (!this.boots.func_190926_b()) {
                entity.func_184201_a(EquipmentSlotType.FEET, this.boots);
            }
        }

        public static EquipmentHelper create(EntityElement element) {
            StackReference stackRef;
            EquipmentHelper helper = new EquipmentHelper();
            if (!element.mainHand.isEmpty()) {
                stackRef = StackReference.fromString(element.mainHand);
                if (stackRef == null || (helper.mainHand = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.mainHand);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.offHand.isEmpty()) {
                stackRef = StackReference.fromString(element.offHand);
                if (stackRef == null || (helper.offHand = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.offHand);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.head.isEmpty()) {
                stackRef = StackReference.fromString(element.head);
                if (stackRef == null || (helper.head = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.head);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.chest.isEmpty()) {
                stackRef = StackReference.fromString(element.chest);
                if (stackRef == null || (helper.chest = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.chest);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.legs.isEmpty()) {
                stackRef = StackReference.fromString(element.legs);
                if (stackRef == null || (helper.legs = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.legs);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.boots.isEmpty()) {
                stackRef = StackReference.fromString(element.boots);
                if (stackRef == null || (helper.boots = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.boots);
                } else {
                    helper.hasEquipment = true;
                }
            }
            return helper;
        }
    }
}

