/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Cuboid6;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.brandonscore.lib.ScissorHelper;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;

public class ImageElement
extends MDElementBase<ImageElement> {
    private static final Random rand = new Random();
    private static final List<Block> LOADING_BLOCKS = Lists.newArrayList((Object[])new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150349_c, Blocks.field_150347_e, Blocks.field_196617_K, Blocks.field_150359_w, Blocks.field_150391_bh, Blocks.field_150486_ae, Blocks.field_150381_bn, Blocks.field_150462_ai, Blocks.field_150467_bQ, Blocks.field_150461_bJ, Blocks.field_150342_X, Blocks.field_150482_ag, Blocks.field_150343_Z, Blocks.field_150346_d, Blocks.field_150367_z, Blocks.field_150460_al, Blocks.field_150407_cf});
    private ItemStack renderLoadingStack = ItemStack.field_190927_a;
    private int loadingTime = 0;
    private int maxLoadTime = 40;
    private boolean downloading = false;
    private MDElementContainer container;
    private String imageURL;
    private DLResourceLocation resourceLocation;
    public String linkTo = "";

    public ImageElement(MDElementContainer container, String imageURL) {
        this.container = container;
        this.imageURL = imageURL;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.resourceLocation = DLRSCache.getResource(this.imageURL);
        int w = 0;
        int h = 0;
        if (!this.resourceLocation.dlFinished || this.resourceLocation.dlFailed) {
            w = 76;
            h = 76;
            this.downloading = true;
        } else {
            if (this.width == -1 && this.height == -1) {
                this.width = 32;
            }
            if (this.width != -1) {
                int n = w = this.screenRelativeSize ? (int)(MathHelper.clip((double)((double)this.width / 100.0), (double)0.0, (double)1.0) * (double)layout.getWidth()) : MathHelper.clip((int)this.width, (int)8, (int)layout.getWidth());
                if (this.height == -1) {
                    h = this.resourceLocation.sizeSet ? (int)((double)this.resourceLocation.height / (double)this.resourceLocation.width * (double)w) : w;
                }
            }
            if (this.height != -1) {
                h = this.height;
                if (this.width == -1) {
                    w = this.resourceLocation.sizeSet ? (int)((double)this.resourceLocation.width / (double)this.resourceLocation.height * (double)this.height) : this.height;
                }
            }
        }
        this.setSize(w, h);
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.downloading) {
            this.renderDownloading(partialTicks);
        } else {
            ResourceHelperBC.bindTexture(this.resourceLocation);
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            if (this.hasColourBorder) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.getColourBorder(mouseOver));
            } else if (this.hasColourBorderHover && mouseOver) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.colourBorderHover);
            }
            int w = this.xSize() - this.rightPad - this.leftPad;
            int h = this.ySize() - this.bottomPad - this.topPad;
            RenderSystem.enableBlend();
            this.container.drawModalRectWithCustomSizedTexture(this.xPos() + this.leftPad, this.yPos() + this.topPad, 0.0f, 0.0f, w, h, w, h);
            RenderSystem.disableBlend();
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    private void renderDownloading(float partialTicks) {
        boolean failed = this.resourceLocation.dlFailed;
        float failTicks = failed ? 0.0f : partialTicks;
        this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, 0, failed ? -65536 : -16711936);
        float anim = 74.0f * (((float)this.loadingTime + failTicks) / (float)this.maxLoadTime);
        this.bindTexture(BCSprites.MODULAR_GUI);
        float texAnim = Math.max(0.0f, (1.0f - anim / 64.0f) * 48.0f);
        float texX = (float)this.xPos() + (float)this.xSize() / 2.0f - 20.0f;
        float texY = Math.max((float)(this.yPos() - 48) + (48.0f - texAnim) * 2.0f, (float)this.yPos());
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)(this.getRenderZLevel() + 200.0f));
        this.drawScaledCustomSizeModalRect(texX, texY + 1.0f, failed ? 20.0f : 0.0f, 18.0f + (24.0f - Math.min(24.0f, 48.0f - texAnim)), 20.0f, Math.min(Math.min(24.0f, 48.0f - texAnim), texAnim), 40.0f, Math.min(Math.min(48.0f, (48.0f - texAnim) * 2.0f), texAnim * 2.0f), 256.0f, 256.0f);
        RenderSystem.translated((double)((double)this.xPos() + (double)this.xSize() / 2.0), (double)(this.yPos() + this.ySize() - 32), (double)0.0);
        RenderSystem.rotatef((float)(((float)BCClientEventHandler.elapsedTicks + partialTicks) * 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.scaled((double)-64.0, (double)-64.0, (double)-64.0);
        RenderSystem.rotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ScissorHelper.pushGuiScissor(this.mc, this.xPos(), (float)this.maxYPos() - anim, this.xSize(), anim, this.screenWidth, this.screenHeight);
        RenderHelper.func_227780_a_();
        RenderSystem.pushMatrix();
        double shrink = 1.0 - MathHelper.clip((double)((double)(anim - 64.0f) / 10.0), (double)0.0, (double)1.0);
        RenderSystem.scaled((double)shrink, (double)shrink, (double)shrink);
        this.mc.func_175599_af().func_175042_a(this.renderLoadingStack, 0, 0);
        RenderSystem.popMatrix();
        RenderHelper.func_74518_a();
        ScissorHelper.popScissor();
        Cuboid6 cuboid6 = new Cuboid6(-0.251, -0.251, -0.251, 0.251, 0.251, 0.251);
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (failed) {
            r = 0.0f;
            g = 0.0f;
            b = 0.0f;
        }
        GuiHelperOld.renderCuboid(cuboid6, r, g, b, 1.0f);
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (!this.linkTo.isEmpty() && this.container.linkDisplayTarget != null) {
                GuiElement e = this.container.linkDisplayTarget;
                int width = this.fontRenderer.func_78256_a(this.linkTo);
                int height = this.fontRenderer.func_78267_b(this.linkTo, e.xSize()) + 4;
                this.zOffset += (double)this.container.linkDisplayZOffset;
                this.drawColouredRect(e.xPos(), e.maxYPos() - height, Math.min(Math.max(width + 4, e.xSize() / 2), e.xSize()), height, -1879048192);
                this.drawSplitString(this.fontRenderer, this.linkTo, e.xPos() + 2, e.maxYPos() - height + 2, e.xSize(), 0xC0C0C0, false);
                this.zOffset -= (double)this.container.linkDisplayZOffset;
            }
            ArrayList<String> tooltip = new ArrayList<String>();
            if (this.resourceLocation.dlFailed) {
                tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.bc.downloading_image_failed.info", (Object[])new Object[0]));
            } else if (!this.resourceLocation.dlFinished) {
                tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.bc.downloading_image.info", (Object[])new Object[0]));
            }
            if (this.enableTooltip && !this.tooltip.isEmpty()) {
                tooltip.addAll(this.tooltip);
            }
            if (!tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                return true;
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (mouseButton == 0 && Screen.func_231173_s_()) {
                DLRSCache.clearResourceCache(this.imageURL);
                DLRSCache.clearFileCache(this.imageURL);
                this.container.layoutMarkdownElements();
                this.loadingTime = 0;
                return true;
            }
            if (mouseButton != 1 && !this.linkTo.isEmpty()) {
                this.container.handleLinkClick(this.linkTo, mouseButton);
                return true;
            }
            if (mouseButton == 1) {
                this.container.handleLinkClick(this.imageURL, mouseButton);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onUpdate() {
        if (this.resourceLocation != null) {
            if (!this.resourceLocation.dlFinished || this.resourceLocation.dlFailed || this.loadingTime > 0) {
                if (this.loadingTime == 0) {
                    this.renderLoadingStack = new ItemStack((IItemProvider)LOADING_BLOCKS.get(rand.nextInt(LOADING_BLOCKS.size())));
                }
                ++this.loadingTime;
                if (this.resourceLocation.dlFailed && this.loadingTime == this.maxLoadTime / 2) {
                    this.loadingTime = this.maxLoadTime / 2 - 1;
                }
                if (this.loadingTime >= this.maxLoadTime) {
                    this.loadingTime = 0;
                }
                if (this.resourceLocation.dlStateChanged()) {
                    this.container.getTopLevelContainer().layoutMarkdownElements();
                    this.downloading = false;
                    return true;
                }
            } else if (this.downloading) {
                this.loadingTime = 0;
                this.downloading = false;
                this.container.getTopLevelContainer().layoutMarkdownElements();
                return true;
            }
        }
        return super.onUpdate();
    }
}

