/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.hud;

import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.api.hud.IHudDisplay;
import com.brandon3055.brandonscore.api.hud.IHudItem;
import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;

public class HudDataElement
extends AbstractHudElement {
    private final boolean iHudItem;
    private final boolean iHudBlock;
    private IHudDisplay activeHud = null;
    private List<ITextComponent> displayList = new ArrayList<ITextComponent>();

    public HudDataElement(Vector2 defaultPos, boolean iHudItem, boolean iHudBlock) {
        super(defaultPos);
        this.iHudItem = iHudItem;
        this.iHudBlock = iHudBlock;
    }

    @Override
    public void tick(boolean configuring) {
        RayTraceResult traceResult;
        this.activeHud = null;
        this.displayList.clear();
        this.width = 145.0;
        this.height = 30.0;
        if (!this.enabled) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.iHudBlock && (traceResult = Minecraft.func_71410_x().field_71439_g.func_213324_a(5.0, 0.0f, false)) instanceof BlockRayTraceResult && traceResult.func_216346_c() != RayTraceResult.Type.MISS) {
            BlockPos pos = ((BlockRayTraceResult)traceResult).func_216350_a();
            BlockState state = player.field_70170_p.func_180495_p(pos);
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (state.func_177230_c() instanceof IHudBlock) {
                this.activeHud = (IHudBlock)state.func_177230_c();
            } else if (tile instanceof IHudBlock) {
                this.activeHud = (IHudBlock)tile;
            }
            if (this.activeHud != null && ((IHudBlock)this.activeHud).shouldDisplayHudText(player.field_70170_p, pos, (PlayerEntity)player)) {
                ((IHudBlock)this.activeHud).generateHudText(player.field_70170_p, pos, (PlayerEntity)player, this.displayList);
            } else {
                this.activeHud = null;
            }
        }
        if (this.iHudItem && this.activeHud == null) {
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IHudItem) || !((IHudItem)stack.func_77973_b()).shouldDisplayHudText(stack, (PlayerEntity)player)) {
                stack = player.func_184592_cb();
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IHudItem) {
                this.activeHud = (IHudItem)stack.func_77973_b();
                if (((IHudItem)this.activeHud).shouldDisplayHudText(stack, (PlayerEntity)player)) {
                    ((IHudItem)this.activeHud).generateHudText(stack, (PlayerEntity)player, this.displayList);
                } else {
                    this.activeHud = null;
                }
            }
        }
        if (this.activeHud != null) {
            Minecraft mc = Minecraft.func_71410_x();
            this.width = this.activeHud.computeHudWidth(mc, this.displayList);
            this.height = this.activeHud.computeHudHeight(mc, this.displayList);
        }
    }

    @Override
    public void render(MatrixStack mStack, float partialTicks, boolean configuring) {
        if (!this.enabled || this.activeHud == null && !configuring) {
            return;
        }
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        mStack.func_227861_a_(this.xPos(), this.yPos(), 0.0);
        if (this.activeHud == null) {
            GuiHelper.drawHoverRect((IRenderTypeBuffer)getter, mStack, 0.0, 0.0, this.width(), this.height());
            getter.func_228461_a_();
            return;
        }
        this.activeHud.renderHudBackground((IRenderTypeBuffer)getter, mStack, this.width(), this.height(), this.displayList);
        getter.func_228461_a_();
        this.activeHud.renderHudContent(Minecraft.func_71410_x().field_71466_p, mStack, this.width(), this.height(), this.displayList);
    }
}

