/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.utils;

import com.brandon3055.brandonscore.api.TimeKeeper;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class CyclingItemGroup
extends ItemGroup {
    private Supplier<Object[]> iconSupplier;
    private int iconIndex = 0;
    private int lastIndex = 0;
    private int cycleRate = 20;
    private ItemStack icon;
    public int timeOffset = 0;
    private List<ResourceLocation> sortOrder = null;

    public CyclingItemGroup(String label, Supplier<Object[]> iconSupplier) {
        super(label);
        this.iconSupplier = iconSupplier;
    }

    public CyclingItemGroup(String label, int cycleRate, Supplier<Object[]> iconSupplier) {
        super(label);
        this.iconSupplier = iconSupplier;
        this.cycleRate = cycleRate;
    }

    public CyclingItemGroup(String label, Supplier<Object[]> iconSupplier, List<ResourceLocation> sortOrder) {
        super(label);
        this.iconSupplier = iconSupplier;
        this.sortOrder = sortOrder;
    }

    public CyclingItemGroup(String label, int cycleRate, Supplier<Object[]> iconSupplier, List<ResourceLocation> sortOrder) {
        super(label);
        this.iconSupplier = iconSupplier;
        this.cycleRate = cycleRate;
        this.sortOrder = sortOrder;
    }

    @Nonnull
    public ItemStack func_78016_d() {
        ItemStack stack;
        Object[] icons = this.iconSupplier.get();
        Object obj = icons[this.iconIndex % icons.length];
        ItemStack itemStack = obj instanceof ItemStack ? (ItemStack)obj : (stack = new ItemStack((IItemProvider)(obj instanceof Item ? (Item)obj : (Block)obj)));
        if (this.icon == null || !stack.func_190926_b()) {
            return stack;
        }
        ++this.iconIndex;
        return this.func_78016_d();
    }

    public ItemStack func_151244_d() {
        int index = (TimeKeeper.getClientTick() + this.timeOffset) / this.cycleRate;
        if (this.icon == null || index != this.lastIndex) {
            this.lastIndex = index;
            ++this.iconIndex;
            this.icon = this.func_78016_d();
        }
        return this.icon;
    }

    public CyclingItemGroup setOffset(int timeOffset) {
        this.timeOffset = timeOffset;
        return this;
    }

    public void func_78018_a(NonNullList<ItemStack> items) {
        if (this.sortOrder != null) {
            NonNullList sortedItems = NonNullList.func_191196_a();
            for (Item item : Registry.field_212630_s) {
                item.func_150895_a((ItemGroup)this, sortedItems);
            }
            sortedItems.sort(Comparator.comparingInt(value -> this.sortOrder.indexOf(value.func_77973_b().getRegistryName())));
            items.addAll((Collection)sortedItems);
        } else {
            super.func_78018_a(items);
        }
    }
}

